/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum;

import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum.Calculator;
import net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum.FunctionController;
import net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum.RowColSumLayoutListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum.SumAndColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class SumFunctionController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SumFunctionController.class);
    private JTextField _txtSum = GUIUtils.styleTextFieldToCopyableLabel(new JTextField());
    private final JPanel _panel = new JPanel(new GridLayout(2, 1));
    private String _currentRenderedSum;
    private FunctionController _functionController;
    private DataSetViewerTable _currentTable;
    private RowColSumLayoutListener _rowColSumLayoutListener;

    public SumFunctionController() {
        this._panel.add(this._txtSum);
        JLabel lblMore = new JLabel(s_stringMgr.getString("SumFunctionController.more.html"));
        lblMore.setCursor(Cursor.getPredefinedCursor(12));
        this._panel.add(lblMore);
        this._txtSum.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SumFunctionController.this.onMousePressedOnSum(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SumFunctionController.this.onMousePressedOnSum(e);
            }
        });
        lblMore.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SumFunctionController.this.onMore();
            }
        });
    }

    private void onMore() {
        if (null == this.getFunctionController()) {
            this._functionController = new FunctionController(this._panel);
            if (null != this._currentTable) {
                this._functionController.update(this._currentTable);
            }
        }
    }

    private FunctionController getFunctionController() {
        if (null == this._functionController || this._functionController.isDisposed()) {
            return null;
        }
        return this._functionController;
    }

    private void onMousePressedOnSum(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(s_stringMgr.getString("SumFunctionController.copy"));
        menuItem.addActionListener(ae -> this.onCopy());
        popupMenu.add(menuItem);
        popupMenu.show(this._txtSum, e.getX(), e.getY());
    }

    private void onCopy() {
        if (StringUtilities.isEmpty(this._txtSum.getSelectedText(), true)) {
            if (null != this._currentRenderedSum) {
                StringSelection ss = new StringSelection(this._currentRenderedSum);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
            }
        } else {
            StringSelection ss = new StringSelection(this._txtSum.getSelectedText());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
        }
    }

    public JPanel getPanel() {
        return this._panel;
    }

    void onSelectionChanged(DataSetViewerTable table) {
        this._currentTable = table;
        SumAndColumn sumAndColumn = null;
        if (null != this.getFunctionController()) {
            ArrayList<SumAndColumn> sumAndColumns = this.getFunctionController().update(table);
            if (0 < sumAndColumns.size()) {
                sumAndColumn = sumAndColumns.get(0);
            }
        } else {
            sumAndColumn = Calculator.calculateFirstSum(table);
        }
        if (null == sumAndColumn) {
            this._txtSum.setText(s_stringMgr.getString("SumFunctionController.no.sumable.row"));
        } else {
            String colName = sumAndColumn.getColumnDisplayDefinition().getColumnName();
            this._currentRenderedSum = CellComponentFactory.getDataTypeObject(table, sumAndColumn.getColumnDisplayDefinition()).renderObject(sumAndColumn.getSum());
            this._txtSum.setText("\u03a3(" + colName + ") = " + this._currentRenderedSum);
        }
        if (null != this._rowColSumLayoutListener && null != this._txtSum.getText() && this._txtSum.getSize().width < this._txtSum.getFontMetrics(this._txtSum.getFont()).stringWidth(this._txtSum.getText())) {
            this._rowColSumLayoutListener.rowColSumLayoutDone();
        }
    }

    public void setRowColSumLayoutListener(RowColSumLayoutListener rowColSumLayoutListener) {
        this._rowColSumLayoutListener = rowColSumLayoutListener;
    }
}

