/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandler;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandlerUtil;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanelPosition;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTabCounter;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.BaseSQLTab;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.ResizableTextEditDialog;
import net.sourceforge.squirrel_sql.fw.gui.buttontabcomponent.ButtonTabComponent;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class AdditionalSQLTab
extends BaseSQLTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AdditionalSQLTab.class);
    private final int _tabNumber;
    private final ButtonTabComponent _tabComponent;
    private TitleFilePathHandler _titleFileHandler;
    private String _titleWithoutFile;

    public AdditionalSQLTab(ISession session) {
        super(session);
        session.addSimpleSessionListener(() -> this.onClose(false));
        AdditionalSQLTabCounter additionalSQLTabCounter = (AdditionalSQLTabCounter)session.getSessionLocal(AdditionalSQLTabCounter.class);
        if (null == additionalSQLTabCounter) {
            additionalSQLTabCounter = new AdditionalSQLTabCounter();
            session.putSessionLocal(AdditionalSQLTabCounter.class, additionalSQLTabCounter);
        }
        this._tabNumber = additionalSQLTabCounter.nextNumber();
        this._titleWithoutFile = s_stringMgr.getString("AdditionalSQLTab.title", this._tabNumber);
        ImageIcon icon = Main.getApplication().getResources().getIcon("add_tab");
        this._titleFileHandler = new TitleFilePathHandler(() -> this.setTitle(this._titleWithoutFile));
        this._tabComponent = new ButtonTabComponent(this._titleWithoutFile, icon);
        this._tabComponent.getClosebutton().addActionListener(e -> this.onClose(true));
        this._tabComponent.getToWindowButton().setVisible(false);
    }

    @Override
    protected SQLPanel createSqlPanel() {
        return new SQLPanel(this.getSession(), SQLPanelPosition.ADDITIONAL_TAB_IN_SESSION_WINDOW, this._titleFileHandler);
    }

    private void setTitle(String title) {
        this._titleWithoutFile = title;
        TitleFilePathHandlerUtil.setTitle(this._titleWithoutFile, this._titleFileHandler, this._tabComponent);
    }

    public void setTitleWithoutFile(String titleWithoutFile) {
        this._titleWithoutFile = titleWithoutFile;
    }

    public String getTitleWithoutFile() {
        return this._titleWithoutFile;
    }

    @Override
    public void mouseWheelClickedOnTabComponent() {
        this._tabComponent.doClickClose();
    }

    @Override
    public void rightMouseClickedOnTabComponent(int clickPosX, int clickPosY) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem mnuRename = new JMenuItem(s_stringMgr.getString("AdditionalSQLTab.tab.popup.rename"));
        mnuRename.addActionListener(e -> this.onRenameTab());
        popupMenu.add(mnuRename);
        popupMenu.show(this._tabComponent, clickPosX, clickPosY);
    }

    private void onRenameTab() {
        ResizableTextEditDialog dlg = new ResizableTextEditDialog(GUIUtils.getOwningWindow(this.getTabComponent()), this.getClass().getName(), s_stringMgr.getString("AdditionalSQLTab.rename.dlg.title"), s_stringMgr.getString("AdditionalSQLTab.rename.dlg.label"), this._titleWithoutFile);
        if (!dlg.isOk()) {
            return;
        }
        this.setTitle(dlg.getEditedText());
    }

    @Override
    public Component getTabComponent() {
        return this._tabComponent;
    }

    private void onClose(boolean callConfirmClose) {
        this.close(callConfirmClose);
    }

    public void close(boolean callConfirmClose) {
        if (callConfirmClose && this.getSQLPanel().getSQLPanelAPI().confirmClose()) {
            this.getSession().getSessionPanel().removeMainTab(this);
        }
        this.getSQLPanel().sessionWorksheetOrTabClosing();
    }

    @Override
    public String getHint() {
        return s_stringMgr.getString("AdditionalSQLTab.tooltip", this._tabNumber);
    }
}

