/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ObjectTreePosition;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.props.Props;

public class SQLPanelSplitter
extends JPanel {
    private static final String PREF_OBJECT_TREE_SPLIT_DIVIDER_LOC = "SQLPanelSplitter.PREF_OBJECT_TREE_SPLIT_DIVIDER_LOC";
    private final JSplitPane _splitPane;
    private SQLPanel _sqlPanel;
    private ObjectTreePanel _objectTreePanel;
    private int _standardDividerSize;

    public SQLPanelSplitter(SQLPanel sqlPanel) {
        this._sqlPanel = sqlPanel;
        this.setLayout(new GridLayout(1, 1));
        this._splitPane = new JSplitPane();
        this._standardDividerSize = this._splitPane.getDividerSize();
        this._sqlPanel.setMinimumSize(new Dimension(0, 0));
        this._splitPane.setRightComponent(this._sqlPanel);
        JPanel empty = new JPanel();
        empty.setMaximumSize(new Dimension(0, 0));
        this._splitPane.setLeftComponent(empty);
        this.add(this._splitPane);
        this._showObjectTree(false, false);
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SQLPanelSplitter.this.onComponentResized();
            }
        };
        this.addComponentListener(componentAdapter);
        empty.addComponentListener(componentAdapter);
    }

    private void onComponentResized() {
        if (!this.isSplit()) {
            this._splitPane.setDividerLocation(0);
        }
    }

    public void split(boolean b) {
        this._showObjectTree(b, true);
    }

    private void _showObjectTree(boolean visible, boolean rememberWidthOnHide) {
        if (visible) {
            if (null == this._objectTreePanel) {
                this.initObjectTree();
            }
            this._splitPane.setDividerLocation(Props.getInt(PREF_OBJECT_TREE_SPLIT_DIVIDER_LOC, this._sqlPanel.getWidth() / 2));
            this._splitPane.setDividerSize(this._standardDividerSize);
            this._splitPane.setOneTouchExpandable(true);
        } else {
            if (rememberWidthOnHide) {
                this.saveDividerLocation();
            }
            this._splitPane.setDividerSize(0);
            this._splitPane.setDividerLocation(0);
            this._splitPane.setOneTouchExpandable(false);
        }
    }

    private void initObjectTree() {
        this._objectTreePanel = new ObjectTreePanel(this._sqlPanel.getSession(), ObjectTreePosition.OBJECT_TREE_BESIDES_SQL_PANEL);
        this._objectTreePanel.setMinimumSize(new Dimension(0, 0));
        this._splitPane.setLeftComponent(this._objectTreePanel);
        SwingUtilities.invokeLater(() -> Main.getApplication().getPluginManager().objectTreeInSQLTabOpened(this._objectTreePanel));
    }

    private void saveDividerLocation() {
        Props.putInt(PREF_OBJECT_TREE_SPLIT_DIVIDER_LOC, this._splitPane.getDividerLocation());
    }

    public void sessionWindowClosing() {
        if (this.isSplit()) {
            this.saveDividerLocation();
        }
        if (null != this._objectTreePanel) {
            this._objectTreePanel.sessionWindowClosing();
        }
    }

    public boolean isSplit() {
        return 0 < this._splitPane.getDividerSize();
    }

    public IIdentifier getFindEntryPanelIdentifier() {
        if (null == this._objectTreePanel) {
            return null;
        }
        return this._objectTreePanel.getFindController().getFindEntryPanel().getIdentifier();
    }

    public ObjectTreePanel getObjectTreePanel() {
        return this._objectTreePanel;
    }
}

