/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.menuattic;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.menuattic.AtticToFromDlg;
import net.sourceforge.squirrel_sql.client.session.menuattic.AtticToFromItem;
import net.sourceforge.squirrel_sql.client.session.menuattic.AtticToFromModel;
import net.sourceforge.squirrel_sql.client.session.menuattic.MenuOrigin;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;

public class AtticToFromCtrl {
    private final AtticToFromDlg _dlg;

    public AtticToFromCtrl(AtticToFromModel atticToFromModel, MenuOrigin menuOrigin) {
        this._dlg = new AtticToFromDlg(menuOrigin);
        ArrayList<AtticToFromItem> inAtticList = new ArrayList<AtticToFromItem>();
        ArrayList<AtticToFromItem> outAtticList = new ArrayList<AtticToFromItem>();
        for (AtticToFromItem atticToFromItem : atticToFromModel.getAtticToFromItems()) {
            if (Main.getApplication().getPopupMenuAtticModel().isInAttic(menuOrigin, atticToFromItem)) {
                inAtticList.add(atticToFromItem);
                continue;
            }
            outAtticList.add(atticToFromItem);
        }
        this._dlg.lstInAttic.setModel(new DefaultListModel());
        this._dlg.lstInAttic.setSelectionMode(2);
        inAtticList.sort(Comparator.comparing(AtticToFromItem::getIndex));
        this.getModel(this._dlg.lstInAttic).addAll(inAtticList);
        this._dlg.lstOutAttic.setModel(new DefaultListModel());
        this._dlg.lstOutAttic.setSelectionMode(2);
        outAtticList.sort(Comparator.comparing(AtticToFromItem::getIndex));
        this.getModel(this._dlg.lstOutAttic).addAll(outAtticList);
        this._dlg.btnMoveOutAttic.addActionListener(e -> this.onMove(true));
        this._dlg.btnMoveInAttic.addActionListener(e -> this.onMove(false));
        this._dlg.btnOk.addActionListener(e -> this.onOk(menuOrigin));
        this._dlg.btnCancel.addActionListener(e -> this.close());
        GUIUtils.initLocation(this._dlg, 500, 700);
        GUIUtils.enableCloseByEscape(this._dlg);
        this._dlg.setVisible(true);
    }

    private void onOk(MenuOrigin menuOrigin) {
        List<AtticToFromItem> inAtticList = Stream.of(this.getModel(this._dlg.lstInAttic).toArray()).map(o -> (AtticToFromItem)o).collect(Collectors.toList());
        Main.getApplication().getPopupMenuAtticModel().setAttic(menuOrigin, inAtticList);
        this.close();
    }

    private void close() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private DefaultListModel<AtticToFromItem> getModel(JList<AtticToFromItem> lst) {
        return (DefaultListModel)lst.getModel();
    }

    private void onMove(boolean moveOutAttic) {
        if (moveOutAttic) {
            this.move(this._dlg.lstInAttic, this._dlg.lstOutAttic);
        } else {
            this.move(this._dlg.lstOutAttic, this._dlg.lstInAttic);
        }
    }

    private void move(JList<AtticToFromItem> lstFrom, JList<AtticToFromItem> lstTo) {
        List<AtticToFromItem> selectedValuesList = lstFrom.getSelectedValuesList();
        if (selectedValuesList.isEmpty()) {
            return;
        }
        selectedValuesList.forEach(v -> this.getModel(lstFrom).removeElement(v));
        ArrayList<AtticToFromItem> buf = new ArrayList<AtticToFromItem>();
        List.of(this.getModel(lstTo).toArray()).forEach(o -> buf.add((AtticToFromItem)o));
        buf.addAll(selectedValuesList);
        buf.sort(Comparator.comparing(AtticToFromItem::getIndex));
        this.getModel(lstTo).clear();
        this.getModel(lstTo).addAll(buf);
        int[] selectedIndices = new int[selectedValuesList.size()];
        int curIx = 0;
        for (int i = 0; i < buf.size(); ++i) {
            AtticToFromItem item = (AtticToFromItem)buf.get(i);
            if (!selectedValuesList.contains(item)) continue;
            selectedIndices[curIx++] = i;
        }
        lstTo.setSelectedIndices(selectedIndices);
        lstTo.scrollRectToVisible(lstTo.getCellBounds(selectedIndices[0], selectedIndices[0] + 1));
    }
}

