/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.menuattic;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.squirrel_sql.client.session.menuattic.AtticToFromItem;
import net.sourceforge.squirrel_sql.client.session.menuattic.MenuAtticUtil;
import net.sourceforge.squirrel_sql.client.session.menuattic.MenuOrigin;
import net.sourceforge.squirrel_sql.client.session.menuattic.PopupMenuAtticItemJsonBean;
import net.sourceforge.squirrel_sql.client.session.menuattic.PopupMenuAtticJsonBean;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.util.JsonMarshalUtil;

public class PopupMenuAtticModel {
    private PopupMenuAtticJsonBean _popupMenuAtticJsonBean = null;

    public boolean isInAttic(MenuOrigin menuOrigin, AtticToFromItem item) {
        this.init();
        String menuText = MenuAtticUtil.getMenuText(item.getMenuItem());
        return this.getOrCreateMenuAtticItemJsonBean(menuOrigin).getMenuTexts().contains(menuText);
    }

    private PopupMenuAtticItemJsonBean getOrCreateMenuAtticItemJsonBean(MenuOrigin menuOrigin) {
        for (PopupMenuAtticItemJsonBean popupMenuAtticItemJsonBean : this._popupMenuAtticJsonBean.getPopupMenuAtticItemJsonBeans()) {
            if (popupMenuAtticItemJsonBean.getMenuOrigin() != menuOrigin) continue;
            return popupMenuAtticItemJsonBean;
        }
        PopupMenuAtticItemJsonBean ret = new PopupMenuAtticItemJsonBean();
        ret.setMenuOrigin(menuOrigin);
        this._popupMenuAtticJsonBean.getPopupMenuAtticItemJsonBeans().add(ret);
        return ret;
    }

    public void setAttic(MenuOrigin menuOrigin, List<AtticToFromItem> inAtticList) {
        this.init();
        ArrayList<String> texts = new ArrayList<String>(inAtticList.stream().map(i -> i.getMenuText()).collect(Collectors.toList()));
        this.getOrCreateMenuAtticItemJsonBean(menuOrigin).setMenuTexts(texts);
        JsonMarshalUtil.writeObjectToFile(new ApplicationFiles().getPopupMenuAtticFile(), this._popupMenuAtticJsonBean);
    }

    private void init() {
        if (null != this._popupMenuAtticJsonBean) {
            return;
        }
        this._popupMenuAtticJsonBean = new PopupMenuAtticJsonBean();
        if (new ApplicationFiles().getPopupMenuAtticFile().exists()) {
            this._popupMenuAtticJsonBean = JsonMarshalUtil.readObjectFromFileSave(new ApplicationFiles().getPopupMenuAtticFile(), PopupMenuAtticJsonBean.class, this._popupMenuAtticJsonBean);
        }
    }
}

