/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.messagepanel;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.session.messagepanel.MessagePanelStylePreferenceWrapper;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.BaseAction;
import net.sourceforge.squirrel_sql.fw.gui.stdtextpopup.TextPopupMenu;
import net.sourceforge.squirrel_sql.fw.util.DefaultExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.ExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class MessagePanel
extends JTextPane
implements IMessageHandler {
    private static final ILogger s_log = LoggerController.createLogger(MessagePanel.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MessagePanel.class);
    private final TextPopupMenu _popupMenu = new MessagePanelPopupMenu();
    private SimpleAttributeSet _saSetMessage;
    private SimpleAttributeSet _saSetMessageHistory;
    private SimpleAttributeSet _saSetWarning;
    private SimpleAttributeSet _saSetWarningHistory;
    private SimpleAttributeSet _saSetError;
    private SimpleAttributeSet _saSetErrorHistory;
    private int _lastLength;
    private String _lastMessage;
    private SimpleAttributeSet _lastSaSet;
    private DefaultExceptionFormatter defaultExceptionFormatter = new DefaultExceptionFormatter();

    public MessagePanel() {
        this._saSetMessage = new SimpleAttributeSet();
        this._saSetMessageHistory = new SimpleAttributeSet();
        this._saSetWarning = new SimpleAttributeSet();
        this._saSetWarningHistory = new SimpleAttributeSet();
        this._saSetError = new SimpleAttributeSet();
        this._saSetErrorHistory = new SimpleAttributeSet();
        this.applyMessagePanelStyle(Main.getApplication().getSquirrelPreferences());
        this.initPopup();
    }

    public void applyMessagePanelStyle(SquirrelPreferences prefs) {
        MessagePanelStylePreferenceWrapper wrp = new MessagePanelStylePreferenceWrapper(prefs);
        if (wrp.isSetMessageBackground()) {
            StyleConstants.setBackground(this._saSetMessage, wrp.getMessageBackground());
        }
        if (wrp.isSetMessageForeground()) {
            StyleConstants.setForeground(this._saSetMessage, wrp.getMessageForeground());
        }
        if (wrp.isSetMessageHistoryBackground()) {
            StyleConstants.setBackground(this._saSetMessageHistory, wrp.getMessageHistoryBackground());
        }
        if (wrp.isSetMessageHistoryForeground()) {
            StyleConstants.setForeground(this._saSetMessageHistory, wrp.getMessageHistoryForeground());
        }
        if (wrp.isSetWarningBackground()) {
            StyleConstants.setBackground(this._saSetWarning, wrp.getWarningBackground());
        }
        if (wrp.isSetWarningForeground()) {
            StyleConstants.setForeground(this._saSetWarning, wrp.getWarningForeground());
        }
        if (wrp.isSetWarningHistoryBackground()) {
            StyleConstants.setBackground(this._saSetWarningHistory, wrp.getWarningHistoryBackground());
        }
        if (wrp.isSetWarningHistoryForeground()) {
            StyleConstants.setForeground(this._saSetWarningHistory, wrp.getWarningHistoryForeground());
        }
        if (wrp.isSetErrorBackground()) {
            StyleConstants.setBackground(this._saSetError, wrp.getErrorBackground());
        }
        if (wrp.isSetErrorForeground()) {
            StyleConstants.setForeground(this._saSetError, wrp.getErrorForeground());
        }
        if (wrp.isSetErrorHistoryBackground()) {
            StyleConstants.setBackground(this._saSetErrorHistory, wrp.getErrorHistoryBackground());
        }
        if (wrp.isSetErrorHistoryForeground()) {
            StyleConstants.setForeground(this._saSetErrorHistory, wrp.getErrorHistoryForeground());
        }
    }

    private SimpleAttributeSet getHistorySaSet(SimpleAttributeSet saSet) {
        if (saSet == this._saSetMessage) {
            return this._saSetMessageHistory;
        }
        if (saSet == this._saSetWarning) {
            return this._saSetWarningHistory;
        }
        if (saSet == this._saSetError) {
            return this._saSetErrorHistory;
        }
        throw new IllegalArgumentException("Don't know any history SimpleAttributeSet for " + saSet);
    }

    private void initPopup() {
        this._popupMenu.setTextComponent(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    MessagePanel.this._popupMenu.show(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    MessagePanel.this._popupMenu.show(evt);
                }
            }
        });
    }

    public void addToMessagePanelPopup(Action action) {
        this._popupMenu.add(action);
    }

    @Override
    public synchronized void showMessage(Throwable th, ExceptionFormatter formatter) {
        this.privateShowMessage(th, formatter, this._saSetMessage);
    }

    @Override
    public synchronized void showErrorMessage(Throwable th, ExceptionFormatter formatter) {
        this.privateShowMessage(th, formatter, this._saSetError);
    }

    @Override
    public void showErrorMessage(String msg, Throwable ex) {
        this.addLineOnEDT(msg + " | " + Utilities.getExceptionStringSave(ex), this._saSetError);
    }

    @Override
    public synchronized void showMessage(String msg) {
        this.privateShowMessage(msg, this._saSetMessage);
    }

    @Override
    public void showWarningMessage(String msg) {
        this.privateShowMessage(msg, this._saSetWarning);
    }

    @Override
    public void showWarningMessage(Throwable th, ExceptionFormatter formatter) {
        this.privateShowMessage(th, formatter, this._saSetWarning);
    }

    @Override
    public synchronized void showErrorMessage(String msg) {
        this.privateShowMessage(msg, this._saSetError);
    }

    private void privateShowMessage(Throwable th, ExceptionFormatter formatter, SimpleAttributeSet saSet) {
        if (th != null) {
            String message = "";
            if (formatter == null) {
                message = this.defaultExceptionFormatter.format(th);
            } else {
                try {
                    message = formatter.format(th);
                }
                catch (Exception e) {
                    s_log.error("Unable to format message: " + e.getMessage(), e);
                }
            }
            this.privateShowMessage(message, saSet);
            if (saSet == this._saSetMessage) {
                s_log.info("privateShowMessage: Exception was: " + th.getMessage(), th);
            } else if (saSet == this._saSetWarning) {
                s_log.warn("privateShowMessage: Exception was: " + th.getMessage(), th);
            } else {
                s_log.error("privateShowMessage: Exception was: " + th.getMessage(), th);
            }
        }
    }

    private void privateShowMessage(String msg, SimpleAttributeSet saSet) {
        this.addLineOnEDT(msg, saSet);
    }

    private void addLineOnEDT(String msg, SimpleAttributeSet saSet) {
        GUIUtils.processOnSwingEventThread(() -> this.addLine(msg, saSet));
    }

    private void append(String string, SimpleAttributeSet saSet) {
        StyledDocument document = this.getStyledDocument();
        try {
            if (document.getLength() >= this._lastLength && null != this._lastMessage) {
                SimpleAttributeSet historySaSet = this.getHistorySaSet(this._lastSaSet);
                document.remove(this._lastLength, this._lastMessage.length());
                document.insertString(document.getLength(), this._lastMessage, historySaSet);
            }
            this._lastLength = document.getLength();
            this._lastMessage = string;
            this._lastSaSet = saSet;
            document.insertString(document.getLength(), string, saSet);
        }
        catch (BadLocationException ble) {
            s_log.error("Error appending text to MessagePanel document.", ble);
        }
    }

    private void addLine(String line, SimpleAttributeSet saSet) {
        if (this.getDocument().getLength() > 0) {
            this.append("\n", saSet);
        }
        this.append(line, saSet);
        int len = this.getDocument().getLength();
        this.select(len, len);
    }

    private void clearMessages() {
        try {
            Document doc = this.getDocument();
            doc.remove(0, doc.getLength());
            this._lastMessage = null;
        }
        catch (BadLocationException ex) {
            s_log.error("Error clearing document", ex);
        }
    }

    private class MessagePanelPopupMenu
    extends TextPopupMenu {
        public MessagePanelPopupMenu() {
            this.add(new ClearAction());
        }

        private class ClearAction
        extends BaseAction {
            protected ClearAction() {
                super(s_stringMgr.getString("MessagePanel.clearLabel"));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessagePanel.this.clearMessages();
            }
        }
    }
}

