/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.messagepanel;

import java.awt.Color;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.session.messagepanel.MessagePrefsPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class MessagePrefsCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MessagePrefsCtrl.class);
    private MessagePrefsPanel _messagePrefsPanel = new MessagePrefsPanel();

    public MessagePrefsCtrl() {
        this._messagePrefsPanel.btnMessageForeground.addActionListener(e -> this.chooseColor(this._messagePrefsPanel.btnMessageForeground));
        this._messagePrefsPanel.btnMessageBackground.addActionListener(e -> this.chooseColor(this._messagePrefsPanel.btnMessageBackground));
        this._messagePrefsPanel.btnMessageHistoryForeground.addActionListener(e -> this.chooseColor(this._messagePrefsPanel.btnMessageHistoryForeground));
        this._messagePrefsPanel.btnMessageHistoryBackground.addActionListener(e -> this.chooseColor(this._messagePrefsPanel.btnMessageHistoryBackground));
        this._messagePrefsPanel.btnWarningForeground.addActionListener(e -> this.chooseColor(this._messagePrefsPanel.btnWarningForeground));
        this._messagePrefsPanel.btnWarningBackground.addActionListener(e -> this.chooseColor(this._messagePrefsPanel.btnWarningBackground));
        this._messagePrefsPanel.btnWarningHistoryForeground.addActionListener(e -> this.chooseColor(this._messagePrefsPanel.btnWarningHistoryForeground));
        this._messagePrefsPanel.btnWarningHistoryBackground.addActionListener(e -> this.chooseColor(this._messagePrefsPanel.btnWarningHistoryBackground));
        this._messagePrefsPanel.btnErrorForeground.addActionListener(e -> this.chooseColor(this._messagePrefsPanel.btnErrorForeground));
        this._messagePrefsPanel.btnErrorBackground.addActionListener(e -> this.chooseColor(this._messagePrefsPanel.btnErrorBackground));
        this._messagePrefsPanel.btnErrorHistoryForeground.addActionListener(e -> this.chooseColor(this._messagePrefsPanel.btnErrorHistoryForeground));
        this._messagePrefsPanel.btnErrorHistoryBackground.addActionListener(e -> this.chooseColor(this._messagePrefsPanel.btnErrorHistoryBackground));
        this._messagePrefsPanel.btnTestMessage.addActionListener(e -> this.onTestMessage());
        this._messagePrefsPanel.btnTestWarning.addActionListener(e -> this.onTestWarning());
        this._messagePrefsPanel.btnTestError.addActionListener(e -> this.onTestError());
        this._messagePrefsPanel.btnRestoreDefault.addActionListener(e -> this.onRestoreDefault());
    }

    private void onRestoreDefault() {
        this.loadData(new SquirrelPreferences());
    }

    private void chooseColor(JButton btnColorToChoose) {
        Color color = JColorChooser.showDialog(this._messagePrefsPanel, s_stringMgr.getString("MessagePrefsCtrl.choose.color"), btnColorToChoose.getBackground());
        if (null != color) {
            btnColorToChoose.setBackground(color);
        }
    }

    public MessagePrefsPanel getPanel() {
        return this._messagePrefsPanel;
    }

    private void onTestMessage() {
        this.applyCurrentSettingsForTest();
        Main.getApplication().getMessageHandler().showMessage("Test message (previous/history)");
        Main.getApplication().getMessageHandler().showMessage("Test message (current)");
    }

    private void onTestWarning() {
        this.applyCurrentSettingsForTest();
        Main.getApplication().getMessageHandler().showWarningMessage("Test warning (previous/history)");
        Main.getApplication().getMessageHandler().showWarningMessage("Test warning (current)");
    }

    private void onTestError() {
        this.applyCurrentSettingsForTest();
        Main.getApplication().getMessageHandler().showErrorMessage("Test error (previous/history)");
        Main.getApplication().getMessageHandler().showErrorMessage("Test error (current)");
    }

    private void applyCurrentSettingsForTest() {
        SquirrelPreferences prefsBuf = new SquirrelPreferences();
        this.applyChanges(prefsBuf);
        if (prefsBuf.isMessagePanelWhiteBackgroundAsUIDefault() || prefsBuf.isMessagePanelBlackForegroundAsUIDefault()) {
            Main.getApplication().getMainFrame().getMessagePanel().showMessage(s_stringMgr.getString("MessagePrefsCtrl.warn.cannot.set.to.Defaults"));
        }
    }

    public void loadData(SquirrelPreferences prefs) {
        this._messagePrefsPanel.btnMessageForeground.setBackground(new Color(prefs.getMessagePanelMessageForeground()));
        this._messagePrefsPanel.btnMessageBackground.setBackground(new Color(prefs.getMessagePanelMessageBackground()));
        this._messagePrefsPanel.btnMessageHistoryForeground.setBackground(new Color(prefs.getMessagePanelMessageHistoryForeground()));
        this._messagePrefsPanel.btnMessageHistoryBackground.setBackground(new Color(prefs.getMessagePanelMessageHistoryBackground()));
        this._messagePrefsPanel.btnWarningForeground.setBackground(new Color(prefs.getMessagePanelWarningForeground()));
        this._messagePrefsPanel.btnWarningBackground.setBackground(new Color(prefs.getMessagePanelWarningBackground()));
        this._messagePrefsPanel.btnWarningHistoryForeground.setBackground(new Color(prefs.getMessagePanelWarningHistoryForeground()));
        this._messagePrefsPanel.btnWarningHistoryBackground.setBackground(new Color(prefs.getMessagePanelWarningHistoryBackground()));
        this._messagePrefsPanel.btnErrorForeground.setBackground(new Color(prefs.getMessagePanelErrorForeground()));
        this._messagePrefsPanel.btnErrorBackground.setBackground(new Color(prefs.getMessagePanelErrorBackground()));
        this._messagePrefsPanel.btnErrorHistoryForeground.setBackground(new Color(prefs.getMessagePanelErrorHistoryForeground()));
        this._messagePrefsPanel.btnErrorHistoryBackground.setBackground(new Color(prefs.getMessagePanelErrorHistoryBackground()));
        this._messagePrefsPanel.chkWhiteBackgroundAsUIDefault.setSelected(prefs.isMessagePanelWhiteBackgroundAsUIDefault());
        this._messagePrefsPanel.chkBlackForegroundAsUIDefault.setSelected(prefs.isMessagePanelBlackForegroundAsUIDefault());
    }

    public void applyChanges(SquirrelPreferences prefs) {
        prefs.setMessagePanelMessageForeground(this._messagePrefsPanel.btnMessageForeground.getBackground().getRGB());
        prefs.setMessagePanelMessageBackground(this._messagePrefsPanel.btnMessageBackground.getBackground().getRGB());
        prefs.setMessagePanelMessageHistoryForeground(this._messagePrefsPanel.btnMessageHistoryForeground.getBackground().getRGB());
        prefs.setMessagePanelMessageHistoryBackground(this._messagePrefsPanel.btnMessageHistoryBackground.getBackground().getRGB());
        prefs.setMessagePanelWarningForeground(this._messagePrefsPanel.btnWarningForeground.getBackground().getRGB());
        prefs.setMessagePanelWarningBackground(this._messagePrefsPanel.btnWarningBackground.getBackground().getRGB());
        prefs.setMessagePanelWarningHistoryForeground(this._messagePrefsPanel.btnWarningHistoryForeground.getBackground().getRGB());
        prefs.setMessagePanelWarningHistoryBackground(this._messagePrefsPanel.btnWarningHistoryBackground.getBackground().getRGB());
        prefs.setMessagePanelErrorForeground(this._messagePrefsPanel.btnErrorForeground.getBackground().getRGB());
        prefs.setMessagePanelErrorBackground(this._messagePrefsPanel.btnErrorBackground.getBackground().getRGB());
        prefs.setMessagePanelErrorHistoryForeground(this._messagePrefsPanel.btnErrorHistoryForeground.getBackground().getRGB());
        prefs.setMessagePanelErrorHistoryBackground(this._messagePrefsPanel.btnErrorHistoryBackground.getBackground().getRGB());
        prefs.setMessagePanelWhiteBackgroundAsUIDefault(this._messagePrefsPanel.chkWhiteBackgroundAsUIDefault.isSelected());
        prefs.setMessagePanelBlackForegroundAsUIDefault(this._messagePrefsPanel.chkBlackForegroundAsUIDefault.isSelected());
        Main.getApplication().getMainFrame().getMessagePanel().applyMessagePanelStyle(prefs);
    }

    public void switchToLight() {
        this.loadData(new SquirrelPreferences());
        this.applyChanges(Main.getApplication().getSquirrelPreferences());
    }

    public void switchToDark() {
        SquirrelPreferences darkThemePrefs = new SquirrelPreferences();
        darkThemePrefs.setMessagePanelMessageForeground(Color.green.getRGB());
        darkThemePrefs.setMessagePanelMessageBackground(Color.white.getRGB());
        darkThemePrefs.setMessagePanelMessageHistoryForeground(Color.black.getRGB());
        darkThemePrefs.setMessagePanelMessageHistoryBackground(Color.white.getRGB());
        darkThemePrefs.setMessagePanelWarningForeground(Color.yellow.getRGB());
        darkThemePrefs.setMessagePanelWarningBackground(Color.white.getRGB());
        darkThemePrefs.setMessagePanelWarningHistoryForeground(Color.yellow.darker().darker().getRGB());
        darkThemePrefs.setMessagePanelWarningHistoryBackground(Color.white.getRGB());
        this.loadData(darkThemePrefs);
        this.applyChanges(Main.getApplication().getSquirrelPreferences());
    }
}

