/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.messagepanel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class MessagePrefsPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MessagePrefsPanel.class);
    JButton btnMessageForeground = new JButton();
    JButton btnMessageBackground = new JButton();
    JButton btnMessageHistoryForeground = new JButton();
    JButton btnMessageHistoryBackground = new JButton();
    JButton btnTestMessage = new JButton();
    JButton btnWarningForeground = new JButton();
    JButton btnWarningBackground = new JButton();
    JButton btnWarningHistoryForeground = new JButton();
    JButton btnWarningHistoryBackground = new JButton();
    JButton btnTestWarning = new JButton();
    JButton btnErrorForeground = new JButton();
    JButton btnErrorBackground = new JButton();
    JButton btnErrorHistoryForeground = new JButton();
    JButton btnErrorHistoryBackground = new JButton();
    JButton btnTestError = new JButton();
    JCheckBox chkWhiteBackgroundAsUIDefault;
    JCheckBox chkBlackForegroundAsUIDefault;
    JButton btnRestoreDefault;

    public MessagePrefsPanel() {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("MessagePrefsPanel.title")));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(7, 5, 0, 5), 0, 0);
        JPanel messages = this.createRowPanel("MessagePrefsPanel.messages", this.btnMessageForeground, this.btnMessageBackground, this.btnMessageHistoryForeground, this.btnMessageHistoryBackground, this.btnTestMessage);
        this.btnMessageForeground.setToolTipText(s_stringMgr.getString("MessagePrefsPanel.last.message.foreground.color"));
        this.btnMessageBackground.setToolTipText(s_stringMgr.getString("MessagePrefsPanel.last.message.background.color"));
        this.btnMessageHistoryForeground.setToolTipText(s_stringMgr.getString("MessagePrefsPanel.message.history.foreground.color"));
        this.btnMessageHistoryBackground.setToolTipText(s_stringMgr.getString("MessagePrefsPanel.message.history.background.color"));
        this.add((Component)messages, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(7, 5, 0, 5), 0, 0);
        JPanel warnings = this.createRowPanel("MessagePrefsPanel.warnings", this.btnWarningForeground, this.btnWarningBackground, this.btnWarningHistoryForeground, this.btnWarningHistoryBackground, this.btnTestWarning);
        this.btnWarningForeground.setToolTipText(s_stringMgr.getString("MessagePrefsPanel.last.warning.foreground.color"));
        this.btnWarningBackground.setToolTipText(s_stringMgr.getString("MessagePrefsPanel.last.warning.background.color"));
        this.btnWarningHistoryForeground.setToolTipText(s_stringMgr.getString("MessagePrefsPanel.warning.history.foreground.color"));
        this.btnWarningHistoryBackground.setToolTipText(s_stringMgr.getString("MessagePrefsPanel.warning.history.background.color"));
        this.add((Component)warnings, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(7, 5, 3, 5), 0, 0);
        JPanel errors = this.createRowPanel("MessagePrefsPanel.errors", this.btnErrorForeground, this.btnErrorBackground, this.btnErrorHistoryForeground, this.btnErrorHistoryBackground, this.btnTestError);
        this.btnErrorForeground.setToolTipText(s_stringMgr.getString("MessagePrefsPanel.last.error.foreground.color"));
        this.btnErrorBackground.setToolTipText(s_stringMgr.getString("MessagePrefsPanel.last.error.background.color"));
        this.btnErrorHistoryForeground.setToolTipText(s_stringMgr.getString("MessagePrefsPanel.error.history.foreground.color"));
        this.btnErrorHistoryBackground.setToolTipText(s_stringMgr.getString("MessagePrefsPanel.error.history.background.color"));
        this.add((Component)errors, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(7, 5, 3, 5), 0, 0);
        this.chkWhiteBackgroundAsUIDefault = new JCheckBox(s_stringMgr.getString("MessagePrefsPanel.whiteBackgroundLeavesUIBackground"));
        this.chkWhiteBackgroundAsUIDefault.setToolTipText(s_stringMgr.getString("MessagePrefsPanel.WhiteBackgroundAsUIDefault.tooltip"));
        this.add((Component)this.chkWhiteBackgroundAsUIDefault, gbc);
        gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 5, 3, 5), 0, 0);
        this.chkBlackForegroundAsUIDefault = new JCheckBox(s_stringMgr.getString("MessagePrefsPanel.blackForegroundLeavesUIBackground"));
        this.chkBlackForegroundAsUIDefault.setToolTipText(s_stringMgr.getString("MessagePrefsPanel.BlackForegroundAsUIDefault.tooltip"));
        this.add((Component)this.chkBlackForegroundAsUIDefault, gbc);
        gbc = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 3, 5), 0, 0);
        this.btnRestoreDefault = new JButton(s_stringMgr.getString("MessagePrefsPanel.restoreDefault"));
        this.add((Component)this.btnRestoreDefault, gbc);
    }

    private int getMaxTitleWidth() {
        return GUIUtils.getMaxStringWidth(new JLabel(), s_stringMgr.getString("MessagePrefsPanel.messages"), s_stringMgr.getString("MessagePrefsPanel.warnings"), s_stringMgr.getString("MessagePrefsPanel.errors"));
    }

    private JPanel createRowPanel(String titleKey, JButton btnForeground, JButton btnBackground, JButton btnHistoryForeground, JButton btnMessageHistoryBackground, JButton btnTest) {
        SquirrelResources rsrc = Main.getApplication().getResources();
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        JLabel lblTitle = new JLabel(s_stringMgr.getString(titleKey));
        GUIUtils.setPreferredWidth(lblTitle, this.getMaxTitleWidth());
        ret.add((Component)lblTitle, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        btnForeground.setIcon(rsrc.getIcon("pen"));
        ret.add((Component)this.styleAsColorChooseButton(btnForeground), gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        btnBackground.setIcon(rsrc.getIcon("fill"));
        ret.add((Component)this.styleAsColorChooseButton(btnBackground), gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("MessagePrefsPanel.history")), gbc);
        gbc = new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        btnHistoryForeground.setIcon(rsrc.getIcon("pen"));
        ret.add((Component)this.styleAsColorChooseButton(btnHistoryForeground), gbc);
        gbc = new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        btnMessageHistoryBackground.setIcon(rsrc.getIcon("fill"));
        ret.add((Component)this.styleAsColorChooseButton(btnMessageHistoryBackground), gbc);
        gbc = new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        btnTest.setText(s_stringMgr.getString("MessagePrefsPanel.test"));
        ret.add((Component)btnTest, gbc);
        return ret;
    }

    private JButton styleAsColorChooseButton(JButton btn) {
        btn.setBorder(BorderFactory.createEtchedBorder());
        return btn;
    }
}

