/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.objecttreesearch;

import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.treefinder.ObjectTreeFinderGoToNextResultHandle;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.treefinder.ObjectTreeSearchResultFuture;
import net.sourceforge.squirrel_sql.client.session.objecttreesearch.ObjectTreeSearchPartition;
import net.sourceforge.squirrel_sql.client.session.objecttreesearch.ObjectTreeSearchPartitions;
import net.sourceforge.squirrel_sql.client.session.schemainfo.FilterMatcher;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ObjectTreeSearch {
    private static final ILogger s_log = LoggerController.createLogger(ObjectTreeSearch.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ObjectTreeSearch.class);

    public void viewObjectInObjectTree(String objectName, ISession session) {
        if (!(session.getActiveSessionWindow() instanceof SessionInternalFrame) && !(session.getActiveSessionWindow() instanceof ObjectTreeInternalFrame)) {
            return;
        }
        IObjectTreeAPI objectTreeAPI = session.getObjectTreeAPIOfActiveSessionWindow();
        this.viewInObjectTree(objectName, objectTreeAPI);
    }

    public void viewInObjectTree(String objectName, IObjectTreeAPI objectTreeAPI) {
        ObjectTreeSearchPartitions partitions = this.getSearchPartitions(objectName, objectTreeAPI.getSession());
        if (partitions.size() == 0) {
            return;
        }
        this._viewInObjectTree(partitions, objectTreeAPI, true, ObjectTreeFinderGoToNextResultHandle.DONT_GO_TO_NEXT_RESULT_HANDLE);
    }

    public void viewObjectInObjectTree(String objectName, IObjectTreeAPI objectTreeAPI, ObjectTreeFinderGoToNextResultHandle goToNextResultHandle) {
        ObjectTreeSearchPartitions partitions = this.getSearchPartitions(objectName, objectTreeAPI.getSession());
        if (partitions.size() == 0) {
            return;
        }
        this._viewInObjectTree(partitions, objectTreeAPI, false, goToNextResultHandle);
    }

    private void _viewInObjectTree(ObjectTreeSearchPartitions partitions, IObjectTreeAPI objectTreeAPI, boolean selectMainObjectTreeIfFound, ObjectTreeFinderGoToNextResultHandle goToNextResultHandle) {
        if (!partitions.hasNext()) {
            return;
        }
        this.tryFindMatchForNextPartition(partitions, objectTreeAPI, selectMainObjectTreeIfFound, null, goToNextResultHandle);
    }

    private void tryFindMatchForNextPartition(ObjectTreeSearchPartitions partitions, IObjectTreeAPI objectTreeAPI, boolean selectMainObjectTreeIfFound, TreePath findResult, ObjectTreeFinderGoToNextResultHandle goToNextResultHandle) {
        if (null != findResult) {
            if (selectMainObjectTreeIfFound) {
                objectTreeAPI.getSession().selectMainTab(0);
            }
        } else if (partitions.hasNext()) {
            ObjectTreeSearchPartition partition = partitions.next();
            ObjectTreeSearchResultFuture resultFuture = objectTreeAPI.selectInObjectTree(partition.getCatalog(), partition.getSchema(), new FilterMatcher(partition.getObject(), null), goToNextResultHandle);
            resultFuture.addFinishedListenerOrdered(tn -> this.tryFindMatchForNextPartition(partitions, objectTreeAPI, selectMainObjectTreeIfFound, tn, goToNextResultHandle));
        } else {
            if (goToNextResultHandle.hasPreviousResults()) {
                String msg = s_stringMgr.getString("ObjectTreeSearch.message.no.more.objects.found", partitions.getSearchString());
                JOptionPane.showMessageDialog(SessionUtils.getOwningFrame(objectTreeAPI.getSession()), msg);
            } else {
                String msg = s_stringMgr.getString("ObjectTreeSearch.error.objectnotfound", partitions.getSearchString());
                JOptionPane.showMessageDialog(SessionUtils.getOwningFrame(objectTreeAPI.getSession()), msg);
            }
            goToNextResultHandle.reachedEmptyResult();
        }
    }

    private ObjectTreeSearchPartitions getSearchPartitions(String objectName, ISession session) {
        ObjectTreeSearchPartitions ret = new ObjectTreeSearchPartitions(objectName);
        String[] splits = objectName.split("\\.");
        if (splits.length >= 3) {
            ret.add(splits[0], splits[1], splits[2]);
            ret.add(null, this.removeQuotes(splits[1]), this.removeQuotes(splits[2]));
            ret.add(this.removeQuotes(splits[1]), null, this.removeQuotes(splits[2]));
            ret.add(null, null, splits[2]);
        } else if (splits.length == 2) {
            ret.add(null, this.removeQuotes(splits[0]), this.removeQuotes(splits[1]));
            ret.add(this.removeQuotes(splits[0]), null, this.removeQuotes(splits[1]));
            ret.add(null, null, this.removeQuotes(splits[0]));
        } else if (splits.length == 1) {
            try {
                String currentSchema = session.getSQLConnection().getSchema();
                if (!StringUtilities.isEmpty(currentSchema, true)) {
                    ret.addFirst(null, currentSchema, this.removeQuotes(splits[0]));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ret.add(null, null, this.removeQuotes(splits[0]));
        }
        return ret;
    }

    private String removeQuotes(String objectName) {
        String ret = objectName.trim();
        while (ret.startsWith("\"") || ret.startsWith("/")) {
            ret = ret.substring(1);
        }
        while (ret.endsWith("\"") || ret.endsWith("/")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public void viewInObjectTree(TreePath treePath, IObjectTreeAPI objectTreeAPI) {
        objectTreeAPI.selectInObjectTree(treePath);
        objectTreeAPI.getSession().selectMainTab(0);
    }
}

