/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.parser.kernel;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.SqlCommentHelper;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.SqlLiteralHelper;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.StatementBounds;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.TableAliasInfo;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableQualifier;

public class HeuristicSQLAliasParser {
    private StringBuilder _token = new StringBuilder();
    private SqlCommentHelper _sqlCommentHelper;
    private int literalDelimsCount = 0;

    public List<TableAliasInfo> parse(StatementBounds statementBounds, SchemaInfo schemaInfo) {
        this._sqlCommentHelper = new SqlCommentHelper(statementBounds.getStatement());
        ArrayList<TableAliasInfo> ret = new ArrayList<TableAliasInfo>();
        int[] i = new int[]{0};
        boolean lastTokenAllowedTableAliasDefinition = false;
        String currentAliasableTable = null;
        while (i[0] < statementBounds.getStatement().length()) {
            String token = this.nextToken(i, statementBounds.getStatement());
            if (0 == token.length()) {
                lastTokenAllowedTableAliasDefinition = false;
                currentAliasableTable = null;
                continue;
            }
            if ("JOIN".equalsIgnoreCase(token) || "FROM".equalsIgnoreCase(token)) {
                lastTokenAllowedTableAliasDefinition = true;
                currentAliasableTable = null;
                continue;
            }
            if (lastTokenAllowedTableAliasDefinition) {
                TableQualifier tableQualifier = new TableQualifier(token);
                ITableInfo[] tableInfos = new ITableInfo[]{};
                try {
                    tableInfos = schemaInfo.getITableInfos(tableQualifier.getCatalog(), tableQualifier.getSchema(), tableQualifier.getTableName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                lastTokenAllowedTableAliasDefinition = false;
                currentAliasableTable = null;
                if (0 >= tableInfos.length) continue;
                currentAliasableTable = token;
                continue;
            }
            if (null != currentAliasableTable && !schemaInfo.isKeyword(token)) {
                ret.add(new TableAliasInfo(token, currentAliasableTable, statementBounds.getBeginPos(), statementBounds.getEndPos()));
                lastTokenAllowedTableAliasDefinition = false;
                currentAliasableTable = null;
                continue;
            }
            lastTokenAllowedTableAliasDefinition = false;
            currentAliasableTable = null;
        }
        return ret;
    }

    private String nextToken(int[] i, String sql) {
        this._token.setLength(0);
        for (int j = i[0]; j < sql.length(); ++j) {
            char c = sql.charAt(j);
            if (this.isLiteralDelimiter(c) && !this._sqlCommentHelper.isInComment(j)) {
                ++this.literalDelimsCount;
            }
            if (this._sqlCommentHelper.isInComment(j) || SqlLiteralHelper.isInLiteral(this.literalDelimsCount)) {
                if (0 >= this._token.length()) continue;
                i[0] = j + 1;
                return this._token.toString();
            }
            if (Character.isWhitespace(c)) {
                if (0 == this._token.length()) continue;
                i[0] = j + 1;
                return this._token.toString();
            }
            if (this.isSepartor(c)) {
                if (0 == this._token.length()) {
                    i[0] = j + 1;
                    return this._token.append(c).toString();
                }
                i[0] = j;
                return this._token.toString();
            }
            this._token.append(c);
        }
        i[0] = sql.length();
        return this._token.toString();
    }

    private boolean isLiteralDelimiter(char c) {
        return '\'' == c;
    }

    private boolean isSepartor(char c) {
        return ',' == c || '(' == c || ')' == c;
    }
}

