/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.parser.kernel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.sf.jsqlparser.parser.ParseException;
import net.sf.jsqlparser.schema.Table;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ErrorInfo;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.HeuristicSQLAliasParser;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.JSqlParserAdapter;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParseTerminateRequestCheck;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParseTerminateRequestException;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParsingFinishedListener;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParsingResult;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.StatementBounds;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.StatementBoundsPrediction;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.TableAliasInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableQualifier;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class ParserThread {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ParserThread.class);
    private final ExecutorService _executorService;
    private ISession _session;
    private ParsingFinishedListener _parsingFinishedListener;
    private Future<?> _currentFuture;
    private ErrorInfo[] _errorInfos = new ErrorInfo[0];
    private TableAliasInfo[] _tableAliasInfos = new TableAliasInfo[0];
    private ParseTerminateRequestCheck _parseTerminateRequestCheck = () -> this.onCheckExitThreadRequested();
    private volatile boolean _exitThreadRequested = false;

    public ParserThread(ISession session) {
        this._session = session;
        this._executorService = Executors.newSingleThreadExecutor();
    }

    private void onCheckExitThreadRequested() {
        if (this._exitThreadRequested) {
            throw new ParseTerminateRequestException();
        }
    }

    public void setParsingFinishedListener(ParsingFinishedListener parsingFinishedListener) {
        this._parsingFinishedListener = parsingFinishedListener;
    }

    public void parseInBackground(String text) {
        if (this._exitThreadRequested || null != this._currentFuture && !this._currentFuture.isDone()) {
            return;
        }
        this._currentFuture = this._executorService.submit(() -> this.onParse(text));
    }

    private void onParse(String text) {
        block4: {
            try {
                try {
                    this._onParse(text);
                    this._parsingFinishedListener.parsingFinished();
                }
                catch (ParseTerminateRequestException parseTerminateRequestException) {}
            }
            catch (Throwable e) {
                if (null == this._parsingFinishedListener) break block4;
                this._parsingFinishedListener.parserExitedOnException(e);
            }
        }
    }

    private void _onParse(String text) throws ParseException {
        List<StatementBounds> statementBoundsList = StatementBoundsPrediction.getStatementBoundsList(text, this._parseTerminateRequestCheck);
        this._parseTerminateRequestCheck.check();
        ArrayList<ErrorInfo> errorInfosBuffer = new ArrayList<ErrorInfo>();
        ArrayList<TableAliasInfo> tableAliasInfosBuffer = new ArrayList<TableAliasInfo>();
        for (StatementBounds statementBounds : statementBoundsList) {
            this._parseTerminateRequestCheck.check();
            ParsingResult parsingResult = JSqlParserAdapter.executeParsing(statementBounds);
            this._parseTerminateRequestCheck.check();
            List<TableAliasInfo> tableAliasInfosForCurrentStatement = new ArrayList<TableAliasInfo>();
            for (Table table : parsingResult.getTables()) {
                this._parseTerminateRequestCheck.check();
                TableQualifier tableQualifier = new TableQualifier(table.getFullyQualifiedName());
                ITableInfo[] tableInfos = this._session.getSchemaInfo().getITableInfos(StringUtilities.stripDoubleQuotes(tableQualifier.getCatalog()), StringUtilities.stripDoubleQuotes(tableQualifier.getSchema()), StringUtilities.stripDoubleQuotes(tableQualifier.getTableName()));
                this._parseTerminateRequestCheck.check();
                if (0 == tableInfos.length) {
                    int beginPos = statementBounds.getBeginPos() + table.getASTNode().jjtGetFirstToken().absoluteBegin;
                    int endPos = statementBounds.getBeginPos() + table.getASTNode().jjtGetFirstToken().absoluteEnd;
                    errorInfosBuffer.add(new ErrorInfo(s_stringMgr.getString("parserthread.undefinedTable"), beginPos, endPos));
                    continue;
                }
                if (null == table.getAlias()) continue;
                tableAliasInfosForCurrentStatement.add(new TableAliasInfo(table.getAlias().getName(), table.getFullyQualifiedName(), statementBounds.getBeginPos(), statementBounds.getEndPos()));
            }
            if (this.aliasesMayGotLostByParserErrors(tableAliasInfosForCurrentStatement, parsingResult)) {
                tableAliasInfosForCurrentStatement = new HeuristicSQLAliasParser().parse(statementBounds, this._session.getSchemaInfo());
            }
            tableAliasInfosBuffer.addAll(tableAliasInfosForCurrentStatement);
            for (ParseException parseError : parsingResult.getParseErrors()) {
                this._parseTerminateRequestCheck.check();
                int beginPos = statementBounds.getBeginPos() + parseError.currentToken.next.absoluteBegin;
                int endPos = statementBounds.getBeginPos() + parseError.currentToken.next.absoluteEnd;
                errorInfosBuffer.add(new ErrorInfo(parseError.getMessage(), beginPos, endPos));
            }
        }
        this._errorInfos = errorInfosBuffer.toArray(new ErrorInfo[0]);
        this._tableAliasInfos = tableAliasInfosBuffer.toArray(new TableAliasInfo[0]);
    }

    private boolean aliasesMayGotLostByParserErrors(List<TableAliasInfo> tableAliasInfos, ParsingResult parsingResult) {
        return 0 == tableAliasInfos.size() && 0 < parsingResult.getParseErrors().size();
    }

    public TableAliasInfo[] getTableAliasInfos() {
        return this._tableAliasInfos;
    }

    public ErrorInfo[] getErrorInfos() {
        return this._errorInfos;
    }

    public void exitThread() {
        this._exitThreadRequested = true;
    }
}

