/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.parser.kernel;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParseTerminateRequestCheck;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.SqlLiteralHelper;

public class SqlCommentHelper {
    private final int[][] _commentIntervals;

    public SqlCommentHelper(String statement) {
        this(statement, () -> {});
    }

    public SqlCommentHelper(String sqlText, ParseTerminateRequestCheck check) {
        this._commentIntervals = this.calculateCommentIntervals(sqlText, check);
    }

    private int[][] calculateCommentIntervals(String sqlEditorText, ParseTerminateRequestCheck check) {
        ArrayList<int[]> ret = new ArrayList<int[]>();
        boolean inMultiLineComment = false;
        boolean inLineComment = false;
        boolean isaSlash = false;
        boolean isaStar = false;
        boolean isaMinus = false;
        int[] curComment = null;
        int literalDelimsCount = 0;
        for (int i = 0; i < sqlEditorText.length(); ++i) {
            check.check();
            if (!inLineComment && !inMultiLineComment) {
                if ('\'' == sqlEditorText.charAt(i)) {
                    ++literalDelimsCount;
                }
                if (SqlLiteralHelper.isInLiteral(literalDelimsCount)) continue;
            }
            if ('*' == sqlEditorText.charAt(i) && isaSlash && !inMultiLineComment && !inLineComment) {
                inMultiLineComment = true;
                curComment = new int[]{i - 1, -1};
            } else if ('/' == sqlEditorText.charAt(i) && isaStar && !inLineComment && inMultiLineComment) {
                inMultiLineComment = false;
                curComment[1] = i;
                ret.add(curComment);
                curComment = null;
            } else if ('-' == sqlEditorText.charAt(i) && isaMinus && !inMultiLineComment && !inLineComment) {
                inLineComment = true;
                curComment = new int[]{i - 1, -1};
            } else if ('\n' == sqlEditorText.charAt(i) && !inMultiLineComment && inLineComment) {
                inLineComment = false;
                curComment[1] = i;
                ret.add(curComment);
                curComment = null;
            }
            if ('/' == sqlEditorText.charAt(i)) {
                isaSlash = true;
                continue;
            }
            if ('*' == sqlEditorText.charAt(i)) {
                isaStar = true;
                continue;
            }
            if ('-' == sqlEditorText.charAt(i)) {
                isaMinus = true;
                continue;
            }
            isaSlash = false;
            isaStar = false;
            isaMinus = false;
        }
        if (null != curComment) {
            curComment[1] = sqlEditorText.length();
            ret.add(curComment);
        }
        return (int[][])ret.toArray((T[])new int[ret.size()][]);
    }

    boolean isInComment(int pos) {
        for (int i = 0; i < this._commentIntervals.length; ++i) {
            if (this._commentIntervals[i][0] > pos || pos > this._commentIntervals[i][1]) continue;
            return true;
        }
        return false;
    }

    public boolean isCommentBegin(int pos) {
        for (int i = 0; i < this._commentIntervals.length; ++i) {
            if (this._commentIntervals[i][0] != pos) continue;
            return true;
        }
        return false;
    }
}

