/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.parser.kernel;

import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParseTerminateRequestCheck;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.SqlCommentHelper;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.SqlLiteralHelper;

public class StatementBeginPrediction {
    static int predictNextStatementBegin(String sqlEditorText, int startPos, ParseTerminateRequestCheck check) {
        int ret;
        SqlCommentHelper sqlCommentHelper = new SqlCommentHelper(sqlEditorText, check);
        int openBracketsCount = 0;
        int literalDelimsCount = 0;
        for (ret = startPos; sqlEditorText.length() > ret; ++ret) {
            if ('\'' == sqlEditorText.charAt(ret) && !sqlCommentHelper.isInComment(ret)) {
                ++literalDelimsCount;
            }
            if (!sqlCommentHelper.isInComment(ret) && !SqlLiteralHelper.isInLiteral(literalDelimsCount)) {
                if ('(' == sqlEditorText.charAt(ret)) {
                    ++openBracketsCount;
                } else if (')' == sqlEditorText.charAt(ret)) {
                    --openBracketsCount;
                }
            }
            if (!SqlLiteralHelper.isInLiteral(literalDelimsCount) && !sqlCommentHelper.isInComment(ret) && !StatementBeginPrediction.isInBrackets(openBracketsCount) && StatementBeginPrediction.startsWithBeginKeyWord(sqlEditorText, ret)) break;
            check.check();
        }
        return ret;
    }

    private static boolean isInBrackets(int openBracketsCount) {
        return 0 < openBracketsCount;
    }

    private static boolean startsWithBeginKeyWord(String sqlEditorText, int ret) {
        return StatementBeginPrediction.startsWithIgnoreCase(sqlEditorText, ret, "SELECT") || StatementBeginPrediction.startsWithIgnoreCase(sqlEditorText, ret, "UPDATE") || StatementBeginPrediction.startsWithIgnoreCase(sqlEditorText, ret, "DELETE") || StatementBeginPrediction.startsWithIgnoreCase(sqlEditorText, ret, "INSERT") || StatementBeginPrediction.startsWithIgnoreCase(sqlEditorText, ret, "ALTER") || StatementBeginPrediction.startsWithIgnoreCase(sqlEditorText, ret, "CREATE") || StatementBeginPrediction.startsWithIgnoreCase(sqlEditorText, ret, "DROP");
    }

    private static boolean startsWithIgnoreCase(String sqlEditorText, int ret, String keyWord) {
        int endPos;
        int beginPos = ret;
        if (ret == 0) {
            beginPos = 0;
        } else if (Character.isWhitespace(sqlEditorText.charAt(ret - 1))) {
            beginPos = ret;
        } else {
            return false;
        }
        if (sqlEditorText.length() == beginPos + keyWord.length()) {
            endPos = beginPos + keyWord.length();
        } else if (sqlEditorText.length() > beginPos + keyWord.length() && Character.isWhitespace(sqlEditorText.charAt(beginPos + keyWord.length()))) {
            endPos = beginPos + keyWord.length();
        } else {
            return false;
        }
        return keyWord.equalsIgnoreCase(sqlEditorText.substring(beginPos, endPos));
    }
}

