/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.properties;

import java.awt.Color;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.session.properties.ColorNullValuesPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ColorNullValuesController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ColorNullValuesController.class);
    private ColorNullValuesPanel _panel = new ColorNullValuesPanel();

    public ColorNullValuesController() {
        this._panel.btnCurrentNullValueColorRGB.setEnabled(this._panel.chkColorNullValues.isSelected());
        this._panel.chkColorNullValues.addActionListener(e -> this._panel.btnCurrentNullValueColorRGB.setEnabled(this._panel.chkColorNullValues.isSelected()));
        this._panel.btnCurrentNullValueColorRGB.addActionListener(e -> this.onChooseNullValueColor());
    }

    private void onChooseNullValueColor() {
        String title = s_stringMgr.getString("ColorNUllValuesController.null.value.color.choose");
        Color color = JColorChooser.showDialog(this._panel, title, this._panel.getNullValueColorIcon().getColor());
        if (null != color) {
            this._panel.getNullValueColorIcon().setColor(color);
        }
    }

    public JPanel getPanel() {
        return this._panel;
    }

    public int getNullValueColorRGB() {
        return this._panel.getNullValueColorIcon().getColor().getRGB();
    }

    public boolean isColorNullValues() {
        return this._panel.chkColorNullValues.isSelected();
    }

    public void init(boolean colorNullValues, int nullValueColorRGB) {
        this._panel.chkColorNullValues.setSelected(colorNullValues);
        this._panel.getNullValueColorIcon().setColor(new Color(nullValueColorRGB));
        this._panel.btnCurrentNullValueColorRGB.setEnabled(this._panel.chkColorNullValues.isSelected());
    }
}

