/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionDialogWidget;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.ContentsTab;
import net.sourceforge.squirrel_sql.client.session.properties.EditWhereColsPanel;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class EditWhereColsSheet
extends SessionDialogWidget {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(EditWhereColsSheet.class);
    private static final ILogger s_log = LoggerController.createLogger(EditWhereColsSheet.class);
    private IDatabaseObjectInfo _objectInfo;
    private JLabel _titleLbl = new JLabel();
    private EditWhereColsPanel _editWhereColsPanel = null;

    public EditWhereColsSheet(ISession session, IDatabaseObjectInfo objectInfo) {
        super(i18n.TITLE, true, session);
        if (objectInfo == null) {
            throw new IllegalArgumentException("Null IDatabaseObjectInfo passed");
        }
        this._objectInfo = objectInfo;
        this.createGUI();
        this.pack();
    }

    @Override
    public synchronized void setVisible(boolean show) {
        if (show) {
            if (!this.isVisible()) {
                boolean isDebug = s_log.isDebugEnabled();
                long start = 0L;
                if (isDebug) {
                    start = System.currentTimeMillis();
                }
                if (isDebug) {
                    s_log.debug("Panel " + this._editWhereColsPanel.getTitle() + " initialized in " + (System.currentTimeMillis() - start) + "ms");
                }
                this.pack();
                Dimension d = this.getSize();
                d.width += 5;
                d.height += 5;
                this.setSize(d);
                DialogWidget.centerWithinDesktop(this);
            }
            this.moveToFront();
        }
        super.setVisible(show);
    }

    private void performClose() {
        this.dispose();
    }

    public IDatabaseObjectInfo getDatabaseObjectInfo() {
        return this._objectInfo;
    }

    private void performReset() {
        this._editWhereColsPanel.reset();
    }

    private void performOk() {
        if (this._editWhereColsPanel.ok()) {
            this.dispose();
        }
    }

    private void createGUI() {
        TreeSet<String> columnNames = new TreeSet<String>();
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        ISession session = this.getSession();
        try {
            ISQLConnection conn = session.getSQLConnection();
            TableColumnInfo[] infos = conn.getSQLMetaData().getColumnInfo((ITableInfo)this._objectInfo);
            for (int i = 0; i < infos.length; ++i) {
                TableColumnInfo info = infos[i];
                columnNames.add(info.getColumnName());
            }
        }
        catch (SQLException ex) {
            session.getApplication().showErrorDialog(s_stringMgr.getString("editWhereColsSheet.unableToEdit", ex));
        }
        String unambiguousname = ContentsTab.getUnambiguousTableName(session, this._objectInfo.getQualifiedName());
        this._editWhereColsPanel = new EditWhereColsPanel(session, (ITableInfo)this._objectInfo, columnNames, unambiguousname);
        this._titleLbl.setText(this.getTitle() + ": " + this._objectInfo.getSimpleName());
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.setContentPane(contentPane);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        contentPane.add((Component)this._titleLbl, gbc);
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)new JLabel(" "), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)new JLabel(s_stringMgr.getString("editWhereColsSheet.limitSizeOfWhereClause")), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)new JLabel(s_stringMgr.getString("editWhereColsSheet.shouldIncludePKs")), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)new JLabel(" "), gbc);
        gbc.fill = 1;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weighty = 1.0;
        contentPane.add((Component)this._editWhereColsPanel, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.weighty = 0.0;
        contentPane.add((Component)this.createButtonsPanel(), gbc);
        GUIUtils.enableCloseByEscape(this);
    }

    private JPanel createButtonsPanel() {
        JPanel pnl = new JPanel();
        JButton okBtn = new JButton(s_stringMgr.getString("editWherColsSheet.ok"));
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditWhereColsSheet.this.performOk();
            }
        });
        JButton resetBtn = new JButton(s_stringMgr.getString("editWherColsSheet.reset"));
        resetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditWhereColsSheet.this.performReset();
            }
        });
        JButton closeBtn = new JButton(s_stringMgr.getString("editWherColsSheet.close"));
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditWhereColsSheet.this.performClose();
            }
        });
        pnl.add(okBtn);
        pnl.add(resetBtn);
        pnl.add(closeBtn);
        GUIUtils.setJButtonSizesTheSame(okBtn, resetBtn, closeBtn);
        this.getRootPane().setDefaultButton(okBtn);
        return pnl;
    }

    private static interface i18n {
        public static final String TITLE = s_stringMgr.getString("editWhereColsSheet.editWhereColumns");
    }
}

