/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.properties;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.sourceforge.squirrel_sql.client.session.properties.ColorNullValuesController;
import net.sourceforge.squirrel_sql.client.session.properties.DataSetViewerType;
import net.sourceforge.squirrel_sql.client.session.properties.GeneralSessionPropertiesPanelI18n;
import net.sourceforge.squirrel_sql.client.session.properties.NullValuesSortingPanel;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerEditableTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTextPanel;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

final class GeneralSessionPropertiesUIPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GeneralSessionPropertiesUIPanel.class);
    private JCheckBox _showToolBar = new JCheckBox(GeneralSessionPropertiesPanelI18n.SHOW_TOOLBAR);
    private TabPlacementCombo _mainTabPlacementCmb = new TabPlacementCombo();
    private TabPlacementCombo _objectTabPlacementCmb = new TabPlacementCombo();
    private TabPlacementCombo _sqlExecutionTabPlacementCmb = new TabPlacementCombo();
    private TabPlacementCombo _sqlResultsTabPlacementCmb = new TabPlacementCombo();
    private OutputTypeCombo _metaDataCmb = new OutputTypeCombo(false);
    private OutputTypeCombo _sqlResultsCmb = new OutputTypeCombo(true);
    private JCheckBox _chkKeepTableLayoutOnRerun = new JCheckBox();
    private JCheckBox _chkShowRowNumberInTextLayout = new JCheckBox();
    private OutputTypeCombo _tableContentsCmb = new OutputTypeCombo(true);
    private SplitPaneOrientationCombo _splitPaneOrientationCmb = new SplitPaneOrientationCombo();
    private ColorNullValuesController _colorNullValuesController = new ColorNullValuesController();
    private NullValuesSortingPanel _nullValuesSortingPanel = new NullValuesSortingPanel();

    GeneralSessionPropertiesUIPanel() {
        super(new GridBagLayout());
        this.createGUI();
    }

    void loadData(SessionProperties props) {
        this._showToolBar.setSelected(props.getShowToolBar());
        int mainTabPlacement = props.getMainTabPlacement();
        int limit = this._mainTabPlacementCmb.getModel().getSize();
        for (int i = 0; i < limit; ++i) {
            TabPlacement tp = (TabPlacement)this._mainTabPlacementCmb.getItemAt(i);
            if (tp.getValue() != mainTabPlacement) continue;
            this._mainTabPlacementCmb.setSelectedIndex(i);
            break;
        }
        if (this._mainTabPlacementCmb.getSelectedIndex() == -1) {
            this._mainTabPlacementCmb.setSelectedIndex(0);
        }
        int objectTabPlacement = props.getObjectTabPlacement();
        int limit2 = this._objectTabPlacementCmb.getModel().getSize();
        for (int i = 0; i < limit2; ++i) {
            TabPlacement tp = (TabPlacement)this._objectTabPlacementCmb.getItemAt(i);
            if (tp.getValue() != objectTabPlacement) continue;
            this._objectTabPlacementCmb.setSelectedIndex(i);
            break;
        }
        if (this._objectTabPlacementCmb.getSelectedIndex() == -1) {
            this._objectTabPlacementCmb.setSelectedIndex(0);
        }
        int sqlExecutionTabPlacement = props.getSQLExecutionTabPlacement();
        int limit3 = this._sqlExecutionTabPlacementCmb.getModel().getSize();
        for (int i = 0; i < limit3; ++i) {
            TabPlacement tp = (TabPlacement)this._sqlExecutionTabPlacementCmb.getItemAt(i);
            if (tp.getValue() != sqlExecutionTabPlacement) continue;
            this._sqlExecutionTabPlacementCmb.setSelectedIndex(i);
            break;
        }
        if (this._sqlExecutionTabPlacementCmb.getSelectedIndex() == -1) {
            this._sqlExecutionTabPlacementCmb.setSelectedIndex(0);
        }
        int sqlResultsTabPlacement = props.getSQLResultsTabPlacement();
        int limit4 = this._sqlResultsTabPlacementCmb.getModel().getSize();
        for (int i = 0; i < limit4; ++i) {
            TabPlacement tp = (TabPlacement)this._sqlResultsTabPlacementCmb.getItemAt(i);
            if (tp.getValue() != sqlResultsTabPlacement) continue;
            this._sqlResultsTabPlacementCmb.setSelectedIndex(i);
            break;
        }
        if (this._sqlResultsTabPlacementCmb.getSelectedIndex() == -1) {
            this._sqlResultsTabPlacementCmb.setSelectedIndex(0);
        }
        int splitPaneOrientation = props.getSqlPanelOrientation();
        int limit5 = this._splitPaneOrientationCmb.getModel().getSize();
        for (int i = 0; i < limit5; ++i) {
            SplitPaneOrientation spo = (SplitPaneOrientation)this._splitPaneOrientationCmb.getItemAt(i);
            if (spo.getValue() != splitPaneOrientation) continue;
            this._splitPaneOrientationCmb.setSelectedIndex(i);
            break;
        }
        if (this._splitPaneOrientationCmb.getSelectedIndex() == -1) {
            this._splitPaneOrientationCmb.setSelectedIndex(0);
        }
        this._metaDataCmb.selectClassName(props.getMetaDataOutputClassName());
        this._sqlResultsCmb.selectClassName(props.getSQLResultsOutputClassName());
        this._chkKeepTableLayoutOnRerun.setSelected(props.getKeepTableLayoutOnRerun());
        this._chkShowRowNumberInTextLayout.setSelected(props.getShowRowNumberInTextLayout());
        this._tableContentsCmb.selectClassName(props.getTableContentsOutputClassName());
        this._colorNullValuesController.init(props.isColorNullValues(), props.getNullValueColorRGB());
        this._nullValuesSortingPanel.setNullHighest(props.isSortNullsAsHighestValue());
    }

    void applyChanges(SessionProperties props) {
        props.setShowToolBar(this._showToolBar.isSelected());
        props.setMetaDataOutputClassName(this._metaDataCmb.getSelectedClassName());
        props.setSQLResultsOutputClassName(this._sqlResultsCmb.getSelectedClassName());
        props.setKeepTableLayoutOnRerun(this._chkKeepTableLayoutOnRerun.isSelected());
        props.setShowRowNumberInTextLayout(this._chkShowRowNumberInTextLayout.isSelected());
        props.setTableContentsOutputClassName(this._tableContentsCmb.getSelectedClassName());
        TabPlacement tp = (TabPlacement)this._mainTabPlacementCmb.getSelectedItem();
        props.setMainTabPlacement(tp.getValue());
        tp = (TabPlacement)this._objectTabPlacementCmb.getSelectedItem();
        props.setObjectTabPlacement(tp.getValue());
        tp = (TabPlacement)this._sqlExecutionTabPlacementCmb.getSelectedItem();
        props.setSQLExecutionTabPlacement(tp.getValue());
        tp = (TabPlacement)this._sqlResultsTabPlacementCmb.getSelectedItem();
        props.setSQLResultsTabPlacement(tp.getValue());
        SplitPaneOrientation spOrientation = (SplitPaneOrientation)this._splitPaneOrientationCmb.getSelectedItem();
        props.setSqlPanelOrientation(spOrientation.getValue());
        props.setColorNullValues(this._colorNullValuesController.isColorNullValues());
        props.setNullValueColorRGB(this._colorNullValuesController.getNullValueColorRGB());
        props.setSortNullsAsHighestValue(this._nullValuesSortingPanel.isNullHighest());
    }

    private void createGUI() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.createAppearancePanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.createOutputPanel(), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel(""), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.DATA_TYPE1), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.DATA_TYPE2), gbc);
    }

    private JPanel createAppearancePanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("generalSessionPropertiesPanel.appearance")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        pnl.add((Component)this._showToolBar, gbc);
        ++gbc.gridy;
        pnl.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.MAIN_TAB_PLACEMENT, 4), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.5;
        pnl.add((Component)this._mainTabPlacementCmb, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        pnl.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.OBJECT_TAB_PLACEMENT, 4), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.5;
        pnl.add((Component)this._objectTabPlacementCmb, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        pnl.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.SQL_EXECUTION_TAB_PLACEMENT, 4), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.5;
        pnl.add((Component)this._sqlExecutionTabPlacementCmb, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        pnl.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.SQL_RESULTS_TAB_PLACEMENT, 4), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.5;
        pnl.add((Component)this._sqlResultsTabPlacementCmb, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        pnl.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.SQL_PANEL_ORIENTATION, 4), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.5;
        gbc.gridwidth = 3;
        pnl.add((Component)this._splitPaneOrientationCmb, gbc);
        return pnl;
    }

    private JPanel createOutputPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("editWherColsSheet.output")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        pnl.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.META_DATA, 4), gbc);
        ++gbc.gridx;
        pnl.add((Component)this._metaDataCmb, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        pnl.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.TABLE_CONTENTS, 4), gbc);
        ++gbc.gridx;
        pnl.add((Component)this._tableContentsCmb, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        pnl.add((Component)new JSeparator(0), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        pnl.add((Component)new MultipleLineLabel(s_stringMgr.getString("generalSessionPropertiesPanel.noteOnSqlResults")), gbc);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        gbc.gridx = 0;
        pnl.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.SQL_RESULTS, 4), gbc);
        ++gbc.gridx;
        pnl.add((Component)this._sqlResultsCmb, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        pnl.add((Component)new JSeparator(0), gbc);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        this._chkKeepTableLayoutOnRerun.setText(GeneralSessionPropertiesPanelI18n.KEEP_TABLE_LAYOUT_ON_RERUN);
        pnl.add((Component)this._chkKeepTableLayoutOnRerun, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        this._chkShowRowNumberInTextLayout.setText(GeneralSessionPropertiesPanelI18n.SHOW_ROW_NUMBERS_IN_TEXT_LAYOUT);
        pnl.add((Component)this._chkShowRowNumberInTextLayout, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        pnl.add((Component)this._colorNullValuesController.getPanel(), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 2;
        gbc.insets.top = 10;
        pnl.add((Component)this._nullValuesSortingPanel, gbc);
        return pnl;
    }

    private static final class TabPlacement {
        static final TabPlacement TOP = new TabPlacement(s_stringMgr.getString("generalPropertiesPanel.top"), 1);
        static final TabPlacement LEFT = new TabPlacement(s_stringMgr.getString("generalPropertiesPanel.left"), 2);
        static final TabPlacement BOTTOM = new TabPlacement(s_stringMgr.getString("generalPropertiesPanel.bottom"), 3);
        static final TabPlacement RIGHT = new TabPlacement(s_stringMgr.getString("generalPropertiesPanel.right"), 4);
        private final String _name;
        private final int _value;

        TabPlacement(String name, int value) {
            this._name = name;
            this._value = value;
        }

        public String toString() {
            return this._name;
        }

        int getValue() {
            return this._value;
        }
    }

    private static final class OutputTypeCombo
    extends JComboBox {
        OutputTypeCombo(boolean possiblyEditable) {
            this.addItem(DataSetViewerType.TABLE);
            this.addItem(DataSetViewerType.TEXT);
            if (possiblyEditable) {
                this.addItem(DataSetViewerType.EDITABLE_TABLE);
            }
        }

        void selectClassName(String className) {
            if (className.equals(DataSetViewerTablePanel.class.getName())) {
                this.setSelectedItem(DataSetViewerType.TABLE);
            } else if (className.equals(DataSetViewerTextPanel.class.getName())) {
                this.setSelectedItem(DataSetViewerType.TEXT);
            } else if (className.equals(DataSetViewerEditableTablePanel.class.getName())) {
                this.setSelectedItem(DataSetViewerType.EDITABLE_TABLE);
            }
        }

        String getSelectedClassName() {
            return ((DataSetViewerType)this.getSelectedItem()).getDataSetViewerClassName();
        }
    }

    private static final class SplitPaneOrientationCombo
    extends JComboBox {
        SplitPaneOrientationCombo() {
            this.addItem(SplitPaneOrientation.VERTICAL);
            this.addItem(SplitPaneOrientation.HORIZONTAL);
        }
    }

    private static final class SplitPaneOrientation {
        static final SplitPaneOrientation HORIZONTAL = new SplitPaneOrientation(s_stringMgr.getString("generalPropertiesPanel.horizontal"), 1);
        static final SplitPaneOrientation VERTICAL = new SplitPaneOrientation(s_stringMgr.getString("generalPropertiesPanel.vertical"), 0);
        private final String _name;
        private final int _value;

        SplitPaneOrientation(String name, int value) {
            this._name = name;
            this._value = value;
        }

        public String toString() {
            return this._name;
        }

        int getValue() {
            return this._value;
        }
    }

    private static final class TabPlacementCombo
    extends JComboBox {
        TabPlacementCombo() {
            this.addItem(TabPlacement.TOP);
            this.addItem(TabPlacement.LEFT);
            this.addItem(TabPlacement.BOTTOM);
            this.addItem(TabPlacement.RIGHT);
        }
    }
}

