/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.properties;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SQLResultConfigCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLResultConfigCtrl.class);
    private JCheckBox _sqlLimitRowsChk = new JCheckBox(s_stringMgr.getString("SessionSQLPropertiesPanel.limitrows"));
    private IntegerField _sqlNbrRowsToShowField = new IntegerField(10);
    private JCheckBox _sqlReadOnChk = new JCheckBox(s_stringMgr.getString("SessionSQLPropertiesPanel.readOn"));
    private IntegerField _sqlReadOnBlockSize = new IntegerField(10);
    private MultipleLineLabel _lblReadOnWarning = new MultipleLineLabel(s_stringMgr.getString("SessionSQLPropertiesPanel.readOnWarning"));
    private JCheckBox _sqlUseFetchSizeChk = new JCheckBox(s_stringMgr.getString("SessionSQLPropertiesPanel.fetchSize"));
    private IntegerField _sqlFetchSizeField = new IntegerField(10);
    private boolean _inUpdateControlStatus;

    public SQLResultConfigCtrl() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLResultConfigCtrl.this.updateCheckBoxStatus(evt);
            }
        };
        this._sqlLimitRowsChk.addActionListener(actionListener);
        this._sqlReadOnChk.addActionListener(actionListener);
        this._sqlUseFetchSizeChk.addActionListener(actionListener);
    }

    public void loadData(SessionProperties props) {
        this._sqlLimitRowsChk.setSelected(props.getSQLLimitRows());
        this._sqlNbrRowsToShowField.setInt(props.getSQLNbrRowsToShow());
        this._sqlUseFetchSizeChk.setSelected(props.getSQLUseFetchSize());
        this._sqlFetchSizeField.setInt(props.getSQLFetchSize());
        this._sqlReadOnChk.setSelected(props.getSQLReadOn());
        this._sqlReadOnBlockSize.setInt(props.getSQLReadOnBlockSize());
        this.updateCheckBoxStatus(null);
    }

    public boolean isLimitRows() {
        return this._sqlLimitRowsChk.isSelected();
    }

    public int getNbrRowsToShow() {
        return this._sqlNbrRowsToShowField.getInt();
    }

    public boolean isUseFetchSize() {
        return this._sqlUseFetchSizeChk.isSelected();
    }

    public int getFetchSize() {
        return this._sqlFetchSizeField.getInt();
    }

    public boolean isReadOn() {
        return this._sqlReadOnChk.isSelected();
    }

    public int getReadOnBlockSize() {
        return this._sqlReadOnBlockSize.getInt();
    }

    private void updateCheckBoxStatus(ActionEvent evt) {
        if (this._inUpdateControlStatus) {
            return;
        }
        try {
            this._inUpdateControlStatus = true;
            if (this._sqlReadOnChk.isSelected()) {
                this._sqlLimitRowsChk.setSelected(false);
                this._sqlLimitRowsChk.setEnabled(false);
                this._sqlNbrRowsToShowField.setEnabled(false);
                this._sqlReadOnBlockSize.setEnabled(true);
                this._lblReadOnWarning.setEnabled(true);
            } else {
                this._sqlReadOnBlockSize.setEnabled(false);
                this._lblReadOnWarning.setEnabled(false);
                if (null != evt && evt.getSource() == this._sqlReadOnChk && 0 < this._sqlNbrRowsToShowField.getInt()) {
                    this._sqlLimitRowsChk.setSelected(true);
                }
                this._sqlLimitRowsChk.setEnabled(true);
                this._sqlNbrRowsToShowField.setEnabled(this._sqlLimitRowsChk.isSelected());
            }
            this._sqlFetchSizeField.setEnabled(this._sqlUseFetchSizeChk.isSelected());
        }
        finally {
            this._inUpdateControlStatus = false;
        }
    }

    public JPanel createResultLimitAndReadOnPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)this._sqlLimitRowsChk, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)this._sqlNbrRowsToShowField, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("SessionSQLPropertiesPanel.rows")), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 3, 5), 0, 0);
        ret.add((Component)this._sqlReadOnChk, gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)this._sqlReadOnBlockSize, gbc);
        gbc = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("SessionSQLPropertiesPanel.rowsPerBlock")), gbc);
        gbc = new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0);
        ret.add((Component)this._lblReadOnWarning, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 5, 5, 5), 0, 0);
        ret.add((Component)this._sqlUseFetchSizeChk, gbc);
        gbc = new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(20, 5, 5, 5), 0, 0);
        ret.add((Component)this._sqlFetchSizeField, gbc);
        gbc = new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(20, 5, 5, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("SessionSQLPropertiesPanel.rows")), gbc);
        ret.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("SessionSQLPropertiesPanel.sqlResultLoading")));
        return ret;
    }
}

