/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.schemainfo;

import java.io.Serializable;
import java.util.HashMap;

public class CaseInsensitiveString
implements Comparable<CaseInsensitiveString>,
Serializable {
    private char[] _value = new char[0];
    private int _offset = 0;
    private int _len = 0;
    private int _hash = 0;
    private boolean _isMutable;
    private static HashMap<Character, Character> upChars = new HashMap();
    private static HashMap<Character, Character> lcChars = new HashMap();

    public CaseInsensitiveString(String s) {
        this._value = new char[s.length()];
        s.getChars(0, s.length(), this._value, 0);
        this._offset = 0;
        this._len = s.length();
        this._hash = 0;
        this._isMutable = false;
    }

    public CaseInsensitiveString() {
        this._isMutable = true;
    }

    public void setCharBuffer(char[] buffer, int beginIndex, int len) {
        this.setCharBuffer(buffer, beginIndex, len, false);
    }

    public void setCharBuffer(char[] buffer, int offset, int len, boolean stripDoubleQuotes) {
        if (!this._isMutable) {
            throw new UnsupportedOperationException("This CaseInsensitiveString is immutable");
        }
        this._value = buffer;
        this._offset = offset;
        this._len = len;
        this._hash = 0;
        if (stripDoubleQuotes && 2 < this._len && '\"' == buffer[this._offset] && '\"' == buffer[this._offset + this._len - 1]) {
            ++this._offset;
            this._len -= 2;
        }
    }

    public int hashCode() {
        int h = this._hash;
        if (h == 0) {
            int off = this._offset;
            char[] val = this._value;
            int len = this._len;
            for (int i = 0; i < len; ++i) {
                h = 31 * h + this.toUpperCase(val[off++]);
            }
            this._hash = h;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            String other = (String)obj;
            if (other.length() != this._len) {
                return false;
            }
            for (int i = 0; i < this._len; ++i) {
                char u2;
                char c1 = this._value[this._offset + i];
                char c2 = other.charAt(i);
                char u1 = this.toUpperCase(c1);
                if (u1 == (u2 = this.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
                return false;
            }
            return true;
        }
        if (obj.getClass() == this.getClass()) {
            CaseInsensitiveString other = (CaseInsensitiveString)obj;
            if (other._len != this._len) {
                return false;
            }
            for (int i = 0; i < this._len; ++i) {
                char u2;
                char c1 = this._value[this._offset + i];
                char c2 = other._value[other._offset + i];
                char u1 = Character.toUpperCase(c1);
                if (u1 == (u2 = Character.toUpperCase(c2)) || this.toLowerCase(u1) == this.toLowerCase(u2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return new String(this._value, this._offset, this._len);
    }

    @Override
    public int compareTo(CaseInsensitiveString anotherString) {
        int len1 = this._len;
        int len2 = anotherString._len;
        int n = Math.min(len1, len2);
        char[] v1 = this._value;
        char[] v2 = anotherString._value;
        int i = this._offset;
        int j = anotherString._offset;
        if (i == j) {
            int lim = n + i;
            for (int k = i; k < lim; ++k) {
                char c1 = v1[k];
                char c2 = v2[k];
                if (this.toLowerCase(c1) == this.toLowerCase(c2)) continue;
                return this.toLowerCase(c1) - this.toLowerCase(c2);
            }
        } else {
            while (n-- != 0) {
                char c1 = v1[i++];
                char c2 = v2[j++];
                if (this.toLowerCase(c1) == this.toLowerCase(c2)) continue;
                return this.toLowerCase(c1) - this.toLowerCase(c2);
            }
        }
        return len1 - len2;
    }

    private char toLowerCase(char c) {
        char result = c;
        Character key = Character.valueOf(c);
        if (lcChars.containsKey(key)) {
            return lcChars.get(key).charValue();
        }
        if (Character.isUpperCase(c)) {
            result = Character.toLowerCase(c);
        }
        lcChars.put(key, Character.valueOf(result));
        return result;
    }

    private char toUpperCase(char c) {
        char result = c;
        Character key = Character.valueOf(c);
        if (upChars.containsKey(key)) {
            return upChars.get(key).charValue();
        }
        if (Character.isLowerCase(c)) {
            result = Character.toUpperCase(c);
        }
        upChars.put(key, Character.valueOf(result));
        return result;
    }
}

