/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.schemainfo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.mainframe.action.AliasPropertiesCommand;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SessionStartupTimeHintDlg;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;

public class SessionStartupTimeHintController {
    private ISession _session;
    private SessionStartupTimeHintDlg _dlg;

    public SessionStartupTimeHintController(ISession session) {
        this._session = session;
        this._dlg = new SessionStartupTimeHintDlg(this._session.getApplication().getMainFrame(), session.getApplication());
        this._dlg.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionStartupTimeHintController.this.close();
            }
        });
        this._dlg.btnShowProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionStartupTimeHintController.this.showAliasProperties();
            }
        });
        GUIUtils.enableCloseByEscape(this._dlg, dw -> this.savePrefs());
        this._dlg.setSize(350, 180);
        GUIUtils.centerWithinParent(this._dlg);
        this._dlg.setVisible(true);
    }

    private void showAliasProperties() {
        this.close();
        SwingUtilities.invokeLater(() -> new AliasPropertiesCommand(this._session.getAlias()).execute());
    }

    private void close() {
        this._dlg.dispose();
        this.savePrefs();
    }

    private void savePrefs() {
        SquirrelPreferences squirrelPreferences = this._session.getApplication().getSquirrelPreferences();
        squirrelPreferences.setShowSessionStartupTimeHint(false == this._dlg.chkDontShowAgain.isSelected());
    }
}

