/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.schemainfo.synonym;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.schemainfo.synonym.NetezzaSpecifics;
import net.sourceforge.squirrel_sql.client.session.schemainfo.synonym.NetezzaSynonym;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.TableQualifier;

public class SynonymHandler {
    public static final String SYNONYM_TABLE_TYPE_NAME = "SYNONYM";
    public static final String ALT_SYNONYM_TABLE_TYPE_NAME = "ALIAS";
    private ISQLDatabaseMetaData _sqlDatabaseMetaData;
    private boolean _isInit;
    private boolean _isOracle;
    private boolean _isDB2;
    private boolean _isNetezza;
    private NetezzaSpecifics _netezzaSpecifics = null;

    public SynonymHandler(ISQLDatabaseMetaData sqlDatabaseMetaData) {
        this._sqlDatabaseMetaData = sqlDatabaseMetaData;
    }

    private void initLazy() {
        if (this._isInit) {
            return;
        }
        this._isInit = true;
        this._isNetezza = DialectFactory.isNetezza(this._sqlDatabaseMetaData);
        this._isOracle = DialectFactory.isOracle(this._sqlDatabaseMetaData);
        this._isDB2 = DialectFactory.isDB2(this._sqlDatabaseMetaData);
    }

    public TableQualifier getQualifiedSynonymName(String catalog, String schema, String table) {
        NetezzaSynonym synonym;
        this.initLazy();
        if (!this._isNetezza) {
            return null;
        }
        if (this._netezzaSpecifics == null) {
            this._netezzaSpecifics = new NetezzaSpecifics(this._sqlDatabaseMetaData);
        }
        if ((synonym = this._netezzaSpecifics.findSynonym(catalog, schema, table)) != null) {
            return new TableQualifier(synonym.getCatalog(), synonym.getSchema(), synonym.getTable());
        }
        return null;
    }

    public void appendSynonymTableTypesForSchemaInfoCache(ArrayList<String> tableTypeCandidates) {
        this.initLazy();
        if (this._isOracle || this._isNetezza) {
            tableTypeCandidates.add(SYNONYM_TABLE_TYPE_NAME);
        }
        if (this._isDB2) {
            tableTypeCandidates.add(ALT_SYNONYM_TABLE_TYPE_NAME);
        }
    }

    public boolean ignoreAsCodeCompletionTableInfo(String tableType) {
        this.initLazy();
        if (!this._isOracle) {
            return false;
        }
        return SYNONYM_TABLE_TYPE_NAME.equals(tableType);
    }
}

