/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.sqlbounds;

import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.sqlbounds.SQLStatementSeparatorBasedBoundsHandler;

public class BoundsOfSqlHandler {
    private JTextComponent _textComponent;
    private ISession _session;

    public BoundsOfSqlHandler(JTextComponent textComponent, ISession session) {
        this._textComponent = textComponent;
        this._session = session;
    }

    public int[] getBoundsOfSQLToBeExecuted() {
        int[] bounds = new int[]{this._textComponent.getSelectionStart(), this._textComponent.getSelectionEnd()};
        if (bounds[0] == bounds[1]) {
            bounds = this.getSqlBoundsBySeparatorRule(this._textComponent.getCaretPosition());
        }
        return bounds;
    }

    public int[] getSqlBoundsBySeparatorRule(int iCaretPos) {
        int[] bounds = new int[2];
        String sql = this._textComponent.getText();
        bounds[0] = this.previousIndexOfStateSep(sql, iCaretPos);
        bounds[1] = this.nextIndexOfStateSep(sql, iCaretPos);
        return bounds;
    }

    private int nextIndexOfStateSep(String sql, int pos) {
        if (Main.getApplication().getSquirrelPreferences().isUseStatementSeparatorAsSqlToExecuteBounds()) {
            return SQLStatementSeparatorBasedBoundsHandler.nextIndexOfStateSep(sql, pos, this._session.getQueryTokenizer());
        }
        return this.nextIndexOfNewLineSeparator(sql, pos);
    }

    private int previousIndexOfStateSep(String sql, int pos) {
        if (Main.getApplication().getSquirrelPreferences().isUseStatementSeparatorAsSqlToExecuteBounds()) {
            return SQLStatementSeparatorBasedBoundsHandler.previousIndexOfStateSep(sql, pos, this._session.getQueryTokenizer());
        }
        return this.previousIndexOfNewLineSeparator(sql, pos);
    }

    private int nextIndexOfNewLineSeparator(String sql, int pos) {
        int ix = pos;
        int newLinteCount = 0;
        while (sql.length() != ix) {
            if (!Character.isWhitespace(sql.charAt(ix))) {
                newLinteCount = 0;
            }
            if ('\n' == sql.charAt(ix) && 2 == ++newLinteCount) {
                return ix - 1;
            }
            ++ix;
        }
        return sql.length();
    }

    private int previousIndexOfNewLineSeparator(String sql, int pos) {
        int ix = pos;
        int newLinteCount = 0;
        while (true) {
            if (ix == sql.length()) {
                if (ix == 0) {
                    return ix;
                }
                --ix;
            }
            if (!Character.isWhitespace(sql.charAt(ix))) {
                newLinteCount = 0;
            }
            if ('\n' == sql.charAt(ix) && 2 == ++newLinteCount) {
                return ix + newLinteCount;
            }
            if (0 == ix) {
                return 0 + newLinteCount;
            }
            --ix;
        }
    }

    public String getSQLToBeExecuted() {
        String sql = this._textComponent.getSelectedText();
        if (sql == null || sql.trim().length() == 0) {
            sql = this._textComponent.getText();
            int[] bounds = this.getBoundsOfSQLToBeExecuted();
            sql = bounds[0] >= bounds[1] ? "" : sql.substring(bounds[0], bounds[1]).trim();
        }
        return sql != null ? sql : "";
    }
}

