/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.sqlbounds;

import net.sourceforge.squirrel_sql.fw.sql.commentandliteral.SQLCommentAndLiteralHandler;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.IQueryTokenizer;

public class SQLStatementSeparatorBasedBoundsHandler {
    public static int nextIndexOfStateSep(String sql, int pos, IQueryTokenizer tokenizer) {
        if (0 == sql.length()) {
            return 0;
        }
        pos = SQLStatementSeparatorBasedBoundsHandler.correctPositionIfInOrRightBehindSeparator(sql, pos, tokenizer);
        String separator = tokenizer.getSQLStatementSeparator();
        int sepPos = SQLStatementSeparatorBasedBoundsHandler.getNextSepPos(sql, pos, separator);
        while (sepPos != -1) {
            if (sepPos >= pos && SQLStatementSeparatorBasedBoundsHandler.isValidSeparator(sql, sepPos, tokenizer)) {
                return sepPos + separator.length();
            }
            sepPos = SQLStatementSeparatorBasedBoundsHandler.getNextSepPos(sql, sepPos + 1, separator);
        }
        return sql.length() - 1;
    }

    public static int previousIndexOfStateSep(String sql, int pos, IQueryTokenizer tokenizer) {
        if (0 == sql.length()) {
            return 0;
        }
        pos = SQLStatementSeparatorBasedBoundsHandler.correctPositionIfInOrRightBehindSeparator(sql, pos, tokenizer);
        String separator = tokenizer.getSQLStatementSeparator();
        int sepPos = SQLStatementSeparatorBasedBoundsHandler.getPreviousSepPos(sql, pos, separator);
        while (sepPos > 0) {
            if (sepPos < pos && SQLStatementSeparatorBasedBoundsHandler.isValidSeparator(sql, sepPos, tokenizer)) {
                return SQLStatementSeparatorBasedBoundsHandler.toFirstNonWhiteSpace(sql, sepPos + separator.length());
            }
            sepPos = SQLStatementSeparatorBasedBoundsHandler.getPreviousSepPos(sql, sepPos - 1, separator);
        }
        return SQLStatementSeparatorBasedBoundsHandler.toFirstNonWhiteSpace(sql, 0);
    }

    private static boolean isValidSeparator(String sql, int sepPos, IQueryTokenizer tokenizer) {
        String separator = tokenizer.getSQLStatementSeparator();
        return false == SQLStatementSeparatorBasedBoundsHandler.isCommentOrLiteral(sql, sepPos, tokenizer) && (1 == separator.length() || SQLStatementSeparatorBasedBoundsHandler.isSurroundedByWhiteSpaces(sql, sepPos, separator));
    }

    private static int toFirstNonWhiteSpace(String sql, int sepPos) {
        for (int i = sepPos; i < sql.length(); ++i) {
            if (Character.isWhitespace(sql.charAt(i))) continue;
            return i;
        }
        return sql.length() - 1;
    }

    private static int getPreviousSepPos(String sql, int pos, String sqlStatementSeparator) {
        int prevSepPos = 0;
        int sepPos = sql.indexOf(sqlStatementSeparator);
        while (sepPos >= 0 && sepPos < pos) {
            prevSepPos = sepPos;
            sepPos = sql.indexOf(sqlStatementSeparator, prevSepPos + 1);
        }
        return prevSepPos;
    }

    private static int getNextSepPos(String sql, int pos, String sqlStatementSeparator) {
        int sepPos = sql.indexOf(sqlStatementSeparator, pos);
        return sepPos;
    }

    private static boolean isSurroundedByWhiteSpaces(String sql, int sepPos, String statementSeparator) {
        boolean ret = true;
        if (sepPos > 0) {
            ret = Character.isWhitespace(sql.charAt(sepPos - 1));
        }
        if (sepPos + statementSeparator.length() < sql.length()) {
            ret = ret && Character.isWhitespace(sql.charAt(sepPos + statementSeparator.length()));
        }
        return ret;
    }

    private static boolean isCommentOrLiteral(String sql, int sepPos, IQueryTokenizer tokenizer) {
        SQLCommentAndLiteralHandler clh = new SQLCommentAndLiteralHandler(sql, tokenizer.getLineCommentBegin(), false, false);
        for (int i = 0; i <= sepPos; ++i) {
            clh.nextPosition(i);
        }
        return clh.isInLiteral() || clh.isInLineComment() || clh.isInMultiLineComment();
    }

    private static int correctPositionIfInOrRightBehindSeparator(String sql, int pos, IQueryTokenizer tokenizer) {
        String separator = tokenizer.getSQLStatementSeparator();
        int prevSepPos = SQLStatementSeparatorBasedBoundsHandler.getPreviousSepPos(sql, pos, separator);
        if (pos <= prevSepPos + separator.length() && SQLStatementSeparatorBasedBoundsHandler.isValidSeparator(sql, prevSepPos, tokenizer)) {
            return prevSepPos;
        }
        return pos;
    }
}

