/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.sqlfilter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionDialogWidget;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.ContentsTab;
import net.sourceforge.squirrel_sql.client.session.sqlfilter.ISQLFilterPanel;
import net.sourceforge.squirrel_sql.client.session.sqlfilter.OrderByClausePanel;
import net.sourceforge.squirrel_sql.client.session.sqlfilter.WhereClausePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLFilterSheet
extends SessionDialogWidget {
    private static final ILogger s_log = LoggerController.createLogger(SQLFilterSheet.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLFilterSheet.class);
    private static final String TITLE = s_stringMgr.getString("SQLFilterSheet.title");
    private final IObjectTreeAPI _objectTree;
    private final transient IDatabaseObjectInfo _objectInfo;
    private List<ISQLFilterPanel> _panels = new ArrayList<ISQLFilterPanel>();
    private int _tabSelected;
    private JLabel _titleLbl = new JLabel();
    private JButton _clearFilter = new JButton();
    private transient WhereClausePanel _whereClausePanel = null;
    private transient OrderByClausePanel _orderByClausePanel = null;
    private transient JTable dummytable = new JTable();

    public SQLFilterSheet(IObjectTreeAPI objectTree, IDatabaseObjectInfo objectInfo) {
        super(TITLE, true, objectTree.getSession());
        if (objectInfo == null) {
            throw new IllegalArgumentException("IDatabaseObjectInfo == null");
        }
        this._objectTree = objectTree;
        this._objectInfo = objectInfo;
        this.createGUI();
    }

    @Override
    public synchronized void setVisible(boolean show) {
        boolean reallyShow = true;
        if (show && !this.isVisible()) {
            ContentsTab tab = (ContentsTab)this._objectTree.getTabbedPaneIfSelected(this._objectInfo.getDatabaseObjectType(), ContentsTab.getContentsTabTitle());
            if (tab == null) {
                reallyShow = false;
                String msg = s_stringMgr.getString("SQLFilterSheet.contentsMsg");
                this._objectTree.getSession().showMessage(msg);
            } else {
                boolean isDebug = s_log.isDebugEnabled();
                long start = 0L;
                for (ISQLFilterPanel pnl : this._panels) {
                    if (isDebug) {
                        start = System.currentTimeMillis();
                    }
                    pnl.initialize(tab.getSQLFilterClauses());
                    if (!isDebug) continue;
                    s_log.debug("Panel " + pnl.getTitle() + " initialized in " + (System.currentTimeMillis() - start) + "ms");
                }
                this.pack();
                Dimension d = this.getSize();
                d.width += 5;
                d.height += 5;
                this.setSize(d);
                DialogWidget.centerWithinDesktop(this);
                this.moveToFront();
            }
        }
        if (!show || reallyShow) {
            super.setVisible(show);
        }
    }

    @Override
    public void setTitle(String title) {
        if (null != this._titleLbl) {
            this._titleLbl.setText(title + ": " + this._objectInfo.getSimpleName());
        }
    }

    private void performClose() {
        this.dispose();
    }

    public IDatabaseObjectInfo getDatabaseObjectInfo() {
        return this._objectInfo;
    }

    public IObjectTreeAPI getObjectTree() {
        return this._objectTree;
    }

    private void performOk() {
        boolean isDebug = s_log.isDebugEnabled();
        long start = 0L;
        for (ISQLFilterPanel pnl : this._panels) {
            if (isDebug) {
                start = System.currentTimeMillis();
            }
            pnl.applyChanges();
            if (!isDebug) continue;
            s_log.debug("Panel " + pnl.getTitle() + " applied changes in " + (System.currentTimeMillis() - start) + "ms");
        }
        try {
            ContentsTab cTab = (ContentsTab)this._objectTree.getTabbedPaneIfSelected(this._objectInfo.getDatabaseObjectType(), ContentsTab.getContentsTabTitle());
            if (cTab != null) {
                cTab.refreshComponent();
            }
        }
        catch (DataSetException ex) {
            this.getSession().showErrorMessage(ex);
        }
        this.dispose();
    }

    private void createGUI() {
        LinkedHashMap<String, IDataTypeComponent> columnComponents = new LinkedHashMap<String, IDataTypeComponent>();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.getTitle());
        this.makeToolWindow(true);
        try {
            ISQLConnection sqlConnection = this.getSession().getSQLConnection();
            ITableInfo tableInfo = (ITableInfo)this._objectInfo;
            TableColumnInfo[] columns = sqlConnection.getSQLMetaData().getColumnInfo(tableInfo);
            HibernateDialect dialect = DialectFactory.getDialect(sqlConnection.getSQLMetaData());
            for (TableColumnInfo column : columns) {
                IDataTypeComponent typeComponent = CellComponentFactory.getDataTypeObject(this.dummytable, column, dialect.getDialectType());
                columnComponents.put(column.getColumnName(), typeComponent);
            }
        }
        catch (SQLException ex) {
            String msg = s_stringMgr.getString("SQLFilterSheet.error.columnList", ex);
            this.getSession().getApplication().showErrorDialog(msg);
        }
        this._whereClausePanel = new WhereClausePanel(columnComponents, this._objectInfo.getQualifiedName());
        this._orderByClausePanel = new OrderByClausePanel(columnComponents, this._objectInfo.getQualifiedName());
        this._panels.add(this._whereClausePanel);
        this._panels.add(this._orderByClausePanel);
        JTabbedPane tabPane = UIFactory.getInstance().createTabbedPane();
        for (ISQLFilterPanel pnl : this._panels) {
            String pnlTitle = pnl.getTitle();
            String hint = pnl.getHint();
            tabPane.addTab(pnlTitle, null, pnl.getPanelComponent(), hint);
        }
        tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                SQLFilterSheet.this.setButtonLabel(((JTabbedPane)event.getSource()).getSelectedIndex());
            }
        });
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.setContentPane(contentPane);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        contentPane.add((Component)this._titleLbl, gbc);
        gbc.fill = 0;
        gbc.gridx = 0;
        this.setButtonLabel(0);
        this._tabSelected = 0;
        this._clearFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLFilterSheet.this.clearFilter();
            }
        });
        contentPane.add(this._clearFilter);
        gbc.fill = 1;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weighty = 1.0;
        contentPane.add((Component)tabPane, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.weighty = 0.0;
        contentPane.add((Component)this.createButtonsPanel(), gbc);
        GUIUtils.enableCloseByEscape(this);
    }

    private void clearFilter() {
        if (this._tabSelected == 0) {
            this._whereClausePanel.clearFilter();
        } else {
            this._orderByClausePanel.clearFilter();
        }
    }

    private JPanel createButtonsPanel() {
        JPanel pnl = new JPanel();
        String okLabel = s_stringMgr.getString("SQLFilterSheet.okButtonLabel");
        JButton okBtn = new JButton(okLabel);
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLFilterSheet.this.performOk();
            }
        });
        String closeLabel = s_stringMgr.getString("SQLFilterSheet.closeButtonLabel");
        JButton closeBtn = new JButton(closeLabel);
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLFilterSheet.this.performClose();
            }
        });
        pnl.add(okBtn);
        pnl.add(closeBtn);
        GUIUtils.setJButtonSizesTheSame(okBtn, closeBtn);
        this.getRootPane().setDefaultButton(okBtn);
        return pnl;
    }

    private void setButtonLabel(int tabSelected) {
        String title = null;
        title = tabSelected == 0 ? this._whereClausePanel.getTitle() : this._orderByClausePanel.getTitle();
        String label = s_stringMgr.getString("SQLFilterSheet.clearButtonLabel", title);
        this._clearFilter.setText(label);
        this._tabSelected = tabSelected;
    }

    public static SQLFilterSheet createSheet(IObjectTreeAPI objectTree, IDatabaseObjectInfo objectInfo) {
        return null;
    }
}

