/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.sqlfilter;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.session.sqlfilter.ISQLFilterPanel;
import net.sourceforge.squirrel_sql.client.session.sqlfilter.SQLFilterClauses;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class WhereClausePanel
implements ISQLFilterPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(WhereClausePanel.class);
    private SQLFilterClauses _sqlFilterClauses = new SQLFilterClauses();
    private WhereClauseSubPanel _myPanel;

    public WhereClausePanel(LinkedHashMap<String, IDataTypeComponent> columnComponents, String tableName) throws IllegalArgumentException {
        this._myPanel = new WhereClauseSubPanel(columnComponents, tableName);
    }

    @Override
    public void initialize(SQLFilterClauses sqlFilterClauses) throws IllegalArgumentException {
        if (sqlFilterClauses == null) {
            throw new IllegalArgumentException("Null sqlFilterClauses passed");
        }
        this._sqlFilterClauses = sqlFilterClauses;
        this._myPanel.loadData(this._sqlFilterClauses);
    }

    @Override
    public Component getPanelComponent() {
        return this._myPanel;
    }

    @Override
    public String getTitle() {
        return WhereClauseSubPanel.WhereClauseSubPanelI18n.WHERE_CLAUSE;
    }

    @Override
    public String getHint() {
        return WhereClauseSubPanel.WhereClauseSubPanelI18n.HINT;
    }

    @Override
    public void applyChanges() {
        this._myPanel.applyChanges(this._sqlFilterClauses);
    }

    public void clearFilter() {
        this._myPanel.clearFilter();
    }

    public static String getClauseIdentifier() {
        return WhereClauseSubPanel.WhereClauseSubPanelI18n.WHERE_CLAUSE;
    }

    private static final class WhereClauseSubPanel
    extends JPanel {
        private JComboBox _columnCombo;
        private JLabel _columnLabel = new JLabel(WhereClauseSubPanelI18n.COLUMNS);
        private OperatorTypeCombo _operatorCombo = new OperatorTypeCombo();
        private JLabel _operatorLabel = new JLabel(WhereClauseSubPanelI18n.OPERATORS);
        private JTextField _valueField = new JTextField(10);
        private JLabel _valueLabel = new JLabel(WhereClauseSubPanelI18n.VALUE);
        private AndOrCombo _andOrCombo = new AndOrCombo();
        private JLabel _andOrLabel = new JLabel(" ");
        private JTextArea _whereClauseArea = new JTextArea(10, 40);
        private JButton _addTextButton = new JButton(WhereClauseSubPanelI18n.ADD);
        private String _tableName;
        private Map<String, IDataTypeComponent> _columnComponents;

        WhereClauseSubPanel(LinkedHashMap<String, IDataTypeComponent> columnComponents, String tableName) {
            this._tableName = tableName;
            this._columnCombo = new JComboBox<Object>(columnComponents.keySet().toArray());
            this._columnComponents = columnComponents;
            this.createGUI();
        }

        void loadData(SQLFilterClauses sqlFilterClauses) {
            this._whereClauseArea.setText(sqlFilterClauses.get(WhereClausePanel.getClauseIdentifier(), this._tableName));
            Set<Map.Entry<String, IDataTypeComponent>> entrySet = this._columnComponents.entrySet();
            if (!entrySet.isEmpty()) {
                this._operatorCombo.setItems(entrySet.iterator().next().getValue().getSupportedOperators());
            }
        }

        void applyChanges(SQLFilterClauses sqlFilterClauses) {
            sqlFilterClauses.put(WhereClausePanel.getClauseIdentifier(), this._tableName, this._whereClauseArea.getText());
        }

        private void createGUI() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 4, 4, 4), 0, 0);
            this.add((Component)this.createControlsPanel(), gbc);
            this._whereClauseArea.setBorder(BorderFactory.createEtchedBorder());
            this._whereClauseArea.setLineWrap(true);
            JScrollPane sp = new JScrollPane(this._whereClauseArea, 20, 31);
            gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(4, 4, 4, 4), 0, 0);
            this.add((Component)sp, gbc);
        }

        private JPanel createControlsPanel() {
            JPanel ret = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0);
            ret.add((Component)this._andOrLabel, gbc);
            gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 4, 4, 4), 0, 0);
            ret.add((Component)this._andOrCombo, gbc);
            gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0);
            ret.add((Component)this._columnLabel, gbc);
            gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 4, 4, 4), 0, 0);
            ret.add((Component)this._columnCombo, gbc);
            gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0);
            ret.add((Component)this._operatorLabel, gbc);
            gbc = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 4, 4, 4), 0, 0);
            ret.add((Component)this._operatorCombo, gbc);
            gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0);
            ret.add((Component)this._valueLabel, gbc);
            gbc = new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(4, 4, 4, 4), 0, 0);
            ret.add((Component)this._valueField, gbc);
            gbc = new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0);
            ret.add((Component)this._addTextButton, gbc);
            this._addTextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.addTextToClause();
                }
            });
            this._columnCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    if (event.getStateChange() == 1) {
                        Object item = event.getItem();
                        _operatorCombo.setItems(_columnComponents.get(item).getSupportedOperators());
                    }
                }
            });
            return ret;
        }

        private void addTextToClause() {
            String value = this._valueField.getText();
            String operator = (String)this._operatorCombo.getSelectedItem();
            if (value != null && value.length() > 0 || operator.equals("IS NULL") || operator.equals("IS NOT NULL")) {
                String andOr = (String)this._andOrCombo.getSelectedItem();
                String column = (String)this._columnCombo.getSelectedItem();
                if (this._whereClauseArea.getText().length() > 0) {
                    this._whereClauseArea.append("\n" + andOr + " ");
                }
                IDataTypeComponent typeComponent = this._columnComponents.get(column);
                String result = typeComponent.getCondition(column, operator, value);
                this._whereClauseArea.append(result);
            }
            this._valueField.setText("");
        }

        public void clearFilter() {
            this._whereClauseArea.setText("");
        }

        private static final class AndOrCombo
        extends JComboBox {
            AndOrCombo() {
                this.addItem("AND");
                this.addItem("OR");
            }
        }

        private static final class OperatorTypeCombo
        extends JComboBox {
            private OperatorTypeCombo() {
            }

            public void setItems(String[] supportedOperators) {
                this.removeAllItems();
                for (String operator : supportedOperators) {
                    this.addItem(operator);
                }
            }
        }

        static interface WhereClauseSubPanelI18n {
            public static final String COLUMNS = s_stringMgr.getString("WhereClausePanel.columnLabel");
            public static final String OPERATORS = s_stringMgr.getString("WhereClausePanel.operatorsLabel");
            public static final String VALUE = s_stringMgr.getString("WhereClausePanel.valueLabel");
            public static final String WHERE_CLAUSE = s_stringMgr.getString("WhereClausePanel.whereClauseLabel");
            public static final String HINT = s_stringMgr.getString("WhereClausePanel.hint");
            public static final String ADD = s_stringMgr.getString("WhereClausePanel.addLabel");
            public static final String AND = "AND";
            public static final String OR = "OR";
        }
    }
}

