/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.shortcut;

import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.shortcut.ShortcutUtil;
import org.jfree.chart.util.ObjectUtils;

public class Shortcut {
    private final String _actionName;
    private final KeyStroke _defaultKeyStroke;
    private KeyStroke _userKeyStroke;
    private boolean _userKeyStrokeEmpty;

    public Shortcut(String actionName, KeyStroke defaultKeyStroke) {
        this._actionName = actionName;
        this._defaultKeyStroke = defaultKeyStroke;
    }

    public String getActionName() {
        return this._actionName;
    }

    public String getDefaultKeyStroke() {
        return ShortcutUtil.getKeystrokeString(this._defaultKeyStroke);
    }

    public String getValidKeyStroke() {
        return ShortcutUtil.getKeystrokeString(this.validKeyStroke());
    }

    public KeyStroke validKeyStroke() {
        if (null != this._userKeyStroke) {
            return this._userKeyStroke;
        }
        if (this._userKeyStrokeEmpty) {
            return null;
        }
        return this._defaultKeyStroke;
    }

    public void setUserKeyStroke(KeyStroke userKeyStroke) {
        if (ObjectUtils.equal((Object)userKeyStroke, (Object)this._defaultKeyStroke)) {
            this.restoreDefault();
        } else {
            this._userKeyStroke = userKeyStroke;
            this._userKeyStrokeEmpty = false;
        }
    }

    public boolean hasUserKeyStroke() {
        return null != this._userKeyStroke || this._userKeyStrokeEmpty;
    }

    public void restoreDefault() {
        this._userKeyStroke = null;
        this._userKeyStrokeEmpty = false;
    }

    public String generateKey() {
        return ShortcutUtil.generateKey(this._actionName, this._defaultKeyStroke);
    }

    public String generateUserKeyStrokeString() {
        if (this._userKeyStrokeEmpty) {
            return null;
        }
        return this._userKeyStroke.toString();
    }

    public void setUserKeyStrokeEmpty() {
        this._userKeyStroke = null;
        this._userKeyStrokeEmpty = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shortcut shortcut = (Shortcut)o;
        return this._actionName != null ? this._actionName.equals(shortcut._actionName) : shortcut._actionName == null;
    }

    public int hashCode() {
        return this._actionName != null ? this._actionName.hashCode() : 0;
    }
}

