/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.util.codereformat;

import com.github.vertical_blank.sqlformatter.SqlFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformatException;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformatorConfig;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformatorKernel;
import net.sourceforge.squirrel_sql.client.util.codereformat.ColumnListSpiltHandler;
import net.sourceforge.squirrel_sql.client.util.codereformat.ColumnListSpiltMode;
import net.sourceforge.squirrel_sql.client.util.codereformat.CommentSpec;
import net.sourceforge.squirrel_sql.client.util.codereformat.ICodeReformator;
import net.sourceforge.squirrel_sql.client.util.codereformat.PieceMarkerSpec;
import net.sourceforge.squirrel_sql.client.util.codereformat.SectionsHandler;
import net.sourceforge.squirrel_sql.client.util.codereformat.StateOfPosition;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class CodeReformator
implements ICodeReformator {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CodeReformator.class);
    private String _lineSep = "\n";
    private CodeReformatorConfig _codeReformatorConfig;

    public CodeReformator(CodeReformatorConfig codeReformatorConfig) {
        this._codeReformatorConfig = codeReformatorConfig;
    }

    @Override
    public String reformat(String in) throws CodeReformatException {
        if (this._codeReformatorConfig.isUseVerticalBlankFormatter()) {
            return SqlFormatter.format((String)in, (String)this._codeReformatorConfig.getIndent());
        }
        return this.squirrelInternalFormatting(in);
    }

    private String squirrelInternalFormatting(String in) {
        in = this.flatenWhiteSpaces(in, false);
        PieceMarkerSpec[] markerExcludeComma = this.createPieceMarkerSpecExcludeColon();
        String[] pieces = this.getReformatedPieces(in, markerExcludeComma).toArray(new String[0]);
        if (this._codeReformatorConfig.isDoInsertValuesAlign()) {
            pieces = this.doInsertSpecial(pieces);
        }
        StringBuffer ret = new StringBuffer();
        int indentCount = 0;
        SectionsHandler sectionsHandler = new SectionsHandler(this._codeReformatorConfig.isIndentSections());
        for (int i = 0; i < pieces.length; ++i) {
            if (this.pieceStartsWithComment(pieces[i])) {
                ret.append(pieces[i]);
            } else {
                sectionsHandler.before(pieces[i]);
                if (")".equals(pieces[i])) {
                    --indentCount;
                }
                ret.append(this.indent(pieces[i], indentCount + sectionsHandler.getExtraIndentCount()));
                sectionsHandler.after(pieces[i]);
                if ("(".equals(pieces[i])) {
                    ++indentCount;
                }
            }
            ret.append(this._lineSep);
        }
        this.validate(in, ret.toString());
        return ret.toString();
    }

    private boolean pieceStartsWithComment(String piece) {
        for (CommentSpec commentSpec : this._codeReformatorConfig.getCommentSpecs()) {
            if (!piece.trim().startsWith(commentSpec.commentBegin)) continue;
            return true;
        }
        return false;
    }

    private void validate(String beforeReformat, String afterReformat) throws CodeReformatException {
        String normalizedAfter;
        String normalizedBefore = this.getNormalized(beforeReformat);
        if (!normalizedBefore.equalsIgnoreCase(normalizedAfter = this.getNormalized(afterReformat))) {
            int minLen = Math.min(normalizedAfter.length(), normalizedBefore.length());
            StringBuffer diffPos = new StringBuffer();
            for (int i = 0; i < minLen && Character.toUpperCase(normalizedBefore.charAt(i)) == Character.toUpperCase(normalizedAfter.charAt(i)); ++i) {
                diffPos.append('-');
            }
            diffPos.append('^');
            StringBuilder msg = new StringBuilder(s_stringMgr.getString("codereformat.reformatFailed"));
            msg.append(this._lineSep);
            msg.append(normalizedBefore);
            msg.append(this._lineSep);
            msg.append(normalizedAfter);
            msg.append(this._lineSep);
            msg.append(diffPos.toString());
            msg.append(this._lineSep);
            throw new CodeReformatException(msg.toString());
        }
    }

    private String getNormalized(String s) {
        String ret = s.replaceAll("\\(", " ( ");
        ret = ret.replaceAll("\\)", " ) ");
        ret = ret.replaceAll(",", " , ");
        String sep = this._codeReformatorConfig.getStatementSeparator();
        if (sep.equals("|")) {
            sep = "\\|";
        }
        ret = ret.replaceAll(sep, this.concat(" ", sep, " "));
        return this.flatenWhiteSpaces(ret, true).trim();
    }

    private String concat(String ... strings) {
        StringBuilder result = new StringBuilder();
        for (String string : strings) {
            result.append(string);
        }
        return result.toString();
    }

    private List<String> getReformatedPieces(String in, PieceMarkerSpec[] markers) {
        CodeReformatorKernel kernel = new CodeReformatorKernel(markers, this._codeReformatorConfig.getCommentSpecs(), this._codeReformatorConfig.isLineBreakFor_AND_OR_in_FROM_clause());
        String[] pieces = kernel.toPieces(in);
        ArrayList<String> piecesBuf = new ArrayList<String>();
        ColumnListSpiltHandler columnListSpiltHandler = new ColumnListSpiltHandler(this._codeReformatorConfig.getSelectListSpiltMode());
        for (int i = 0; i < pieces.length; ++i) {
            if (this._codeReformatorConfig.getTrySplitLineLen() < pieces[i].length() || columnListSpiltHandler.requiresSplit()) {
                String[] splitPieces = this.trySplit(pieces[i], 0, this._codeReformatorConfig.getTrySplitLineLen(), columnListSpiltHandler);
                piecesBuf.addAll(Arrays.asList(splitPieces));
                continue;
            }
            piecesBuf.add(pieces[i]);
        }
        return piecesBuf;
    }

    private String[] doInsertSpecial(String[] pieces) {
        int insertBegin = -1;
        boolean hasValues = false;
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList<String> insertPieces = new ArrayList<String>();
        for (int i = 0; i < pieces.length; ++i) {
            if ("INSERT ".length() <= pieces[i].length() && pieces[i].substring(0, "INSERT ".length()).equalsIgnoreCase("INSERT ")) {
                if (-1 != insertBegin) {
                    return pieces;
                }
                insertBegin = i;
            }
            if (-1 == insertBegin) {
                ret.add(pieces[i]);
            } else {
                insertPieces.add(pieces[i]);
            }
            if (-1 < insertBegin && -1 != pieces[i].toUpperCase().indexOf("VALUES")) {
                hasValues = true;
            }
            if (-1 >= insertBegin || !this._codeReformatorConfig.getStatementSeparator().equalsIgnoreCase(pieces[i])) continue;
            if (hasValues) {
                ret.addAll(this.reformatInsert(insertPieces));
            } else {
                ret.addAll(insertPieces);
            }
            insertBegin = -1;
            hasValues = false;
            insertPieces = new ArrayList();
        }
        if (-1 < insertBegin) {
            if (hasValues) {
                ret.addAll(this.reformatInsert(insertPieces));
            } else {
                ret.addAll(insertPieces);
            }
        }
        return ret.toArray(new String[0]);
    }

    private ArrayList<String> reformatInsert(ArrayList<String> piecesIn) {
        String[] pieces = this.splitAsFarAsPossible(piecesIn.toArray(new String[piecesIn.size()]));
        ArrayList<String> insertList = new ArrayList<String>();
        ArrayList<String> valuesList = new ArrayList<String>();
        ArrayList<String> behindInsert = new ArrayList<String>();
        StringBuffer statementBegin = new StringBuffer();
        int braketCountAbsolute = 0;
        for (int i = 0; i < pieces.length; ++i) {
            String buf;
            if (3 < braketCountAbsolute) {
                behindInsert.add(pieces[i]);
            }
            if ("(".equals(pieces[i]) || ")".equals(pieces[i])) {
                ++braketCountAbsolute;
            }
            if (0 == braketCountAbsolute) {
                statementBegin.append(pieces[i]).append(' ');
            }
            if (1 == braketCountAbsolute && !"(".equals(pieces[i]) && !")".equals(pieces[i])) {
                buf = pieces[i].trim();
                if (buf.endsWith(",")) {
                    buf = buf.substring(0, buf.length() - 1);
                } else if (buf.startsWith(",")) {
                    buf = buf.substring(1, buf.length());
                }
                insertList.add(buf);
            }
            if (3 != braketCountAbsolute || "(".equals(pieces[i]) || ")".equals(pieces[i])) continue;
            buf = pieces[i].trim();
            if (buf.endsWith(",")) {
                buf = buf.substring(0, buf.length() - 1);
            } else if (buf.startsWith(",")) {
                buf = buf.substring(1, buf.length());
            }
            valuesList.add(buf);
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (0 == insertList.size()) {
            ret.addAll(piecesIn);
            return ret;
        }
        if (insertList.size() == valuesList.size()) {
            ret.add(statementBegin.toString());
            StringBuffer insert = new StringBuffer();
            StringBuffer values = new StringBuffer();
            String insBuf = (String)insertList.get(0);
            String valsBuf = (String)valuesList.get(0);
            insert.append('(').append(this.adjustLength(insBuf, valsBuf));
            values.append('(').append(this.adjustLength(valsBuf, insBuf));
            for (int i = 1; i < insertList.size(); ++i) {
                insBuf = (String)insertList.get(i);
                valsBuf = (String)valuesList.get(i);
                insert.append(',').append(this.adjustLength(insBuf, valsBuf));
                values.append(',').append(this.adjustLength(valsBuf, insBuf));
            }
            insert.append(") VALUES");
            values.append(')');
            ret.add(insert.toString());
            ret.add(values.toString());
            ret.addAll(behindInsert);
            return ret;
        }
        ret.addAll(piecesIn);
        return ret;
    }

    private String[] splitAsFarAsPossible(String[] pieces) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < pieces.length; ++i) {
            ret.addAll(Arrays.asList(this.trySplit(pieces[i], 0, 1, new ColumnListSpiltHandler(ColumnListSpiltMode.REQUIRE_SPLIT))));
        }
        return ret.toArray(new String[ret.size()]);
    }

    private String adjustLength(String s1, String s2) {
        int max = Math.max(s1.length(), s2.length());
        if (s1.length() == max) {
            return s1;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(s1);
        while (sb.length() < max) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private String[] trySplit(String piece, int braketDepth, int trySplitLineLen, ColumnListSpiltHandler columnListSpiltHandler) {
        CodeReformatorKernel dum;
        String trimmedPiece = piece.trim();
        if (this.hasTopLevelColon(trimmedPiece, dum = new CodeReformatorKernel(new PieceMarkerSpec[0], this._codeReformatorConfig.getCommentSpecs(), this._codeReformatorConfig.isLineBreakFor_AND_OR_in_FROM_clause()))) {
            CodeReformatorKernel crk;
            String[] splitPieces1;
            PieceMarkerSpec[] pms = this.createPieceMarkerSpec(columnListSpiltHandler);
            int internalTrySplitLineLen = trySplitLineLen;
            if (columnListSpiltHandler.requiresSplit()) {
                internalTrySplitLineLen = 1;
            }
            if (1 == (splitPieces1 = (crk = new CodeReformatorKernel(pms, this._codeReformatorConfig.getCommentSpecs(), this._codeReformatorConfig.isLineBreakFor_AND_OR_in_FROM_clause())).toPieces(trimmedPiece)).length) {
                return splitPieces1;
            }
            ArrayList<String> ret = new ArrayList<String>();
            for (int i = 0; i < splitPieces1.length; ++i) {
                if (internalTrySplitLineLen < splitPieces1[i].length() + braketDepth * this._codeReformatorConfig.getIndent().length()) {
                    String[] splitPieces2 = this.trySplit(splitPieces1[i], braketDepth, internalTrySplitLineLen, columnListSpiltHandler);
                    for (int j = 0; j < splitPieces2.length; ++j) {
                        ret.add(splitPieces2[j].trim());
                    }
                    continue;
                }
                ret.add(splitPieces1[i].trim());
            }
            return this.purgeEmptyStrings(ret).toArray(new String[0]);
        }
        int[] tlbi = this.getTopLevelBraketIndexes(trimmedPiece, dum);
        if (-1 != tlbi[0] && tlbi[0] < tlbi[1]) {
            PieceMarkerSpec[] pms = this.createPieceMarkerSpec(columnListSpiltHandler);
            CodeReformatorKernel crk = new CodeReformatorKernel(pms, this._codeReformatorConfig.getCommentSpecs(), this._codeReformatorConfig.isLineBreakFor_AND_OR_in_FROM_clause());
            String[] splitPieces1 = crk.toPieces(trimmedPiece.substring(tlbi[0] + 1, tlbi[1]));
            ArrayList<String> buf = new ArrayList<String>();
            buf.add(trimmedPiece.substring(0, tlbi[0]).trim());
            buf.add("(");
            for (int i = 0; i < splitPieces1.length; ++i) {
                buf.add(splitPieces1[i]);
            }
            buf.add(")");
            if (tlbi[1] + 1 < trimmedPiece.length()) {
                buf.add(trimmedPiece.substring(tlbi[1] + 1, trimmedPiece.length()).trim());
            }
            splitPieces1 = buf.toArray(new String[0]);
            ArrayList<String> ret = new ArrayList<String>();
            for (int i = 0; i < splitPieces1.length; ++i) {
                if (trySplitLineLen < splitPieces1[i].length() + braketDepth * this._codeReformatorConfig.getIndent().length()) {
                    String[] splitPieces2 = this.trySplit(splitPieces1[i], braketDepth + 1, trySplitLineLen, columnListSpiltHandler);
                    for (int j = 0; j < splitPieces2.length; ++j) {
                        ret.add(splitPieces2[j]);
                    }
                    continue;
                }
                ret.add(splitPieces1[i]);
            }
            return this.purgeEmptyStrings(ret).toArray(new String[0]);
        }
        return new String[]{piece};
    }

    private PieceMarkerSpec[] createPieceMarkerSpec(ColumnListSpiltHandler columnListSpiltHandler) {
        PieceMarkerSpec[] pms = columnListSpiltHandler.allowsSplit() ? this.createPieceMarkerSpecIncludeColon() : this.createPieceMarkerSpecExcludeColon();
        return pms;
    }

    private List<String> purgeEmptyStrings(List<String> items) {
        Iterator<String> iter = items.iterator();
        while (iter.hasNext()) {
            String item = iter.next();
            if (item != null && !"".equals(item)) continue;
            iter.remove();
        }
        return items;
    }

    private boolean hasTopLevelColon(String piece, CodeReformatorKernel crk) {
        int ix = piece.indexOf(",");
        StateOfPosition[] stateOfPositions = crk.getStatesOfPosition(piece);
        while (-1 != ix) {
            if (stateOfPositions[ix].isTopLevel) {
                return true;
            }
            if (ix >= piece.length() - 1) break;
            ix = piece.indexOf(",", ix + 1);
        }
        return false;
    }

    private int[] getTopLevelBraketIndexes(String piece, CodeReformatorKernel crk) {
        int[] ret = new int[]{-1, -1};
        StateOfPosition[] stateOfPositions = crk.getStatesOfPosition(piece);
        int bra = piece.indexOf("(");
        while (-1 != bra) {
            crk.getStatesOfPosition(piece);
            if (0 == bra || stateOfPositions[bra - 1].isTopLevel) {
                ret[0] = bra;
                break;
            }
            if (bra >= piece.length() - 1) break;
            bra = piece.indexOf("(", bra + 1);
        }
        if (-1 == ret[0]) {
            return ret;
        }
        int ket = piece.indexOf(")", bra);
        while (-1 != ket) {
            if (ket == piece.length() - 1 || stateOfPositions[ket].isTopLevel) {
                ret[1] = ket;
                break;
            }
            if (ket >= piece.length() - 1) break;
            ket = piece.indexOf(")", ket + 1);
        }
        return ret;
    }

    private String indent(String piece, int callDepth) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < callDepth; ++i) {
            sb.append(this._codeReformatorConfig.getIndent());
        }
        sb.append(piece);
        return sb.toString();
    }

    private String flatenWhiteSpaces(String in, boolean force) {
        if (this.hasCommentEndingWithLineFeed(in) && !force) {
            return in;
        }
        StringBuffer ret = new StringBuffer();
        int aposCount = 0;
        char lastAppended = '\u0000';
        for (int i = 0; i < in.length(); ++i) {
            if ('\'' == in.charAt(i)) {
                ++aposCount;
            }
            boolean append = true;
            if (0 == aposCount % 2 && Character.isWhitespace(in.charAt(i))) {
                if (i + 1 < in.length() && Character.isWhitespace(in.charAt(i + 1))) {
                    append = false;
                } else if (',' == lastAppended) {
                    append = false;
                } else if (i + 1 < in.length() && ',' == in.charAt(i + 1)) {
                    append = false;
                }
            }
            if (!append) continue;
            lastAppended = Character.isWhitespace(in.charAt(i)) && 0 == aposCount % 2 ? (char)' ' : in.charAt(i);
            ret.append(lastAppended);
        }
        return ret.toString();
    }

    boolean hasCommentEndingWithLineFeed(String in) {
        CodeReformatorKernel dum = new CodeReformatorKernel(new PieceMarkerSpec[0], this._codeReformatorConfig.getCommentSpecs(), this._codeReformatorConfig.isLineBreakFor_AND_OR_in_FROM_clause());
        StateOfPosition[] sops = dum.getStatesOfPosition(in);
        boolean inComment = false;
        for (int i = 0; i < sops.length; ++i) {
            if (!inComment && -1 < sops[i].commentIndex) {
                if (-1 < this._codeReformatorConfig.getCommentSpecs()[sops[i].commentIndex].commentEnd.indexOf(10)) {
                    return true;
                }
                inComment = true;
            }
            if (-1 != sops[i].commentIndex) continue;
            inComment = false;
        }
        return false;
    }

    private PieceMarkerSpec[] createPieceMarkerSpecIncludeColon() {
        PieceMarkerSpec[] buf = this.createPieceMarkerSpecExcludeColon();
        ArrayList<PieceMarkerSpec> ret = new ArrayList<PieceMarkerSpec>();
        ret.addAll(Arrays.asList(buf));
        int type = this._codeReformatorConfig.isCommasAtLineBegin() ? 0 : 1;
        ret.add(new PieceMarkerSpec(",", type));
        return ret.toArray(new PieceMarkerSpec[0]);
    }

    private PieceMarkerSpec[] createPieceMarkerSpecExcludeColon() {
        ArrayList<PieceMarkerSpec> ret = new ArrayList<PieceMarkerSpec>();
        ret.addAll(Arrays.asList(this._codeReformatorConfig.getKeywordPieceMarkerSpecs()));
        ret.add(new PieceMarkerSpec(this._codeReformatorConfig.getStatementSeparator(), 2));
        return ret.toArray(new PieceMarkerSpec[ret.size()]);
    }
}

