/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.completion.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import net.sourceforge.squirrel_sql.fw.completion.util.CompletionUtils;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class CompletionParser {
    private static final String DEREF_CHAR = ".";
    private static final String DOUBLE_QUOTE_CHAR = "\"";
    private ArrayList<String> _tokens;
    private String _stringToParse;
    private int _stringToParsePosition;
    private String _stringToReplace;
    private String _textTillCarret;

    public CompletionParser(String textTillCarret) {
        this(textTillCarret, false);
    }

    public CompletionParser(String textTillCarret, boolean completeQualified) {
        this._textTillCarret = textTillCarret;
        this._stringToParse = StringUtilities.stripDoubleQuotes(CompletionUtils.getStringToParse(textTillCarret));
        this._stringToParsePosition = CompletionUtils.getStringToParsePosition(textTillCarret);
        StringTokenizer st = new StringTokenizer(this._stringToParse, DEREF_CHAR);
        this._tokens = new ArrayList();
        while (st.hasMoreTokens()) {
            this._tokens.add(StringUtilities.stripDoubleQuotes(st.nextToken()));
        }
        if (textTillCarret.endsWith(DEREF_CHAR) || textTillCarret.endsWith(".\"") || 0 == this._tokens.size()) {
            this._tokens.add("");
        }
        this._stringToReplace = completeQualified ? this._stringToParse : this._tokens.get(this._tokens.size() - 1);
    }

    public boolean isQualified() {
        return 1 < this._tokens.size();
    }

    public String getStringToParse() {
        return this._stringToParse;
    }

    public String getToken(int index) {
        return this._tokens.get(index);
    }

    public int size() {
        return this._tokens.size();
    }

    public int getStringToParsePosition() {
        return this._stringToParsePosition;
    }

    public String getStringToReplace() {
        return this._stringToReplace;
    }

    public int getReplacementStart() {
        return this._textTillCarret.length() - this._stringToReplace.length();
    }

    public String getTextTillCarret() {
        return this._textTillCarret;
    }

    public String getLastToken() {
        return this._tokens.get(this._tokens.size() - 1);
    }

    public String getAllButFirst() {
        Object ret = this._tokens.get(1);
        for (int i = 2; i < this._tokens.size(); ++i) {
            ret = (String)ret + DEREF_CHAR + this._tokens.get(i);
        }
        return ret;
    }
}

