/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewAccess;
import net.sourceforge.squirrel_sql.fw.datasetviewer.RowNumberTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TableClickPosition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TablePopupMenuHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.ColoringService;
import net.sourceforge.squirrel_sql.fw.gui.RectangleSelectionHandler;
import net.sourceforge.squirrel_sql.fw.gui.table.ButtonTableHeader;
import net.sourceforge.squirrel_sql.fw.gui.table.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public final class DataSetViewerTable
extends JTable {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataSetViewerTable.class);
    private ILogger s_log = LoggerController.createLogger(DataSetViewerTable.class);
    private DataSetViewerTablePanel _dataSetViewerTablePanel;
    private ISession _session;
    private final int _multiplier;
    private static final String data = "THE QUICK BROWN FOX JUMPED OVER THE LAZY DOG";
    private TablePopupMenuHandler _tablePopupMenuHandler;
    private RectangleSelectionHandler _rectangleSelectionHandler = new RectangleSelectionHandler(this);
    private RowNumberTableColumn _rowNumberTableColumn;
    private ButtonTableHeader _tableHeader = new ButtonTableHeader();
    private ColoringService _coloringService;

    DataSetViewerTable(DataSetViewerTablePanel dataSetViewerTablePanel, IDataSetViewAccess dataSetViewAccess, IDataSetUpdateableModel dataSetUpdateableModel, int listSelectionMode, ISession session) {
        super(new SortableTableModel(new DataSetViewerTableModel(dataSetViewerTablePanel)));
        this._dataSetViewerTablePanel = dataSetViewerTablePanel;
        this._session = session;
        this._multiplier = this.getFontMetrics(this.getFont()).stringWidth(data) / data.length();
        this.setRowHeight(this.getFontMetrics(this.getFont()).getHeight());
        boolean allowUpdate = false;
        if (dataSetUpdateableModel != null && !dataSetViewAccess.isTableEditable()) {
            allowUpdate = true;
        }
        this.createGUI(allowUpdate, dataSetUpdateableModel, listSelectionMode, session);
        this._dataSetViewerTablePanel.setCellEditors(this);
        this._coloringService = new ColoringService(this);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this._rectangleSelectionHandler.paintRectWhenNeeded(g);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        TableCellEditor cellEditor = super.getCellEditor(row, col);
        this._dataSetViewerTablePanel.setCurrentCellEditor((DefaultCellEditor)cellEditor);
        return cellEditor;
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        if (e.getKeyChar() == '\b' && this.getEditorComponent() != null && ((RestorableJTextField)this.getEditorComponent()).getText().equals("<null>")) {
            return;
        }
        super.processKeyEvent(e);
        if (this.getEditorComponent() != null && e.getID() == 400 && ((RestorableJTextField)this.getEditorComponent()).getText().length() == 7 && ((RestorableJTextField)this.getEditorComponent()).getText().equals("<null>" + e.getKeyChar())) {
            ((RestorableJTextField)this.getEditorComponent()).updateText("" + e.getKeyChar());
        }
    }

    @Override
    public void setValueAt(Object newValueString, int row, int col) {
        if (!(newValueString instanceof String)) {
            super.setValueAt(newValueString, row, col);
            return;
        }
        StringBuffer messageBuffer = new StringBuffer();
        int modelIndex = this.getColumnModel().getColumn(col).getModelIndex();
        ColumnDisplayDefinition colDef = this._dataSetViewerTablePanel.getColumnDefinitions()[modelIndex];
        Object newValueObject = CellComponentFactory.validateAndConvert(colDef, this.getValueAt(row, col), (String)newValueString, messageBuffer);
        if (messageBuffer.length() > 0) {
            String msg = s_stringMgr.getString("dataSetViewerTablePanel.textCantBeConverted", messageBuffer);
            if (this.s_log.isDebugEnabled()) {
                this.s_log.debug("setValueAt: msg from DataTypeComponent was: " + msg);
            }
            JOptionPane.showMessageDialog(this, msg, s_stringMgr.getString("dataSetViewerTablePanel.conversionError"), 0);
        } else {
            super.setValueAt(newValueObject, row, col);
        }
    }

    public void setColumnDefinitions(ColumnDisplayDefinition[] colDefs) {
        TableColumnModel tcm = this.createColumnModel(colDefs);
        this.setColumnModel(tcm);
        this.getDataSetViewerTableModel().setHeadings(colDefs);
        this._dataSetViewerTablePanel.setCellEditors(this);
        this._tablePopupMenuHandler.reset();
    }

    public DataSetViewerTableModel getDataSetViewerTableModel() {
        return (DataSetViewerTableModel)((SortableTableModel)this.getModel()).getActualModel();
    }

    public SortableTableModel getSortableTableModel() {
        return (SortableTableModel)this.getModel();
    }

    private void displayPopupMenu(MouseEvent evt, TableClickPosition tableClickPosition) {
        this._tablePopupMenuHandler.displayPopupMenu(evt, tableClickPosition);
    }

    private TableColumnModel createColumnModel(ColumnDisplayDefinition[] colDefs) {
        DefaultTableColumnModel cm = new DefaultTableColumnModel();
        this._rowNumberTableColumn = new RowNumberTableColumn();
        for (int i = 0; i < colDefs.length; ++i) {
            int colWidth;
            ColumnDisplayDefinition colDef = colDefs[i];
            if (null == colDef.getAbsoluteWidth()) {
                colWidth = colDef.getDisplayWidth() * this._multiplier;
                if (colWidth > 50 * this._multiplier) {
                    colWidth = 50 * this._multiplier;
                } else if (colWidth < 3 * this._multiplier) {
                    colWidth = 3 * this._multiplier;
                }
            } else {
                colWidth = colDef.getAbsoluteWidth();
            }
            CellRenderer tableCellRenderer = CellComponentFactory.getTableCellRenderer(colDefs[i]);
            tableCellRenderer.setColoringService(this._coloringService);
            ExtTableColumn col = new ExtTableColumn(i, colWidth, tableCellRenderer, null);
            String headerValue = colDef.getColumnHeading();
            col.setHeaderValue(headerValue);
            col.setColumnDisplayDefinition(colDef);
            cm.addColumn(col);
        }
        return cm;
    }

    void setShowRowNumbers(boolean show) {
        this.getColumnModel().removeColumn(this._rowNumberTableColumn);
        if (show) {
            this.getColumnModel().addColumn(this._rowNumberTableColumn);
            this.getColumnModel().moveColumn(this.getColumnModel().getColumnCount() - 1, 0);
        }
        this._tablePopupMenuHandler.ensureRowNumersMenuItemIsUpToDate(show);
    }

    public boolean isShowingRowNumbers() {
        try {
            this.getColumnModel().getColumnIndex(RowNumberTableColumn.ROW_NUMBER_COL_IDENTIFIER);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private void createGUI(boolean allowUpdate, IDataSetUpdateableModel dataSetUpdateableModel, int selectionMode, ISession session) {
        this.setSelectionMode(selectionMode);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(true);
        this.getTableHeader().setResizingAllowed(true);
        this.getTableHeader().setReorderingAllowed(true);
        this.setAutoCreateColumnsFromModel(false);
        this.setAutoResizeMode(0);
        this.setTableHeader(this._tableHeader);
        this._tableHeader.setTable(this);
        this._tablePopupMenuHandler = new TablePopupMenuHandler(allowUpdate, dataSetUpdateableModel, this._dataSetViewerTablePanel, session);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DataSetViewerTable.this.onMousePressed(evt, new TableClickPosition(false, evt));
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DataSetViewerTable.this.onMouseReleased(evt, new TableClickPosition(false, evt));
            }
        });
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DataSetViewerTable.this.onMousePressed(evt, new TableClickPosition(true, evt));
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DataSetViewerTable.this.onMouseReleased(evt, new TableClickPosition(true, evt));
            }
        });
    }

    private void onMouseReleased(MouseEvent evt, TableClickPosition tableClickPosition) {
        if (evt.isPopupTrigger()) {
            this.displayPopupMenu(evt, tableClickPosition);
        }
    }

    private void onMousePressed(MouseEvent evt, TableClickPosition tableClickPosition) {
        if (evt.isPopupTrigger()) {
            this.displayPopupMenu(evt, tableClickPosition);
        } else if (evt.getClickCount() == 2 && !tableClickPosition.isClickedOnTableHeader()) {
            int columnIndexAtX;
            Point pt = evt.getPoint();
            TableColumnModel cm = this.getColumnModel();
            int modelIndex = cm.getColumn(columnIndexAtX = cm.getColumnIndexAtX(pt.x)).getModelIndex();
            if (-42 != modelIndex) {
                ColumnDisplayDefinition[] colDefs = this._dataSetViewerTablePanel.getColumnDefinitions();
                CellDataPopup.showDialog(this, colDefs[modelIndex], evt, this._dataSetViewerTablePanel.isTableEditable());
            }
        }
    }

    public void initColWidths() {
        this._tableHeader.initColWidths();
    }

    public ColoringService getColoringService() {
        return this._coloringService;
    }

    public void scrollToVisible(int viewRow, int viewCol) {
        Rectangle cellRect = this.getCellRect(viewRow, viewCol, true);
        this.scrollRectToVisible(cellRect);
        this.repaint(cellRect);
    }

    public ButtonTableHeader getButtonTableHeader() {
        return (ButtonTableHeader)this.getTableHeader();
    }

    public int[] getSelectedModelRows() {
        int[] selectedViewRows = this.getSelectedRows();
        int[] ret = new int[selectedViewRows.length];
        for (int i = 0; i < selectedViewRows.length; ++i) {
            ret[i] = ((SortableTableModel)this.getModel()).transformToModelRow(selectedViewRows[i]);
        }
        return ret;
    }

    public ISession getSessionOrNull() {
        return this._session;
    }
}

