/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sourceforge.squirrel_sql.client.session.DataModelImplementationDetails;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BaseDataSetViewerDestination;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnHeaderDisplay;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ContinueReadChannel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ContinueReadHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTableListSelectionHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewAccess;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.MoveColumnsToFrontHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.RowColSelectedCountListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.RowSelectionListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ScrollColumnToVisibleHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TableState;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.LimitReadLengthFeatureUnstable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.DefaultFindService;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.FindService;

public class DataSetViewerTablePanel
extends BaseDataSetViewerDestination
implements IDataSetViewAccess,
Printable {
    private DataSetViewerTable _table = null;
    private IDataSetUpdateableModel _updateableModel;
    private DataSetViewerTableListSelectionHandler _selectionHandler;
    private DataModelImplementationDetails _dataModelImplementationDetails = new DataModelImplementationDetails();
    private ContinueReadHandler _continueReadHandler;
    private List<RowColSelectedCountListener> _rowColSelectedCountListeners = new ArrayList<RowColSelectedCountListener>();
    JTableHeader tableHeader;
    int[] subTableSplit = null;
    boolean pageinfoCalculated = false;
    int totalNumPages = 0;
    int prevPageIndex = 0;
    int subPageIndex = 0;
    int subTableSplitSize = 0;
    double tableHeightOnFullPage;
    double headerHeight;
    double pageWidth;
    double pageHeight;
    int fontHeight;
    int fontDesent;
    double tableHeight;
    double rowHeight;
    double scale = 0.6666666666666666;

    @Override
    public void init(IDataSetUpdateableModel updateableModel, ISession session) {
        this.init(updateableModel, 1, session);
    }

    public void init(IDataSetUpdateableModel updateableModel, int listSelectionMode, ISession session) {
        this.init(updateableModel, listSelectionMode, null, session);
    }

    @Override
    public void init(IDataSetUpdateableModel updateableModel, DataModelImplementationDetails dataModelImplementationDetails, ISession session) {
        this.init(updateableModel, 1, dataModelImplementationDetails, session);
    }

    public void init(IDataSetUpdateableModel dataSetUpdateableModel, int listSelectionMode, DataModelImplementationDetails dataModelImplementationDetails, ISession session) {
        if (null != dataModelImplementationDetails) {
            this._dataModelImplementationDetails = dataModelImplementationDetails;
        }
        this._table = new DataSetViewerTable(this, this, dataSetUpdateableModel, listSelectionMode, session);
        this._continueReadHandler = new ContinueReadHandler(this._table);
        this._selectionHandler = new DataSetViewerTableListSelectionHandler(this._table);
        this._updateableModel = dataSetUpdateableModel;
        this.setUpdateableModelReference(this._updateableModel);
        this._table.getSelectionModel().addListSelectionListener(e -> this.onSelectionChanged(e));
    }

    private void onSelectionChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        for (RowColSelectedCountListener l : this._rowColSelectedCountListeners.toArray(new RowColSelectedCountListener[0])) {
            l.rowColSelectedCountOrPosChanged(this._table.getSelectedRowCount(), this._table.getSelectedColumnCount(), this._table.getSelectedRow(), this._table.getSelectedColumn());
        }
    }

    @Override
    public void addRowColSelectedCountListener(RowColSelectedCountListener rowColSelectedCountListener) {
        this._rowColSelectedCountListeners.add(rowColSelectedCountListener);
    }

    public IDataSetUpdateableModel getUpdateableModel() {
        return this._updateableModel;
    }

    public DataModelImplementationDetails getDataModelImplementationDetails() {
        return this._dataModelImplementationDetails;
    }

    @Override
    public void clear() {
        this._table.getDataSetViewerTableModel().clear();
        this._table.getDataSetViewerTableModel().fireTableDataChanged();
    }

    @Override
    public void setColumnDefinitions(ColumnDisplayDefinition[] colDefs) {
        super.setColumnDefinitions(colDefs);
        this._table.setColumnDefinitions(colDefs);
        this._table.getColumnModel().getSelectionModel().addListSelectionListener(e -> this.onSelectionChanged(e));
    }

    @Override
    public void moveToTop() {
        if (this._table.getRowCount() > 0) {
            this._table.setRowSelectionInterval(0, 0);
        }
    }

    @Override
    public Component getComponent() {
        return this._table;
    }

    public DataSetViewerTable getTable() {
        return this._table;
    }

    @Override
    protected void addRow(Object[] row) {
        this._table.getDataSetViewerTableModel().addRow(row);
    }

    public Object[] getRow(int row) {
        Object[] values = new Object[this._table.getDataSetViewerTableModel().getColumnCount()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this._table.getDataSetViewerTableModel().getValueAt(row, i);
        }
        return values;
    }

    @Override
    protected void allRowsAdded() {
        this._table.getDataSetViewerTableModel().fireTableStructureChanged();
        this._table.initColWidths();
    }

    @Override
    public int getRowCount() {
        return this._table.getDataSetViewerTableModel().getRowCount();
    }

    public void setShowRowNumbers(boolean showRowNumbers) {
        this._table.setShowRowNumbers(showRowNumbers);
    }

    public void addRowSelectionListener(RowSelectionListener rowSelectionListener) {
        this._selectionHandler.addRowSelectionListener(rowSelectionListener);
    }

    public void removeRowSelectionListener(RowSelectionListener rowSelectionListener) {
        this._selectionHandler.removeRowSelectionListener(rowSelectionListener);
    }

    public int[] getSeletedRows() {
        return this._table.getSelectedRows();
    }

    public int[] getSelectedModelRows() {
        return this._table.getSelectedModelRows();
    }

    public int getColumnWidthForHeader(String header) {
        TableColumnModel columnModel = this._table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            if (!columnModel.getColumn(i).getHeaderValue().equals(header)) continue;
            return columnModel.getColumn(i).getWidth();
        }
        throw new IllegalStateException("No col with header: " + header);
    }

    public FindService createFindService() {
        return new DefaultFindService(this._table, this.getColumnDefinitions());
    }

    @Override
    public void switchColumnHeader(ColumnHeaderDisplay columnHeaderDisplay) {
        Enumeration<TableColumn> e = this._table.getColumnModel().getColumns();
        while (e.hasMoreElements()) {
            ExtTableColumn col = (ExtTableColumn)e.nextElement();
            if (ColumnHeaderDisplay.COLUMN_NAME == columnHeaderDisplay) {
                col.setHeaderValue(col.getColumnDisplayDefinition().getColumnName());
                continue;
            }
            if (ColumnHeaderDisplay.COLUMN_LABEL != columnHeaderDisplay) continue;
            col.setHeaderValue(col.getColumnDisplayDefinition().getLabel());
        }
        this._table.getTableHeader().repaint();
    }

    public void scrollColumnToVisible(ExtTableColumn columnDisplayDefinition) {
        new ScrollColumnToVisibleHandler(this._table, columnDisplayDefinition);
    }

    public void moveColumnsToFront(ArrayList<ExtTableColumn> columnsToMoveToFront) {
        MoveColumnsToFrontHandler.moveColumnsToFront(this._table, columnsToMoveToFront);
    }

    @Override
    public boolean isTableEditable() {
        return false;
    }

    @Override
    public boolean isColumnEditable(int col, Object originalValue) {
        return false;
    }

    @Override
    public boolean needToReRead(int col, Object originalValue) {
        return CellComponentFactory.needToReRead(this.getColDefs()[col], originalValue);
    }

    @Override
    public Object reReadDatum(Object[] values, int col, StringBuffer message) {
        if (null == this._updateableModel) {
            LimitReadLengthFeatureUnstable.unknownTable();
            return values[col];
        }
        return ((IDataSetUpdateableTableModel)this._updateableModel).reReadDatum(values, this.getColDefs(), col, message);
    }

    @Override
    public void setCellEditors(DataSetViewerTable table) {
    }

    @Override
    public int[] changeUnderlyingValueAt(int row, int col, Object newValue, Object oldValue) {
        return new int[0];
    }

    @Override
    public void deleteRows(int[] rows) {
    }

    @Override
    public void insertRow() {
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        if (pageIndex == 0) {
            this.pageinfoCalculated = false;
        }
        if (!this.pageinfoCalculated) {
            this.getPageInfo(g, pageFormat);
        }
        g2.setColor(Color.black);
        if (pageIndex >= this.totalNumPages) {
            return 1;
        }
        if (this.prevPageIndex != pageIndex) {
            ++this.subPageIndex;
            if (this.subPageIndex == this.subTableSplitSize - 1) {
                this.subPageIndex = 0;
            }
        }
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int rowIndex = pageIndex / (this.subTableSplitSize - 1);
        this.printTablePart(g2, pageFormat, rowIndex, this.subPageIndex);
        this.prevPageIndex = pageIndex;
        return 0;
    }

    public void getPageInfo(Graphics g, PageFormat pageFormat) {
        this.subTableSplit = null;
        this.subTableSplitSize = 0;
        this.subPageIndex = 0;
        this.prevPageIndex = 0;
        this.fontHeight = (int)((double)g.getFontMetrics().getHeight() * this.scale);
        this.fontDesent = (int)((double)g.getFontMetrics().getDescent() * this.scale);
        this.tableHeader = this._table.getTableHeader();
        this.headerHeight = (double)this.tableHeader.getHeight() + (double)this._table.getRowMargin() * this.scale;
        this.pageHeight = pageFormat.getImageableHeight();
        this.pageWidth = pageFormat.getImageableWidth();
        this.tableHeight = (double)this._table.getHeight() * this.scale;
        this.rowHeight = (double)this._table.getRowHeight() + (double)this._table.getRowMargin() * this.scale;
        this.tableHeightOnFullPage = (int)(this.pageHeight - this.headerHeight - (double)(this.fontHeight * 2));
        this.tableHeightOnFullPage = this.tableHeightOnFullPage / this.rowHeight * this.rowHeight;
        TableColumnModel tableColumnModel = this.tableHeader.getColumnModel();
        int columns = tableColumnModel.getColumnCount();
        int columnMargin = (int)((double)tableColumnModel.getColumnMargin() * this.scale);
        int[] temp = new int[columns];
        temp[0] = 0;
        int length = 0;
        this.subTableSplitSize = 0;
        for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
            int columnWidth = (int)((double)tableColumnModel.getColumn(columnIndex).getWidth() * this.scale);
            if ((double)(length + columnWidth + columnMargin) > this.pageWidth) {
                temp[this.subTableSplitSize + 1] = temp[this.subTableSplitSize] + length;
                length = columnWidth;
                ++this.subTableSplitSize;
                continue;
            }
            length += columnWidth + columnMargin;
        }
        if (length > 0) {
            temp[this.subTableSplitSize + 1] = temp[this.subTableSplitSize] + length;
            ++this.subTableSplitSize;
        }
        ++this.subTableSplitSize;
        this.subTableSplit = new int[this.subTableSplitSize];
        for (int i = 0; i < this.subTableSplitSize; ++i) {
            this.subTableSplit[i] = temp[i];
        }
        this.totalNumPages = (int)(this.tableHeight / this.tableHeightOnFullPage);
        if (this.tableHeight % this.tableHeightOnFullPage >= this.rowHeight) {
            ++this.totalNumPages;
        }
        this.totalNumPages *= this.subTableSplitSize - 1;
        this.pageinfoCalculated = true;
    }

    public void printTablePart(Graphics2D g2, PageFormat pageFormat, int rowIndex, int columnIndex) {
        String pageNumber = "Page: " + (rowIndex + 1);
        if (this.subTableSplitSize > 1) {
            pageNumber = pageNumber + "-" + (columnIndex + 1);
        }
        int pageLeft = this.subTableSplit[columnIndex];
        int pageRight = this.subTableSplit[columnIndex + 1];
        int pageWidth = pageRight - pageLeft;
        g2.setFont(new Font(g2.getFont().getName(), g2.getFont().getStyle(), 8));
        g2.drawString(pageNumber, pageWidth / 2 - 35, (int)(this.pageHeight - (double)this.fontHeight));
        double clipHeight = Math.min(this.tableHeightOnFullPage, this.tableHeight - (double)rowIndex * this.tableHeightOnFullPage);
        g2.translate(-this.subTableSplit[columnIndex], 0);
        g2.setClip(pageLeft, 0, pageWidth, (int)this.headerHeight);
        g2.scale(this.scale, this.scale);
        this.tableHeader.paint(g2);
        g2.scale(1.0 / this.scale, 1.0 / this.scale);
        g2.translate(0.0, this.headerHeight);
        g2.translate(0.0, -this.tableHeightOnFullPage * (double)rowIndex);
        g2.setClip(pageLeft, (int)this.tableHeightOnFullPage * rowIndex, pageWidth, (int)clipHeight);
        g2.scale(this.scale, this.scale);
        this._table.paint(g2);
        g2.scale(1.0 / this.scale, 1.0 / this.scale);
        double pageTop = this.tableHeightOnFullPage * (double)rowIndex - this.headerHeight;
        g2.drawRect(pageLeft, (int)pageTop, pageWidth, (int)(clipHeight + this.headerHeight));
    }

    @Override
    public TableState getResultSortableTableState() {
        return new TableState(this._table);
    }

    @Override
    public void applyResultSortableTableState(TableState sortableTableState) {
        sortableTableState.apply(this._table);
    }

    @Override
    public void setContinueReadChannel(ContinueReadChannel continueReadChannel) {
        this._continueReadHandler.setContinueReadChannel(continueReadChannel);
    }

    @Override
    public void disableContinueRead() {
        this._continueReadHandler.disableContinueRead();
    }

    @Override
    public void moveRowColListenersToMe(IDataSetViewer dataSetViewer) {
        if (!(dataSetViewer instanceof DataSetViewerTablePanel)) {
            return;
        }
        this._rowColSelectedCountListeners.clear();
        this._rowColSelectedCountListeners.addAll(((DataSetViewerTablePanel)dataSetViewer)._rowColSelectedCountListeners);
    }
}

