/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.client.session.DataModelImplementationDetails;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.SimpleDataSet;

public class DataSetViewerTablePanelUtil {
    public static List<ExtTableColumn> getTableColumns(DataSetViewerTable table) {
        ArrayList<ExtTableColumn> ret = new ArrayList<ExtTableColumn>();
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            TableColumn col = table.getColumnModel().getColumn(i);
            if (!(col instanceof ExtTableColumn)) continue;
            ret.add((ExtTableColumn)col);
        }
        return ret;
    }

    public static DataSetViewerTablePanel createDataSetViewerTablePanel(List<Object[]> allRows, List<ColumnDisplayDefinition> columnDisplayDefinitions) {
        return DataSetViewerTablePanelUtil.createDataSetViewerTablePanel(allRows, columnDisplayDefinitions, null);
    }

    public static DataSetViewerTablePanel createDataSetViewerTablePanel(List<Object[]> allRows, List<ColumnDisplayDefinition> columnDisplayDefinitions, ISession session) {
        try {
            DataSetViewerTablePanel dsv = new DataSetViewerTablePanel();
            if (null != session) {
                dsv.init(null, new DataModelImplementationDetails(session), session);
            } else {
                dsv.init(null, null);
            }
            SimpleDataSet ods = new SimpleDataSet(allRows, columnDisplayDefinitions.toArray(new ColumnDisplayDefinition[columnDisplayDefinitions.size()]));
            dsv.show(ods);
            return dsv;
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }
}

