/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DatabaseTypesDataSet
implements IDataSet {
    private int[] _columnIndices;
    private int _columnCount;
    private DataSetDefinition _dataSetDefinition;
    private List<Object[]> _allData = new ArrayList<Object[]>();
    private int _currentRowIdx = -1;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DatabaseTypesDataSet.class);

    public DatabaseTypesDataSet(ResultSet rs) throws DataSetException {
        this(rs, null);
    }

    public DatabaseTypesDataSet(ResultSet rs, int[] columnIndices) throws DataSetException {
        if (columnIndices != null && columnIndices.length == 0) {
            columnIndices = null;
        }
        this._columnIndices = columnIndices;
        if (rs != null) {
            try {
                ResultSetMetaData md = rs.getMetaData();
                this._columnCount = columnIndices != null ? columnIndices.length : md.getColumnCount();
                this._dataSetDefinition = new DataSetDefinition(this.createColumnDefinitions(md, columnIndices));
            }
            catch (SQLException ex) {
                throw new DataSetException(ex);
            }
        }
        this.setResultSet(rs);
    }

    @Override
    public final int getColumnCount() {
        return this._columnCount;
    }

    @Override
    public DataSetDefinition getDataSetDefinition() {
        return this._dataSetDefinition;
    }

    @Override
    public boolean next(IMessageHandler msgHandler) throws DataSetException {
        if (this._currentRowIdx < this._allData.size() - 1) {
            ++this._currentRowIdx;
            return true;
        }
        return false;
    }

    private Object[] getNextRow(ResultSet rs) throws SQLException {
        Object[] _row = new Object[this._columnCount];
        block19: for (int i = 0; i < this._columnCount; ++i) {
            int idx = this._columnIndices != null ? this._columnIndices[i] : i + 1;
            switch (idx) {
                case 2: {
                    int data = rs.getInt(idx);
                    StringBuilder buf = new StringBuilder();
                    buf.append(String.valueOf(data)).append(" [").append(JDBCTypeMapper.getJdbcTypeName(data)).append("]");
                    _row[i] = buf.toString();
                    continue block19;
                }
                case 3: 
                case 14: 
                case 15: 
                case 18: {
                    _row[i] = rs.getObject(idx);
                    if (_row[i] == null || _row[i] instanceof Integer) continue block19;
                    if (_row[i] instanceof Number) {
                        _row[i] = ((Number)_row[i]).intValue();
                        continue block19;
                    }
                    _row[i] = Integer.valueOf(_row[i].toString());
                    continue block19;
                }
                case 7: {
                    short nullable = rs.getShort(idx);
                    switch (nullable) {
                        case 0: {
                            _row[i] = s_stringMgr.getString("DatabaseMetaData.nullableTypeNoNulls");
                            continue block19;
                        }
                        case 1: {
                            _row[i] = s_stringMgr.getString("DatabaseMetaData.nullableTypeNullable");
                            continue block19;
                        }
                        case 2: {
                            _row[i] = s_stringMgr.getString("DatabaseMetaData.nullableTypeNullableUnknown");
                            continue block19;
                        }
                    }
                    _row[i] = nullable + "[error]";
                    continue block19;
                }
                case 8: 
                case 10: 
                case 11: 
                case 12: {
                    _row[i] = rs.getObject(idx);
                    if (_row[i] == null || _row[i] instanceof Boolean) continue block19;
                    if (_row[i] instanceof Number) {
                        if (((Number)_row[i]).intValue() == 0) {
                            _row[i] = Boolean.FALSE;
                            continue block19;
                        }
                        _row[i] = Boolean.TRUE;
                        continue block19;
                    }
                    _row[i] = Boolean.valueOf(_row[i].toString());
                    continue block19;
                }
                case 9: {
                    short searchable = rs.getShort(idx);
                    switch (searchable) {
                        case 0: {
                            _row[i] = s_stringMgr.getString("DatabaseMetaData.searchableTypePredNone");
                            continue block19;
                        }
                        case 1: {
                            _row[i] = s_stringMgr.getString("DatabaseMetaData.searchableTypePredChar");
                            continue block19;
                        }
                        case 2: {
                            _row[i] = s_stringMgr.getString("DatabaseMetaData.searchableTypePredBasic");
                            continue block19;
                        }
                        case 3: {
                            _row[i] = s_stringMgr.getString("DatabaseMetaData.searchableTypeSearchable");
                            continue block19;
                        }
                    }
                    _row[i] = searchable + "[error]";
                    continue block19;
                }
                case 16: 
                case 17: {
                    continue block19;
                }
                default: {
                    _row[i] = rs.getString(idx);
                }
            }
        }
        return _row;
    }

    @Override
    public Object get(int columnIndex) {
        Object[] currentRow = this._allData.get(this._currentRowIdx);
        return currentRow[columnIndex];
    }

    private ColumnDisplayDefinition[] createColumnDefinitions(ResultSetMetaData md, int[] columnIndices) throws SQLException {
        ColumnDisplayDefinition[] columnDefs = new ColumnDisplayDefinition[this._columnCount];
        for (int i = 0; i < this._columnCount; ++i) {
            int idx = columnIndices != null ? columnIndices[i] : i + 1;
            String columnLabel = md.getColumnLabel(idx);
            int columnLabelLength = 1;
            if (null != columnLabel) {
                columnLabelLength = columnLabel.length();
            }
            columnDefs[i] = new ColumnDisplayDefinition(Math.max(columnLabelLength, Math.min(md.getColumnDisplaySize(idx), columnLabelLength + 10)), columnLabel);
        }
        return columnDefs;
    }

    private void setResultSet(ResultSet rs) throws DataSetException {
        if (rs == null) {
            return;
        }
        try {
            while (rs.next()) {
                Object[] row = this.getNextRow(rs);
                this._allData.add(row);
            }
        }
        catch (SQLException e) {
            throw new DataSetException(e);
        }
        finally {
            SQLUtilities.closeResultSet(rs);
        }
    }
}

