/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.util.Iterator;
import java.util.Map;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class MapDataSet
implements IDataSet {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MapDataSet.class);
    private static final int s_columnCount = 2;
    private static final String[] s_hdgs = new String[]{i18n.NAME_COLUMN, i18n.VALUE_COLUMN};
    private final Map<?, ?> _src;
    private DataSetDefinition _dsDef;
    private static final int[] s_hdgLens = new int[]{30, 100};
    private Iterator<?> _rowKeys;
    private Object[] _curRow = new Object[2];

    public MapDataSet(Map<?, ?> src) {
        if (src == null) {
            throw new IllegalArgumentException("Map == null");
        }
        this._src = src;
        this._dsDef = new DataSetDefinition(this.createColumnDefinitions());
        this._rowKeys = this._src.keySet().iterator();
    }

    @Override
    public final int getColumnCount() {
        return 2;
    }

    @Override
    public DataSetDefinition getDataSetDefinition() {
        return this._dsDef;
    }

    @Override
    public synchronized boolean next(IMessageHandler msgHandler) {
        this._curRow[0] = null;
        this._curRow[1] = null;
        if (this._rowKeys.hasNext()) {
            this._curRow[0] = this._rowKeys.next();
        }
        if (this._curRow[0] != null) {
            this._curRow[1] = this._src.get(this._curRow[0]);
        }
        return this._curRow[0] != null;
    }

    @Override
    public Object get(int columnIndex) {
        return this._curRow[columnIndex];
    }

    private ColumnDisplayDefinition[] createColumnDefinitions() {
        int columnCount = this.getColumnCount();
        ColumnDisplayDefinition[] columnDefs = new ColumnDisplayDefinition[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columnDefs[i] = new ColumnDisplayDefinition(s_hdgLens[i], s_hdgs[i]);
        }
        return columnDefs;
    }

    private static interface i18n {
        public static final String UNSUPPORTED = s_stringMgr.getString("mapdataset.unsupported");
        public static final String NAME_COLUMN = s_stringMgr.getString("mapdataset.key");
        public static final String VALUE_COLUMN = s_stringMgr.getString("mapdataset.value");
    }
}

