/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BlockMode;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetReadState;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetWrapperSessionLocal;
import net.sourceforge.squirrel_sql.fw.datasetviewer.StatementCallback;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.TimeOutUtil;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultSetWrapper {
    private static final ILogger s_log = LoggerController.createLogger(ResultSetWrapper.class);
    private final ResultSet _resultSet;
    private final StatementCallback _statementCallback;
    private ResultSetReadState _readState = new ResultSetReadState();
    private boolean _followUpBlockReached;

    public ResultSetWrapper(ResultSet resultSet, StatementCallback statementCallback) {
        this._resultSet = resultSet;
        this._statementCallback = statementCallback;
    }

    public ResultSetWrapper(ResultSet resultSet) {
        this(resultSet, null);
    }

    public ResultSet getResultSet() {
        return this._resultSet;
    }

    public void closeIfContinueReadIsNotActive() {
        if (this.isContinueReadActive()) {
            return;
        }
        ResultSetWrapperSessionLocal sessionLocal = this.getResultSetWrapperSessionLocal();
        if (!sessionLocal.isCallingIsLastFailed()) {
            try {
                this._readState.setWasLastResultRowRead(TimeOutUtil.callWithTimeout(() -> this._readState.isResNextHasReturnedFalse() || false == this._resultSet.next()));
            }
            catch (Throwable e) {
                s_log.warn("Failed to call ResultSet.next() to detect if the last row read was the last row of the ResultSet. Limit rows display my be erroneous when number of rows exactly matches rows limit.", e);
                sessionLocal.setCallingIsLastFailed();
            }
        }
        this.closeStatementAndResultSet();
    }

    private ResultSetWrapperSessionLocal getResultSetWrapperSessionLocal() {
        ResultSetWrapperSessionLocal ret = (ResultSetWrapperSessionLocal)this._statementCallback.getSession().getSessionLocal(ResultSetWrapper.class);
        if (null == ret) {
            ret = new ResultSetWrapperSessionLocal();
            this._statementCallback.getSession().putSessionLocal(ResultSetWrapper.class, ret);
        }
        return ret;
    }

    private boolean isContinueReadActive() {
        return null != this._statementCallback && this._statementCallback.isContinueReadActive();
    }

    public boolean next(BlockMode blockMode) throws SQLException {
        if (!this.isContinueReadActive()) {
            if (null == this._statementCallback || !this._statementCallback.isMaxRowsWasSet() || this._readState.getCountRowsRead() < this._statementCallback.getMaxRowsCount()) {
                return this._nextOnResultSet();
            }
            return false;
        }
        if (BlockMode.FIRST_BLOCK == blockMode) {
            boolean ret;
            boolean bl = ret = this._readState.getCountRowsRead() < this._statementCallback.getFirstBlockCount() && this._nextOnResultSet();
            if (!ret) {
                this._readState.setCountRowsRead(0);
            }
            return ret;
        }
        if (BlockMode.FOLLOW_UP_BLOCK == blockMode) {
            boolean ret;
            this._followUpBlockReached = true;
            boolean bl = ret = this._readState.getCountRowsRead() < this._statementCallback.getContinueBlockCount() && this._nextOnResultSet();
            if (!ret) {
                this._readState.setCountRowsRead(0);
            }
            return ret;
        }
        if (BlockMode.INDIFFERENT == blockMode) {
            return this._nextOnResultSet();
        }
        throw new IllegalStateException("Unknown BlockMode " + blockMode);
    }

    private boolean _nextOnResultSet() throws SQLException {
        boolean ret = this._resultSet.next();
        if (ret) {
            this._readState.incCountRowsRead();
        } else {
            this._readState.setResNextHasReturnedFalse(true);
            if (this._followUpBlockReached) {
                this.closeStatementAndResultSet();
            }
        }
        return ret;
    }

    public boolean isAllResultsRead() {
        return this._readState.isResNextHasReturnedFalse() || false == this.isContinueReadActive();
    }

    public void closeStatementAndResultSet() {
        try {
            SQLUtilities.closeResultSet(this._resultSet);
        }
        finally {
            if (null != this._statementCallback) {
                this._statementCallback.closeStatementIfContinueReadActive();
            }
        }
    }

    public boolean areAllPossibleResultsOfSQLRead() {
        return this._readState.isResNextHasReturnedFalse();
    }

    public boolean isResultLimitedByMaxRowsCount() {
        if (this._readState.isResNextHasReturnedFalse()) {
            return false;
        }
        return !this._readState.wasLastResultRowRead();
    }
}

