/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.menuattic.AtticHandler;
import net.sourceforge.squirrel_sql.client.session.menuattic.MenuOrigin;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TableClickPosition;
import net.sourceforge.squirrel_sql.fw.gui.TablePopupMenu;

public class TablePopupMenuHandler {
    private final boolean _allowUpdate;
    private final IDataSetUpdateableModel _dataSetUpdateableModel;
    private final DataSetViewerTablePanel _dataSetViewerTablePanel;
    private final ISession _session;
    private TablePopupMenu _tablePopupMenu;
    private boolean _currentRowNumberMenuItemState;

    public TablePopupMenuHandler(boolean allowUpdate, IDataSetUpdateableModel dataSetUpdateableModel, DataSetViewerTablePanel dataSetViewerTablePanel, ISession session) {
        this._allowUpdate = allowUpdate;
        this._dataSetUpdateableModel = dataSetUpdateableModel;
        this._dataSetViewerTablePanel = dataSetViewerTablePanel;
        this._session = session;
        this.createTableMenuPopupWhenTableIsPresent();
    }

    private void createTableMenuPopupWhenTableIsPresent() {
        this._createTableMenuPopupWhenTableIsPresent(new int[1]);
    }

    private void _createTableMenuPopupWhenTableIsPresent(int[] counter) {
        if (null == this._dataSetViewerTablePanel.getTable()) {
            if (5 == counter[0]) {
                throw new IllegalStateException("Failed to create TablePopupMenu");
            }
            counter[0] = counter[0] + 1;
            SwingUtilities.invokeLater(() -> this._createTableMenuPopupWhenTableIsPresent(counter));
        } else {
            this._tablePopupMenu = new TablePopupMenu(this._allowUpdate, this._dataSetUpdateableModel, this._dataSetViewerTablePanel, this._session);
        }
    }

    public void reset() {
        this._currentRowNumberMenuItemState = false;
    }

    public void displayPopupMenu(MouseEvent evt, TableClickPosition tableClickPosition) {
        this._tablePopupMenu.ensureRowNumbersMenuItemIsUpToDate(this._currentRowNumberMenuItemState);
        AtticHandler.initAtticForMenu(this._tablePopupMenu, MenuOrigin.SQL_RESULT);
        this._tablePopupMenu.showPopupMenu(evt.getComponent(), evt.getX(), evt.getY(), tableClickPosition);
    }

    public void ensureRowNumersMenuItemIsUpToDate(boolean currentRowNumberMenutItemState) {
        this._currentRowNumberMenuItemState = currentRowNumberMenutItemState;
    }
}

