/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.RowNumberTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TableStateSortingItem;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.RowColorHandlerState;
import net.sourceforge.squirrel_sql.fw.gui.table.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.gui.table.TableSortingAdmin;
import net.sourceforge.squirrel_sql.fw.gui.table.TableSortingItem;

public class TableState {
    private final int _selectedCol;
    private final int _selectedRow;
    private boolean _applySorting;
    private List<TableStateSortingItem> _tableStateSortingItems = new ArrayList<TableStateSortingItem>();
    private Rectangle _visibleRect;
    private HashMap<Integer, Integer> _columnWidthsByModelIndex = new HashMap();
    private HashMap<Integer, Integer> _columnIndexByModelIndex = new HashMap();
    private int[] _selectedRows = new int[0];
    private RowColorHandlerState _rowColorHandlerState;
    private boolean _isShowingRowNumbers;

    public TableState(JTable table) {
        if (table.getModel() instanceof SortableTableModel) {
            this._applySorting = true;
            for (TableSortingItem tableSortingItem : ((SortableTableModel)table.getModel()).getTableSortingAdmin().getTableSortingItems()) {
                this._tableStateSortingItems.add(new TableStateSortingItem(tableSortingItem.getSortedModelColumn(), tableSortingItem.getColumnOrder()));
            }
        }
        this._selectedRows = table.getSelectedRows();
        this._selectedRow = table.getSelectedRow();
        this._selectedCol = table.getSelectedColumn();
        int decrementForRowNumberColumn = 0;
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            if (column instanceof RowNumberTableColumn) {
                decrementForRowNumberColumn = 1;
                continue;
            }
            this._columnWidthsByModelIndex.put(column.getModelIndex(), column.getWidth());
            this._columnIndexByModelIndex.put(column.getModelIndex(), i - decrementForRowNumberColumn);
        }
        this._visibleRect = table.getVisibleRect();
        if (table instanceof DataSetViewerTable) {
            this._rowColorHandlerState = ((DataSetViewerTable)table).getColoringService().getUserColorHandler().getState();
            this._isShowingRowNumbers = ((DataSetViewerTable)table).isShowingRowNumbers();
        }
    }

    public void apply(final JTable table) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TableState.this.doApply(table);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void doApply(JTable table) {
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            Integer width = this._columnWidthsByModelIndex.get(table.getColumnModel().getColumn(i).getModelIndex());
            if (null == width) continue;
            table.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        for (Integer modelIndex : this._columnIndexByModelIndex.keySet()) {
            this.moveTo(table.getColumnModel(), modelIndex, this._columnIndexByModelIndex.get(modelIndex));
        }
        if (this._applySorting && table.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)table.getModel();
            TableSortingAdmin tableSortingAdmin = sortableTableModel.getTableSortingAdmin();
            tableSortingAdmin.clear();
            for (TableStateSortingItem tableStateSortingItem : this._tableStateSortingItems) {
                tableSortingAdmin.updateSortedColumn(tableStateSortingItem.getSortedModelColumn(), tableStateSortingItem.getColumnOrder(), false);
            }
            sortableTableModel.sortTableBySortingAdmin();
        }
        table.getSelectionModel().clearSelection();
        if (-1 < this._selectedCol && -1 < this._selectedRow) {
            table.requestFocus();
            table.changeSelection(this._selectedRow, this._selectedCol, false, false);
        }
        for (int selectedRow : this._selectedRows) {
            table.getSelectionModel().addSelectionInterval(selectedRow, selectedRow);
        }
        if (table instanceof DataSetViewerTable) {
            ((DataSetViewerTable)table).getColoringService().getUserColorHandler().applyState(this._rowColorHandlerState);
            if (this._isShowingRowNumbers) {
                ((DataSetViewerTable)table).setShowRowNumbers(true);
            }
        }
        table.scrollRectToVisible(this._visibleRect);
    }

    private void moveTo(TableColumnModel columnModel, int modelIndex, int columnIndex) {
        if (columnIndex >= columnModel.getColumnCount() || columnIndex < 0) {
            return;
        }
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            if (modelIndex != columnModel.getColumn(i).getModelIndex()) continue;
            columnModel.moveColumn(i, columnIndex);
            break;
        }
    }
}

