/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.sql.Blob;
import java.util.Arrays;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BinaryDisplayConverter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class BlobDescriptor {
    Blob _blob;
    byte[] _data = null;
    private boolean _blobRead = false;
    private boolean _wholeBlobRead = false;
    private int _userSetBlobLimit;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(BlobDescriptor.class);
    private String _blobStringCache;

    public BlobDescriptor(Blob blob, byte[] data, boolean blobRead, boolean wholeBlobRead, int userSetBlobLimit) {
        this._blob = blob;
        this._data = data;
        this._blobRead = blobRead;
        this._wholeBlobRead = wholeBlobRead;
        this._userSetBlobLimit = userSetBlobLimit;
    }

    public boolean equals(BlobDescriptor c) {
        if (c == null) {
            return this._blobRead && this._data == null;
        }
        if (!c.getBlobRead()) {
            return !this._blobRead;
        }
        if (!this._blobRead) {
            return false;
        }
        return Arrays.equals(c.getData(), this._data);
    }

    public String toString() {
        if (null != this._blobStringCache) {
            return this._blobStringCache;
        }
        if (this._blobRead) {
            if (this._data == null) {
                return null;
            }
            Byte[] useValue = Utilities.toBoxedByteArray(this._data);
            String outString = BinaryDisplayConverter.convertToString(useValue, 16, false);
            this._blobStringCache = this._wholeBlobRead || this._userSetBlobLimit > this._data.length ? outString : outString + "...";
        } else {
            this._blobStringCache = s_stringMgr.getString("BlobDescriptor.blob");
        }
        return this._blobStringCache;
    }

    public Blob getBlob() {
        return this._blob;
    }

    public void setBlob(Blob blob) {
        this._blob = blob;
    }

    public byte[] getData() {
        return this._data;
    }

    public void setData(byte[] data) {
        this._data = data;
    }

    public boolean getBlobRead() {
        return this._blobRead;
    }

    public void setBlobRead(boolean blobRead) {
        this._blobRead = blobRead;
    }

    public boolean wasWholeBlobRead() {
        return this._wholeBlobRead;
    }

    public void setWholeBlobRead(boolean wholeBlobRead) {
        this._wholeBlobRead = wholeBlobRead;
    }

    public int getUserSetBlobLimit() {
        return this._userSetBlobLimit;
    }

    public void setUserSetBlobLimit(int userSetBlobLimit) {
        this._userSetBlobLimit = userSetBlobLimit;
    }
}

