/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseKeyTextHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BigDataRenderResult;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BinaryDisplayConverter;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BlobDescriptor;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BlobResult;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBlobOkPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBlobProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeUnknown;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.EmptyWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IsNullWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DataTypeBlob
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataTypeBlob.class);
    private static ILogger s_log = LoggerController.createLogger(DataTypeBlob.class);
    private boolean _isNullable;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private static DataTypeBlobProperties s_properties = new DataTypeBlobProperties();

    public DataTypeBlob(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        s_properties.loadProperties();
    }

    public DataTypeBlobProperties getProperties() {
        return s_properties;
    }

    @Override
    public String getClassName() {
        return "net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BlobDescriptor";
    }

    @Override
    public String renderObject(Object value) {
        return DefaultColumnRenderer.renderObject(value);
    }

    private static String renderForTextArea(Object value, ColumnDisplayDefinition colDef) {
        Byte[] useValue = value instanceof BlobDescriptor ? Utilities.toBoxedByteArray(((BlobDescriptor)value).getData(), 10000) : Utilities.toBoxedByteArray(value, 10000);
        if (null != useValue && useValue.length == 10000) {
            BigDataRenderResult.showMaxBytesReachedMessage(colDef);
        }
        String renderResult = DefaultColumnRenderer.renderObject(BinaryDisplayConverter.convertToString(useValue, 16, false));
        return renderResult;
    }

    @Override
    public boolean isEditableInCell(Object originalValue) {
        return this.wasWholeBlobRead(originalValue);
    }

    public boolean wasWholeBlobRead(Object originalValue) {
        if (originalValue instanceof BlobDescriptor) {
            return ((BlobDescriptor)originalValue).wasWholeBlobRead();
        }
        return false;
    }

    @Override
    public boolean needToReRead(Object originalValue) {
        return false;
    }

    @Override
    public JTextField getJTextField(JTable table) {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeBlob.this._textComponent, evt, DataTypeBlob.this._table);
                    CellDataPopup.showDialog(DataTypeBlob.this._table, DataTypeBlob.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    @Override
    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        BlobDescriptor bdesc;
        Byte[] byteClassData;
        if (value.equals("<null>")) {
            return null;
        }
        try {
            byteClassData = BinaryDisplayConverter.convertToBytes(value, 16, false);
        }
        catch (Exception e) {
            messageBuffer.append(e.toString() + "\n");
            return null;
        }
        byte[] byteData = new byte[byteClassData.length];
        for (int i = 0; i < byteClassData.length; ++i) {
            byteData[i] = byteClassData[i];
        }
        if (originalValue == null) {
            bdesc = new BlobDescriptor(null, byteData, true, true, 0);
        } else {
            bdesc = (BlobDescriptor)originalValue;
            bdesc = new BlobDescriptor(bdesc.getBlob(), byteData, true, true, 0);
        }
        return bdesc;
    }

    @Override
    public boolean useBinaryEditingPanel() {
        return true;
    }

    @Override
    public boolean isEditableInPopup(Object originalValue) {
        return this.wasWholeBlobRead(originalValue);
    }

    @Override
    public JTextArea getJTextArea(Object value, ColumnDisplayDefinition colDef) {
        this._textComponent = new RestorableJTextArea();
        String renderRes = DataTypeBlob.renderForTextArea(value, colDef);
        ((RestorableJTextArea)this._textComponent).setText(renderRes);
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    @Override
    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    public boolean tryReadWholeBlob(Object value) {
        if (value instanceof BlobDescriptor) {
            return this._wholeBlobRead((BlobDescriptor)value);
        }
        return false;
    }

    private boolean _wholeBlobRead(BlobDescriptor bdesc) {
        if (bdesc == null) {
            return true;
        }
        if (bdesc.wasWholeBlobRead()) {
            return true;
        }
        try {
            byte[] data = bdesc.getBlob().getBytes(1L, (int)bdesc.getBlob().length());
            bdesc.setBlobRead(true);
            bdesc.setData(data);
            bdesc.setWholeBlobRead(true);
            bdesc.setUserSetBlobLimit(0);
            return true;
        }
        catch (Exception ex) {
            bdesc.setBlobRead(false);
            bdesc.setWholeBlobRead(false);
            bdesc.setData(null);
            s_log.warn("Failed to read Blob in DataTypeBlob.wholeBlobRead(...): " + ex);
            return false;
        }
    }

    @Override
    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        return DataTypeBlob.staticReadResultSet(rs, index);
    }

    public static Object staticReadResultSet(ResultSet rs, int index) throws SQLException {
        int len;
        BlobResult blobResult;
        s_properties.loadProperties();
        try {
            blobResult = DataTypeBlob.getBlobRespectingUnsupportedFeatureException(rs, index);
            if (rs.wasNull()) {
                return null;
            }
            if (!blobResult.isBlob()) {
                return blobResult.getAsString();
            }
        }
        catch (Exception e) {
            return DataTypeBlob.handleBlobReadException(rs, index, e);
        }
        if (!s_properties.isReadBlobsOnTableLoading()) {
            return new BlobDescriptor(blobResult.getBlob(), null, false, false, 0);
        }
        byte[] blobData = null;
        if (blobResult != null && (len = (int)blobResult.getBlob().length()) > 0) {
            int charsToRead = len;
            if (!s_properties.isReadCompleteBlobs()) {
                charsToRead = s_properties.getReadBlobsSize();
            }
            if (charsToRead > len) {
                charsToRead = len;
            }
            blobData = blobResult.getBlob().getBytes(1L, charsToRead);
        }
        boolean wholeBlobRead = false;
        if (s_properties.isReadCompleteBlobs() || blobData.length < s_properties.getReadBlobsSize()) {
            wholeBlobRead = true;
        }
        return new BlobDescriptor(blobResult.getBlob(), blobData, true, wholeBlobRead, s_properties.getReadBlobsSize());
    }

    private static BlobResult getBlobRespectingUnsupportedFeatureException(ResultSet rs, int index) throws SQLException {
        try {
            return new BlobResult(rs.getBlob(index));
        }
        catch (Throwable eBlob) {
            try {
                return new BlobResult(rs.getBytes(index), eBlob);
            }
            catch (Throwable eBytes) {
                return new BlobResult(rs.getString(index), eBytes);
            }
        }
    }

    private static String handleBlobReadException(ResultSet rs, int index, Exception exceptionToHandle) throws SQLException {
        String msg = "Failed to call ResultSet.getBlob() in DataTypeBlob.staticReadResultSet(...).\nIf in case of Blob read errors you want SQuirreL to try to treat Blobs as type \"Unknown\" switch the Blob data type preferences to read all.\nSee menu File --> \"Global Preferences\" --> tab \"Data type controls\" --> section Blob.\nHint: Check out the settings of section Unknown as well.";
        if (!s_properties.isReadBlobsOnTableLoading() || !s_properties.isReadCompleteBlobs()) {
            throw new RuntimeException("Failed to call ResultSet.getBlob() in DataTypeBlob.staticReadResultSet(...).\nIf in case of Blob read errors you want SQuirreL to try to treat Blobs as type \"Unknown\" switch the Blob data type preferences to read all.\nSee menu File --> \"Global Preferences\" --> tab \"Data type controls\" --> section Blob.\nHint: Check out the settings of section Unknown as well.", exceptionToHandle);
        }
        s_log.error("Failed to call ResultSet.getBlob() in DataTypeBlob.staticReadResultSet(...).\nIf in case of Blob read errors you want SQuirreL to try to treat Blobs as type \"Unknown\" switch the Blob data type preferences to read all.\nSee menu File --> \"Global Preferences\" --> tab \"Data type controls\" --> section Blob.\nHint: Check out the settings of section Unknown as well.", exceptionToHandle);
        return DataTypeUnknown.staticReadResultSet(rs, index, s_stringMgr.getString("DataTypeBlob.readAsStringError"));
    }

    @Override
    public IWhereClausePart getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        if (value == null || value instanceof BlobDescriptor && ((BlobDescriptor)value).getData() == null) {
            return new IsNullWhereClausePart(this._colDef);
        }
        return new EmptyWhereClausePart();
    }

    @Override
    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null || value instanceof BlobDescriptor && ((BlobDescriptor)value).getData() == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            byte[] data;
            if (value instanceof BlobDescriptor) {
                BlobDescriptor bdesc = (BlobDescriptor)value;
                data = bdesc.getData();
            } else {
                data = Utilities.toPrimitiveByteArray(value);
            }
            pstmt.setBinaryStream(position, (InputStream)new ByteArrayInputStream(data), data.length);
        }
    }

    @Override
    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return null;
    }

    @Override
    public boolean canDoFileIO() {
        return true;
    }

    @Override
    public String importObject(FileInputStream inStream) throws IOException {
        int fileSize = inStream.available();
        byte[] buf = new byte[fileSize];
        int count = inStream.read(buf);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " bytes from a total file size of " + fileSize + ". Import failed.");
        }
        Byte[] bBytes = new Byte[count];
        for (int i = 0; i < count; ++i) {
            bBytes[i] = buf[i];
        }
        return BinaryDisplayConverter.convertToString(bBytes, 16, false);
    }

    @Override
    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        Byte[] bBytes = BinaryDisplayConverter.convertToBytes(text, 16, false);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(text, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException(new String(messageBuffer));
        }
        byte[] bytes = new byte[bBytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = bBytes[i];
        }
        outStream.write(bytes);
        outStream.flush();
        outStream.close();
    }

    public static OkJPanel getControlPanel() {
        s_properties.loadProperties();
        return new DataTypeBlobOkPanel(s_properties);
    }

    private class KeyTextHandler
    extends BaseKeyTextHandler {
        private KeyTextHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeBlob.this._textComponent);
            String text = _theComponent.getText();
            if (DataTypeBlob.this._isNullable) {
                if (text.equals("<null>")) {
                    if (c == '\b' || c == '\u007f') {
                        DataTypeBlob.this._textComponent.restoreText();
                        e.consume();
                    } else {
                        DataTypeBlob.this._textComponent.updateText("");
                    }
                } else if ((c == '\b' || c == '\u007f') && text.length() <= 1) {
                    DataTypeBlob.this._textComponent.updateText("<null>");
                    e.consume();
                }
            } else {
                this.handleNotNullableField(text, c, e, DataTypeBlob.this._textComponent);
            }
        }
    }
}

