/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBlobProperties;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.gui.ReadCompleteChoiceCombo;
import net.sourceforge.squirrel_sql.fw.gui.RightLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

class DataTypeBlobOkPanel
extends OkJPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataTypeBlobOkPanel.class);
    private JRadioButton _radReadBlobsOnTableLoading = new JRadioButton(s_stringMgr.getString("dataTypeBlob.readOnFirstLoad"));
    private JRadioButton _radReadBlobsOnCellVisible = new JRadioButton(s_stringMgr.getString("dataTypeBlob.readWhenRendered"));
    private JRadioButton _radReadBlobsOnCellFocused = new JRadioButton(s_stringMgr.getString("dataTypeBlob.readWhenFocused"));
    private JRadioButton _radReadBlobsNever = new JRadioButton(s_stringMgr.getString("dataTypeBlob.readNever"));
    private RightLabel _lblReadCompleteChoice = new RightLabel(s_stringMgr.getString("dataTypeBlob.read"));
    private ReadCompleteChoiceCombo _cboBlobReadCompleteChoice = new ReadCompleteChoiceCombo();
    private IntegerField _showBlobSizeField = new IntegerField(5);
    private DataTypeBlobProperties _properties;

    DataTypeBlobOkPanel(DataTypeBlobProperties properties) {
        this._properties = properties;
        this.layoutPanel();
        this._radReadBlobsOnTableLoading.setSelected(this._properties.isReadBlobsOnTableLoading());
        this._cboBlobReadCompleteChoice.setSelectedIndex(this._properties.isReadCompleteBlobs() ? 1 : 0);
        this._showBlobSizeField.setInt(this._properties.getReadBlobsSize());
        this._radReadBlobsOnCellFocused.setSelected(this._properties.isReadBlobsOnCellFocused());
        this._radReadBlobsOnCellVisible.setSelected(this._properties.isReadBlobsOnCellVisible());
        this._radReadBlobsNever.setSelected(this._properties.isReadBlobsNever());
        this._radReadBlobsOnTableLoading.addActionListener(e -> this.onUiChanged());
        this._radReadBlobsOnCellVisible.addActionListener(e -> this.onUiChanged());
        this._radReadBlobsOnCellFocused.addActionListener(e -> this.onUiChanged());
        this._radReadBlobsNever.addActionListener(e -> this.onUiChanged());
        this._cboBlobReadCompleteChoice.addActionListener(e -> this.onUiChanged());
        this.onUiChanged();
    }

    private void layoutPanel() {
        this.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("dataTypeBlob.blobType")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this._radReadBlobsOnTableLoading, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        this.add((Component)this._lblReadCompleteChoice, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        this.add((Component)this._cboBlobReadCompleteChoice, gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        this.add((Component)this._showBlobSizeField, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this._radReadBlobsOnCellVisible, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this._radReadBlobsOnCellFocused, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this._radReadBlobsNever, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._radReadBlobsOnTableLoading);
        bg.add(this._radReadBlobsOnCellVisible);
        bg.add(this._radReadBlobsOnCellFocused);
        bg.add(this._radReadBlobsNever);
    }

    private void onUiChanged() {
        this._lblReadCompleteChoice.setEnabled(this._radReadBlobsOnTableLoading.isSelected());
        this._cboBlobReadCompleteChoice.setEnabled(this._radReadBlobsOnTableLoading.isSelected());
        this._showBlobSizeField.setEnabled(this._radReadBlobsOnTableLoading.isSelected() && this._cboBlobReadCompleteChoice.getSelectedIndex() == 0);
    }

    @Override
    public void ok() {
        this._properties.setReadBlobsOnTableLoading(this._radReadBlobsOnTableLoading.isSelected());
        this._properties.setReadCompleteBlobs(this._cboBlobReadCompleteChoice.getSelectedIndex() != 0);
        this._properties.setReadBlobsSize(this._showBlobSizeField.getInt());
        this._properties.setReadBlobsOnCellFocused(this._radReadBlobsOnCellFocused.isSelected());
        this._properties.setReadBlobsOnCellVisible(this._radReadBlobsOnCellVisible.isSelected());
        this._properties.setReadBlobsNever(this._radReadBlobsNever.isSelected());
        this._properties.saveProperties();
    }
}

