/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseKeyTextHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BigDataRenderResult;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.ClobDescriptor;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeClobOkJPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeClobProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.EmptyWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IsNullWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class DataTypeClob
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataTypeClob.class);
    private boolean _isNullable;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private static DataTypeClobProperties s_properties = new DataTypeClobProperties();

    public DataTypeClob(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        s_properties.loadProperties();
    }

    public DataTypeClobProperties getProperties() {
        return s_properties;
    }

    @Override
    public String getClassName() {
        return "net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.ClobDescriptor";
    }

    @Override
    public String renderObject(Object value) {
        String text = DefaultColumnRenderer.renderObject(value);
        if (s_properties.isMakeNewlinesVisibleInCell()) {
            text = text.replaceAll("\n", "\\\\n");
        }
        return text;
    }

    @Override
    public boolean isEditableInCell(Object originalValue) {
        ClobDescriptor cdesc;
        if (this.wasWholeClobRead(originalValue) && (cdesc = (ClobDescriptor)originalValue).wasWholeClobRead()) {
            return cdesc == null || cdesc.getData() == null || cdesc.getData().indexOf(10) <= -1;
        }
        return false;
    }

    public boolean wasWholeClobRead(Object value) {
        if (value instanceof ClobDescriptor) {
            return ((ClobDescriptor)value).wasWholeClobRead();
        }
        return false;
    }

    @Override
    public boolean needToReRead(Object originalValue) {
        return false;
    }

    @Override
    public JTextField getJTextField(JTable table) {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeClob.this._textComponent, evt, DataTypeClob.this._table);
                    CellDataPopup.showDialog(DataTypeClob.this._table, DataTypeClob.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    @Override
    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        ClobDescriptor cdesc;
        if (value.equals("<null>")) {
            return null;
        }
        if (originalValue == null) {
            cdesc = new ClobDescriptor(null, value, true, true, 0);
        } else {
            cdesc = (ClobDescriptor)originalValue;
            cdesc = new ClobDescriptor(cdesc.getClob(), value, true, true, 0);
        }
        return cdesc;
    }

    @Override
    public boolean useBinaryEditingPanel() {
        return false;
    }

    @Override
    public boolean isEditableInPopup(Object originalValue) {
        return this.wasWholeClobRead(originalValue);
    }

    public boolean tryReadWholeClob(Object value) {
        if (!(value instanceof ClobDescriptor)) {
            return false;
        }
        return this._wholeClobRead((ClobDescriptor)value);
    }

    @Override
    public JTextArea getJTextArea(Object value, ColumnDisplayDefinition colDef) {
        this._textComponent = new RestorableJTextArea();
        String renderedValue = DefaultColumnRenderer.renderObject(value);
        if (renderedValue.length() > 10000) {
            renderedValue = renderedValue.substring(0, 10000);
            BigDataRenderResult.showStringLenReachedMessage(colDef);
        }
        ((RestorableJTextArea)this._textComponent).setText(renderedValue);
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    @Override
    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    private boolean _wholeClobRead(ClobDescriptor cdesc) {
        if (cdesc == null) {
            return true;
        }
        if (cdesc.wasWholeClobRead()) {
            return true;
        }
        try {
            String data = cdesc.getClob().getSubString(1L, (int)cdesc.getClob().length());
            cdesc.setClobRead(true);
            cdesc.setData(data);
            cdesc.setWholeClobRead(true);
            cdesc.setUserSetClobLimit(0);
            return true;
        }
        catch (Exception ex) {
            cdesc.setClobRead(false);
            cdesc.setWholeClobRead(false);
            cdesc.setData(null);
            return false;
        }
    }

    @Override
    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        return DataTypeClob.staticReadResultSet(rs, index);
    }

    public static Object staticReadResultSet(ResultSet rs, int index) throws SQLException {
        s_properties.loadProperties();
        Clob clob = rs.getClob(index);
        if (rs.wasNull()) {
            return null;
        }
        if (s_properties.isReadClobsOnTableLoading()) {
            int len;
            String clobData = null;
            if (clob != null && (len = (int)clob.length()) > 0) {
                int charsToRead = len;
                if (!s_properties.isReadCompleteClobs()) {
                    charsToRead = s_properties.getReadClobsSize();
                }
                if (charsToRead > len) {
                    charsToRead = len;
                }
                clobData = clob.getSubString(1L, charsToRead);
            }
            boolean wholeClobRead = false;
            if (s_properties.isReadCompleteClobs() || clobData == null || clobData.length() < s_properties.getReadClobsSize()) {
                wholeClobRead = true;
            }
            return new ClobDescriptor(clob, clobData, true, wholeClobRead, s_properties.getReadClobsSize());
        }
        return new ClobDescriptor(clob, null, false, false, 0);
    }

    @Override
    public IWhereClausePart getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        if (value == null || value instanceof ClobDescriptor && ((ClobDescriptor)value).getData() == null) {
            return new IsNullWhereClausePart(this._colDef);
        }
        return new EmptyWhereClausePart();
    }

    @Override
    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null || value instanceof ClobDescriptor && ((ClobDescriptor)value).getData() == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            String data;
            if (value instanceof ClobDescriptor) {
                ClobDescriptor cdesc = (ClobDescriptor)value;
                data = cdesc.getData();
            } else {
                data = new String(Utilities.toPrimitiveByteArray(value));
            }
            pstmt.setCharacterStream(position, (Reader)new StringReader(data), data.length());
        }
    }

    @Override
    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return null;
    }

    @Override
    public boolean canDoFileIO() {
        return true;
    }

    @Override
    public String importObject(FileInputStream inStream) throws IOException {
        InputStreamReader inReader = new InputStreamReader(inStream);
        int fileSize = inStream.available();
        char[] charBuf = new char[fileSize];
        int count = inReader.read(charBuf, 0, fileSize);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " chars from a total file size of " + fileSize + ". Import failed.");
        }
        String fileText = charBuf[count - 1] == '\n' ? new String(charBuf, 0, count - 1) : new String(charBuf);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(fileText, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException("Text does not represent data of type " + this.getClassName() + ".  Text was:\n" + fileText);
        }
        return fileText;
    }

    @Override
    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(text, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException(new String(messageBuffer));
        }
        outWriter.write(text);
        outWriter.flush();
        outWriter.close();
    }

    public static OkJPanel getControlPanel() {
        s_properties.loadProperties();
        return new DataTypeClobOkJPanel(s_properties);
    }

    @Override
    protected String quoteTextConditionValue(String value) {
        return StringUtilities.singleQuote(value);
    }

    private class KeyTextHandler
    extends BaseKeyTextHandler {
        private KeyTextHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeClob.this._textComponent);
            String text = _theComponent.getText();
            if (DataTypeClob.this._isNullable) {
                if (text.equals("<null>")) {
                    if (c == '\b' || c == '\u007f') {
                        DataTypeClob.this._textComponent.restoreText();
                        e.consume();
                    } else {
                        DataTypeClob.this._textComponent.updateText("");
                    }
                } else if ((c == '\b' || c == '\u007f') && text.length() <= 1) {
                    DataTypeClob.this._textComponent.updateText("<null>");
                    e.consume();
                }
            } else {
                this.handleNotNullableField(text, c, e, DataTypeClob.this._textComponent);
            }
        }
    }
}

