/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeClobProperties;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.gui.ReadCompleteChoiceCombo;
import net.sourceforge.squirrel_sql.fw.gui.RightLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

class DataTypeClobOkJPanel
extends OkJPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataTypeClobOkJPanel.class);
    private JRadioButton _radReadClobsOnTableLoading = new JRadioButton(s_stringMgr.getString("dataTypeClob.readOnFirstLoad"));
    private JRadioButton _radReadClobsOnCellVisible = new JRadioButton(s_stringMgr.getString("dataTypeClob.readWhenRendered"));
    private JRadioButton _radReadClobsOnCellFocused = new JRadioButton(s_stringMgr.getString("dataTypeClob.readWhenFocused"));
    private JRadioButton _radReadClobsNever = new JRadioButton(s_stringMgr.getString("dataTypeClob.readNever"));
    private RightLabel _lblReadCompleteChoice = new RightLabel(s_stringMgr.getString("dataTypeClob.read"));
    private ReadCompleteChoiceCombo _cboClobReadCompleteChoice = new ReadCompleteChoiceCombo();
    private IntegerField _showClobSizeField = new IntegerField(5);
    private JCheckBox _chkMakeNewlinesVisibleInCell = new JCheckBox(s_stringMgr.getString("dataTypeClob.newlinesAsbackslashN"));
    private DataTypeClobProperties _properties;

    public DataTypeClobOkJPanel(DataTypeClobProperties properties) {
        this.layoutPanel();
        this._properties = properties;
        this._radReadClobsOnTableLoading.setSelected(this._properties.isReadClobsOnTableLoading());
        this._cboClobReadCompleteChoice.setSelectedIndex(this._properties.isReadCompleteClobs() ? 1 : 0);
        this._showClobSizeField.setInt(this._properties.getReadClobsSize());
        this._radReadClobsOnCellFocused.setSelected(this._properties.isReadClobsOnCellFocused());
        this._radReadClobsOnCellVisible.setSelected(this._properties.isReadClobsOnCellVisible());
        this._radReadClobsNever.setSelected(this._properties.isReadClobsNever());
        this._chkMakeNewlinesVisibleInCell.setSelected(this._properties.isMakeNewlinesVisibleInCell());
        this._radReadClobsOnTableLoading.addActionListener(e -> this.onUiChanged());
        this._radReadClobsOnCellVisible.addActionListener(e -> this.onUiChanged());
        this._radReadClobsOnCellFocused.addActionListener(e -> this.onUiChanged());
        this._radReadClobsNever.addActionListener(e -> this.onUiChanged());
        this._cboClobReadCompleteChoice.addActionListener(e -> this.onUiChanged());
        this.onUiChanged();
    }

    private void layoutPanel() {
        this.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("dataTypeClob.typeClob_NClob")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this._radReadClobsOnTableLoading, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        this.add((Component)this._lblReadCompleteChoice, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        this.add((Component)this._cboClobReadCompleteChoice, gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        this.add((Component)this._showClobSizeField, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this._radReadClobsOnCellVisible, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this._radReadClobsOnCellFocused, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this._radReadClobsNever, gbc);
        gbc = new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0);
        this.add((Component)this._chkMakeNewlinesVisibleInCell, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._radReadClobsOnTableLoading);
        bg.add(this._radReadClobsOnCellVisible);
        bg.add(this._radReadClobsOnCellFocused);
        bg.add(this._radReadClobsNever);
    }

    private void onUiChanged() {
        this._lblReadCompleteChoice.setEnabled(this._radReadClobsOnTableLoading.isSelected());
        this._cboClobReadCompleteChoice.setEnabled(this._radReadClobsOnTableLoading.isSelected());
        this._showClobSizeField.setEnabled(this._radReadClobsOnTableLoading.isSelected() && this._cboClobReadCompleteChoice.getSelectedIndex() == 0);
        this._chkMakeNewlinesVisibleInCell.setEnabled(false == this._radReadClobsNever.isSelected());
    }

    @Override
    public void ok() {
        this._properties.setReadClobsOnTableLoading(this._radReadClobsOnTableLoading.isSelected());
        this._properties.setReadCompleteClobs(this._cboClobReadCompleteChoice.getSelectedIndex() != 0);
        this._properties.setReadClobsSize(this._showClobSizeField.getInt());
        this._properties.setReadClobsOnCellFocused(this._radReadClobsOnCellFocused.isSelected());
        this._properties.setReadClobsOnCellVisible(this._radReadClobsOnCellVisible.isSelected());
        this._properties.setReadClobsNever(this._radReadClobsNever.isSelected());
        this._properties.setMakeNewlinesVisibleInCell(this._chkMakeNewlinesVisibleInCell.isSelected());
        this._properties.saveProperties();
    }
}

