/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseKeyTextHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeProps;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.TemporalScriptGenerationCtrl;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.TemporalScriptGenerationFormat;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.TemporalScriptGenerationPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IsNullWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.NoParameterWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.gui.RightLabel;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.TemporalUtils;
import net.sourceforge.squirrel_sql.fw.util.ThreadSafeDateFormat;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DataTypeDate
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataTypeDate.class);
    private static final String PROP_USE_JAVA_DEFAULT_FORMAT = "useJavaDefaultFormat";
    private static final String PROP_LOCALE_FORMAT = "localeFormat";
    private static final String PROP_LENIENT = "lenient";
    private static final String PROP_READ_DATE_AS_TIMESTAMP = "readDateAsTimestamp";
    private static final String PROP_DATE_SCRIPT_FORMAT = "dateScriptFormat";
    private static ILogger s_log = LoggerController.createLogger(DataTypeDate.class);
    private boolean _isNullable;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private static final String thisClassName = "net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeDate";
    private static int DEFAULT_LOCALE_FORMAT = 3;
    private static boolean propertiesAlreadyLoaded = false;
    private static boolean useJavaDefaultFormat = true;
    private static int localeFormat = DEFAULT_LOCALE_FORMAT;
    private static boolean lenient = true;
    private static boolean readDateAsTimestamp = false;
    private static TemporalScriptGenerationFormat dateScriptFormat = TemporalScriptGenerationFormat.STD_JDBC_FORMAT;
    private static ThreadSafeDateFormat dateFormat = new ThreadSafeDateFormat(localeFormat);
    private boolean _renderExceptionHasBeenLogged;

    public DataTypeDate(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        DataTypeDate.loadProperties();
    }

    private static void loadProperties() {
        if (!propertiesAlreadyLoaded) {
            propertiesAlreadyLoaded = true;
            useJavaDefaultFormat = true;
            String useJavaDefaultFormatString = DataTypeProps.getProperty(thisClassName, PROP_USE_JAVA_DEFAULT_FORMAT);
            if (useJavaDefaultFormatString != null && useJavaDefaultFormatString.equals("false")) {
                useJavaDefaultFormat = false;
            }
            localeFormat = 3;
            String localeFormatString = DataTypeProps.getProperty(thisClassName, PROP_LOCALE_FORMAT);
            if (localeFormatString != null) {
                localeFormat = Integer.parseInt(localeFormatString);
            }
            lenient = true;
            String lenientString = DataTypeProps.getProperty(thisClassName, PROP_LENIENT);
            if (lenientString != null && lenientString.equals("false")) {
                lenient = false;
            }
            readDateAsTimestamp = false;
            String readDateAsTimestampString = DataTypeProps.getProperty(thisClassName, PROP_READ_DATE_AS_TIMESTAMP);
            if (readDateAsTimestampString != null && readDateAsTimestampString.equals("true")) {
                readDateAsTimestamp = true;
            }
            dateScriptFormat = DataTypeDate.getDateScriptFormat();
            DataTypeDate.initDateFormat(localeFormat, lenient);
        }
    }

    public static TemporalScriptGenerationFormat getDateScriptFormat() {
        TemporalScriptGenerationFormat ret = TemporalScriptGenerationFormat.STD_JDBC_FORMAT;
        String formatName = DataTypeProps.getProperty(thisClassName, PROP_DATE_SCRIPT_FORMAT);
        if (!StringUtilities.isEmpty(formatName, true)) {
            TemporalScriptGenerationFormat timestampScriptFormat;
            ret = timestampScriptFormat = TemporalScriptGenerationFormat.valueOf(formatName);
        }
        return ret;
    }

    private static void initDateFormat(int format, boolean lenient) {
        dateFormat = new ThreadSafeDateFormat(format);
        dateFormat.setLenient(lenient);
    }

    public static boolean getReadDateAsTimestamp() {
        propertiesAlreadyLoaded = false;
        DataTypeDate.loadProperties();
        return readDateAsTimestamp;
    }

    @Override
    public String getClassName() {
        return "java.sql.Date";
    }

    @Override
    public String renderObject(Object value) {
        if (useJavaDefaultFormat || value == null) {
            return DefaultColumnRenderer.renderObject(value);
        }
        try {
            return DefaultColumnRenderer.renderObject(dateFormat.format(value));
        }
        catch (Exception e) {
            if (!this._renderExceptionHasBeenLogged) {
                this._renderExceptionHasBeenLogged = true;
                s_log.error("Could not format \"" + value + "\" as date type", e);
            }
            return DefaultColumnRenderer.renderObject(value);
        }
    }

    @Override
    public boolean isEditableInCell(Object originalValue) {
        return true;
    }

    @Override
    public boolean needToReRead(Object originalValue) {
        return false;
    }

    @Override
    public JTextField getJTextField(JTable table) {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeDate.this._textComponent, evt, DataTypeDate.this._table);
                    CellDataPopup.showDialog(DataTypeDate.this._table, DataTypeDate.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    @Override
    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        if (value.equals("<null>") || value.equals("")) {
            return null;
        }
        try {
            if (useJavaDefaultFormat) {
                Date obj = Date.valueOf(value);
                return obj;
            }
            java.util.Date javaDate = dateFormat.parse(value);
            Date sqlDate = new Date(javaDate.getTime());
            return sqlDate;
        }
        catch (Exception e) {
            messageBuffer.append(e.toString() + "\n");
            return null;
        }
    }

    @Override
    public boolean useBinaryEditingPanel() {
        return false;
    }

    @Override
    public boolean isEditableInPopup(Object originalValue) {
        return true;
    }

    @Override
    public JTextArea getJTextArea(Object value, ColumnDisplayDefinition colDef) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText(this.renderObject(value));
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    @Override
    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    @Override
    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        return DataTypeDate.staticReadResultSet(rs, index, limitDataRead);
    }

    public static Object staticReadResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        DataTypeDate.loadProperties();
        Date data = null;
        data = rs.getDate(index);
        if (rs.wasNull()) {
            return null;
        }
        return data;
    }

    @Override
    public IWhereClausePart getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        boolean hasDateComponent;
        if (value == null || value.toString() == null || value.toString().length() == 0) {
            return new IsNullWhereClausePart(this._colDef);
        }
        boolean hasTimeComponent = value.toString().indexOf(":") != -1;
        boolean bl = hasDateComponent = value.toString().indexOf("-") != -1;
        if (hasTimeComponent && hasDateComponent) {
            return new NoParameterWhereClausePart(this._colDef, this._colDef.getColumnName() + " = " + TemporalUtils.format((java.util.Date)value, 93));
        }
        if (hasTimeComponent) {
            return new NoParameterWhereClausePart(this._colDef, this._colDef.getColumnName() + " = " + TemporalUtils.format((java.util.Date)value, 92));
        }
        if (DialectFactory.isOracle(md)) {
            return new NoParameterWhereClausePart(this._colDef, "trunc(" + this._colDef.getColumnName() + ") = " + TemporalUtils.format((java.util.Date)value, 91));
        }
        return new NoParameterWhereClausePart(this._colDef, this._colDef.getColumnName() + " = " + TemporalUtils.format((java.util.Date)value, 91));
    }

    @Override
    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            pstmt.setDate(position, (Date)value);
        }
    }

    @Override
    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return new Date(new java.util.Date().getTime());
    }

    @Override
    public boolean canDoFileIO() {
        return true;
    }

    @Override
    public String importObject(FileInputStream inStream) throws IOException {
        InputStreamReader inReader = new InputStreamReader(inStream);
        int fileSize = inStream.available();
        char[] charBuf = new char[fileSize];
        int count = inReader.read(charBuf, 0, fileSize);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " chars from a total file size of " + fileSize + ". Import failed.");
        }
        String fileText = charBuf[count - 1] == '\n' ? new String(charBuf, 0, count - 1) : new String(charBuf);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(fileText, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException("Text does not represent data of type " + this.getClassName() + ".  Text was:\n" + fileText);
        }
        return fileText;
    }

    @Override
    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(text, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException(new String(messageBuffer));
        }
        outWriter.write(text);
        outWriter.flush();
        outWriter.close();
    }

    public static OkJPanel getControlPanel() {
        DataTypeDate.loadProperties();
        return new DateOkJPanel();
    }

    private static class DateOkJPanel
    extends OkJPanel {
        private JCheckBox useJavaDefaultFormatChk = new JCheckBox(s_stringMgr.getString("dataTypeDate.useDefaultFormat", new Date(new java.util.Date().getTime()).toString()));
        private RightLabel dateFormatTypeDropLabel = new RightLabel(s_stringMgr.getString("dataTypeDate.orlocaleIndependent"));
        private DateFormatTypeCombo dateFormatTypeDrop = new DateFormatTypeCombo();
        private JCheckBox lenientChk = new JCheckBox(s_stringMgr.getString("dataTypeDate.allowInexact"));
        private JCheckBox readdDateAsTimestampChk = new JCheckBox(s_stringMgr.getString("dataTypeDate.readDateAsTimestamp"));
        private TemporalScriptGenerationCtrl _temporalScriptGenerationCtrl;

        public DateOkJPanel() {
            this.useJavaDefaultFormatChk.setSelected(useJavaDefaultFormat);
            this.useJavaDefaultFormatChk.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    dateFormatTypeDrop.setEnabled(!useJavaDefaultFormatChk.isSelected());
                    dateFormatTypeDropLabel.setEnabled(!useJavaDefaultFormatChk.isSelected());
                    lenientChk.setEnabled(!useJavaDefaultFormatChk.isSelected());
                }
            });
            this.dateFormatTypeDrop = new DateFormatTypeCombo();
            this.dateFormatTypeDrop.setSelectedIndex(localeFormat);
            this.lenientChk.setSelected(lenient);
            this.readdDateAsTimestampChk.setSelected(readDateAsTimestamp);
            this.dateFormatTypeDrop.setEnabled(!this.useJavaDefaultFormatChk.isSelected());
            this.dateFormatTypeDropLabel.setEnabled(!this.useJavaDefaultFormatChk.isSelected());
            this.lenientChk.setEnabled(!this.useJavaDefaultFormatChk.isSelected());
            Date currentSqlDate = new Date(new java.util.Date().getTime());
            this._temporalScriptGenerationCtrl = new TemporalScriptGenerationCtrl(TemporalUtils.getStdJDBCFormat(currentSqlDate), TemporalUtils.getStringFormat(currentSqlDate), dateScriptFormat);
            this.layoutPanel();
        }

        private void layoutPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
            JPanel formatPanel = this.createFormatPanel();
            this.add((Component)formatPanel, gbc);
            gbc = new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(3, 5, 5, 0), 0, 0);
            TemporalScriptGenerationPanel scriptGenerationCtrlPanel = this._temporalScriptGenerationCtrl.getPanel();
            this.add((Component)scriptGenerationCtrlPanel, gbc);
            GUIUtils.alignPreferredWidths(formatPanel, scriptGenerationCtrlPanel);
            this.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("dataTypeDate.typeDate")));
        }

        private JPanel createFormatPanel() {
            JPanel ret = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 3, 0, 3), 0, 0);
            ret.add((Component)this.useJavaDefaultFormatChk, gbc);
            gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0);
            ret.add((Component)this.dateFormatTypeDropLabel, gbc);
            gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 3, 0, 3), 0, 0);
            ret.add((Component)this.dateFormatTypeDrop, gbc);
            gbc = new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 20, 0, 3), 0, 0);
            ret.add((Component)this.lenientChk, gbc);
            gbc = new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 18, 0, new Insets(10, 3, 0, 3), 0, 0);
            ret.add((Component)this.readdDateAsTimestampChk, gbc);
            ret.setBorder(BorderFactory.createEtchedBorder());
            return ret;
        }

        @Override
        public void ok() {
            useJavaDefaultFormat = this.useJavaDefaultFormatChk.isSelected();
            DataTypeProps.putDataTypeProperty(DataTypeDate.thisClassName, DataTypeDate.PROP_USE_JAVA_DEFAULT_FORMAT, Boolean.valueOf(useJavaDefaultFormat).toString());
            localeFormat = this.dateFormatTypeDrop.getValue();
            dateFormat = new ThreadSafeDateFormat(localeFormat);
            DataTypeProps.putDataTypeProperty(DataTypeDate.thisClassName, DataTypeDate.PROP_LOCALE_FORMAT, Integer.toString(localeFormat));
            lenient = this.lenientChk.isSelected();
            dateFormat.setLenient(lenient);
            DataTypeProps.putDataTypeProperty(DataTypeDate.thisClassName, DataTypeDate.PROP_LENIENT, Boolean.valueOf(lenient).toString());
            readDateAsTimestamp = this.readdDateAsTimestampChk.isSelected();
            DataTypeProps.putDataTypeProperty(DataTypeDate.thisClassName, DataTypeDate.PROP_READ_DATE_AS_TIMESTAMP, Boolean.valueOf(readDateAsTimestamp).toString());
            dateScriptFormat = this._temporalScriptGenerationCtrl.getFormat();
            DataTypeProps.putDataTypeProperty(DataTypeDate.thisClassName, DataTypeDate.PROP_DATE_SCRIPT_FORMAT, dateScriptFormat.name());
            DataTypeDate.initDateFormat(localeFormat, lenient);
        }
    }

    public static class DateFormatTypeCombo
    extends JComboBox {
        public DateFormatTypeCombo() {
            this.addItem(s_stringMgr.getString("dataTypeDate.full", DateFormat.getDateInstance(0).format(new java.util.Date())));
            this.addItem(s_stringMgr.getString("dataTypeDate.long", DateFormat.getDateInstance(1).format(new java.util.Date())));
            this.addItem(s_stringMgr.getString("dataTypeDate.medium", DateFormat.getDateInstance(2).format(new java.util.Date())));
            this.addItem(s_stringMgr.getString("dataTypeDate.short", DateFormat.getDateInstance(3).format(new java.util.Date())));
        }

        @Override
        public void setSelectedIndex(int option) {
            if (option == 3) {
                super.setSelectedIndex(3);
            } else if (option == 2) {
                super.setSelectedIndex(2);
            } else if (option == 1) {
                super.setSelectedIndex(1);
            } else {
                super.setSelectedIndex(0);
            }
        }

        public int getValue() {
            if (this.getSelectedIndex() == 3) {
                return 3;
            }
            if (this.getSelectedIndex() == 2) {
                return 2;
            }
            if (this.getSelectedIndex() == 1) {
                return 1;
            }
            return 0;
        }
    }

    private class KeyTextHandler
    extends BaseKeyTextHandler {
        private KeyTextHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeDate.this._textComponent);
            Object text = _theComponent.getText();
            if (c == '\t' || c == '\n') {
                int index = ((String)text).indexOf(c);
                if (index != -1) {
                    text = index == ((String)text).length() - 1 ? ((String)text).substring(0, ((String)text).length() - 1) : ((String)text).substring(0, index) + ((String)text).substring(index + 1);
                    ((IRestorableTextComponent)((Object)_theComponent)).updateText((String)text);
                    DataTypeDate.this._beepHelper.beep(_theComponent);
                }
                e.consume();
            }
            if (DataTypeDate.this._isNullable) {
                if (((String)text).equals("<null>")) {
                    if (c == '\b' || c == '\u007f') {
                        DataTypeDate.this._textComponent.restoreText();
                        e.consume();
                    } else {
                        DataTypeDate.this._textComponent.updateText("");
                    }
                } else if ((c == '\b' || c == '\u007f') && ((String)text).length() <= 1) {
                    DataTypeDate.this._textComponent.updateText("<null>");
                    e.consume();
                }
            } else {
                this.handleNotNullableField((String)text, c, e, DataTypeDate.this._textComponent);
            }
        }
    }
}

