/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeProps;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IsNullWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.ParameterWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DataTypeOther
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private boolean _isNullable;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataTypeOther.class);
    private static final String thisClassName = "net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeOther";
    private static boolean propertiesAlreadyLoaded = false;
    private static boolean _readSQLOther = false;

    public DataTypeOther(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        DataTypeOther.loadProperties();
    }

    private static void loadProperties() {
        if (!propertiesAlreadyLoaded) {
            _readSQLOther = false;
            String readSQLOtherString = DataTypeProps.getProperty(thisClassName, "readSQLOther");
            if (readSQLOtherString != null && readSQLOtherString.equals("true")) {
                _readSQLOther = true;
            }
            propertiesAlreadyLoaded = true;
        }
    }

    @Override
    public String getClassName() {
        return "java.lang.String";
    }

    @Override
    public String renderObject(Object value) {
        return DefaultColumnRenderer.renderObject(value);
    }

    @Override
    public boolean isEditableInCell(Object originalValue) {
        return false;
    }

    @Override
    public boolean needToReRead(Object originalValue) {
        return false;
    }

    @Override
    public JTextField getJTextField(JTable table) {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeOther.this._textComponent, evt, DataTypeOther.this._table);
                    CellDataPopup.showDialog(DataTypeOther.this._table, DataTypeOther.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    @Override
    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        return null;
    }

    @Override
    public boolean useBinaryEditingPanel() {
        return false;
    }

    @Override
    public boolean isEditableInPopup(Object originalValue) {
        return false;
    }

    @Override
    public JTextArea getJTextArea(Object value, ColumnDisplayDefinition colDef) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText(this.renderObject(value));
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    @Override
    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    @Override
    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        String data = null;
        if (_readSQLOther) {
            data = rs.getString(index);
            if (rs.wasNull()) {
                data = null;
            }
        } else {
            data = s_stringMgr.getString("DataTypeOther.other");
        }
        return data;
    }

    @Override
    public IWhereClausePart getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        if (value == null || value.toString() == null) {
            return new IsNullWhereClausePart(this._colDef);
        }
        return new ParameterWhereClausePart(this._colDef, value, this);
    }

    @Override
    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            pstmt.setString(position, (String)value);
        }
    }

    @Override
    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return null;
    }

    @Override
    public boolean canDoFileIO() {
        return false;
    }

    @Override
    public String importObject(FileInputStream inStream) throws IOException {
        throw new IOException("Can not import data type OTHER");
    }

    @Override
    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        throw new IOException("Can not export data type OTHER");
    }

    public static OkJPanel getControlPanel() {
        DataTypeOther.loadProperties();
        return new SQLOtherOkJPanel();
    }

    private static class SQLOtherOkJPanel
    extends OkJPanel {
        private JCheckBox _showSQLOtherChk = new JCheckBox(s_stringMgr.getString("dataTypeOther.readContentsWhenLoaded"));

        public SQLOtherOkJPanel() {
            this._showSQLOtherChk.setSelected(_readSQLOther);
            this.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("dataTypeOther.sqlOtherType")));
            this.add(this._showSQLOtherChk);
        }

        @Override
        public void ok() {
            _readSQLOther = this._showSQLOtherChk.isSelected();
            DataTypeProps.putDataTypeProperty(DataTypeOther.thisClassName, "readSQLOther", Boolean.valueOf(_readSQLOther).toString());
        }
    }

    private class KeyTextHandler
    extends KeyAdapter {
        private KeyTextHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeOther.this._textComponent);
            e.consume();
            DataTypeOther.this._beepHelper.beep(_theComponent);
        }
    }
}

