/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.io.FileNotFoundException;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DTProperties;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;

public class DataTypePropertiesManager {
    private static ILogger s_log = LoggerController.createLogger(DataTypePropertiesManager.class);
    DTProperties _dataTypeProperties;

    public void loadDataTypeProperties() {
        try {
            XMLBeanReader doc = new XMLBeanReader();
            doc.load(new ApplicationFiles().getDTPropertiesFile());
            Iterator<Object> it = doc.iterator();
            if (it.hasNext()) {
                this._dataTypeProperties = (DTProperties)it.next();
            }
        }
        catch (FileNotFoundException ignore) {
            this._dataTypeProperties = new DTProperties();
        }
        catch (Exception ex) {
            s_log.error("Unable to load DataType Properties selections from persistent storage.", ex);
        }
    }

    public void saveDataTypeProperties() {
        try {
            XMLBeanWriter wtr = new XMLBeanWriter(this._dataTypeProperties);
            wtr.save(new ApplicationFiles().getDTPropertiesFile());
        }
        catch (Exception ex) {
            s_log.error("Unable to write DataType properties to persistent storage.", ex);
        }
    }

    public DTProperties getDataTypeProperties() {
        if (null == this._dataTypeProperties) {
            this.loadDataTypeProperties();
        }
        return this._dataTypeProperties;
    }
}

