/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.util.HashMap;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypePropertiesManager;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;

public class DataTypeProps {
    public static void putDataTypeProperty(Class<? extends IDataTypeComponent> dataTypeClass, String propertyName, String propertyValue) {
        DataTypeProps.putDataTypeProperty(dataTypeClass.getName(), propertyName, propertyValue);
    }

    public static void putDataTypeProperty(String dataTypeName, String propertyName, String propertyValue) {
        DataTypePropertiesManager dataTypePropertiesManager = Main.getApplication().getDataTypePropertiesManager();
        HashMap<String, String> buf = dataTypePropertiesManager.getDataTypeProperties().fetchDataTypes().get(dataTypeName);
        if (buf == null) {
            buf = new HashMap();
            dataTypePropertiesManager.getDataTypeProperties().fetchDataTypes().put(dataTypeName, buf);
        }
        buf.put(propertyName, propertyValue);
    }

    public static String getProperty(String dataTypeName, String propertyName) {
        DataTypePropertiesManager dataTypePropertiesManager = Main.getApplication().getDataTypePropertiesManager();
        HashMap<String, String> h = dataTypePropertiesManager.getDataTypeProperties().fetchDataTypes().get(dataTypeName);
        if (h == null) {
            return null;
        }
        return h.get(propertyName);
    }

    public static Boolean getBooleanProperty(Class<? extends IDataTypeComponent> dataTypeClass, String propertyName, Boolean defaultValueWhenNull) {
        String val = DataTypeProps.getProperty(dataTypeClass.getName(), propertyName);
        if (null == val) {
            return defaultValueWhenNull;
        }
        return "true".equals(val);
    }

    public static Integer getIntegerProperty(Class<? extends IDataTypeComponent> dataTypeClass, String propertyName, Integer defaultValueWhenNull) {
        String val = DataTypeProps.getProperty(dataTypeClass.getName(), propertyName);
        if (null == val) {
            return defaultValueWhenNull;
        }
        return Integer.parseInt(val);
    }
}

