/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseKeyTextHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeProps;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.LimitReadLengthFeatureUnstable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.EmptyWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IsNullWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.ParameterWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class DataTypeString
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataTypeString.class);
    private boolean _isNullable;
    private int _columnSize;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private static boolean propertiesAlreadyLoaded = false;
    private static boolean _makeNewlinesVisibleInCell = true;
    private static boolean _useLongInWhere = true;

    public DataTypeString(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        this._columnSize = colDef.getColumnSize();
        DataTypeString.loadProperties();
    }

    protected DataTypeString() {
    }

    private static void loadProperties() {
        if (!propertiesAlreadyLoaded) {
            _makeNewlinesVisibleInCell = true;
            String makeNewlinesVisibleString = DataTypeProps.getProperty(DataTypeString.class.getName(), "makeNewlinesVisibleInCell");
            if (makeNewlinesVisibleString != null && makeNewlinesVisibleString.equals("false")) {
                _makeNewlinesVisibleInCell = false;
            }
            _useLongInWhere = true;
            String useLongInWhereString = DataTypeProps.getProperty(DataTypeString.class.getName(), "useLongInWhere");
            if (useLongInWhereString != null && useLongInWhereString.equals("false")) {
                _useLongInWhere = false;
            }
            LimitReadLengthFeatureUnstable._limitRead = false;
            String limitReadString = DataTypeProps.getProperty(DataTypeString.class.getName(), "limitRead");
            if (limitReadString != null && limitReadString.equals("true")) {
                LimitReadLengthFeatureUnstable._limitRead = true;
            }
            LimitReadLengthFeatureUnstable._limitReadLength = 100;
            String limitReadLengthString = DataTypeProps.getProperty(DataTypeString.class.getName(), "limitReadLength");
            if (limitReadLengthString != null) {
                LimitReadLengthFeatureUnstable._limitReadLength = Integer.parseInt(limitReadLengthString);
            }
            LimitReadLengthFeatureUnstable._limitReadOnSpecificColumns = false;
            String limitReadOnSpecificColumnsString = DataTypeProps.getProperty(DataTypeString.class.getName(), "limitReadOnSpecificColumns");
            if (limitReadOnSpecificColumnsString != null && limitReadOnSpecificColumnsString.equals("true")) {
                LimitReadLengthFeatureUnstable._limitReadOnSpecificColumns = true;
            }
            LimitReadLengthFeatureUnstable._limitReadColumnNameMap.clear();
            String nameString = DataTypeProps.getProperty(DataTypeString.class.getName(), "limitReadColumnNames");
            int start = 0;
            while (nameString != null && start < nameString.length()) {
                String name;
                int end = nameString.indexOf(44, start + 1);
                if (end > -1) {
                    name = nameString.substring(start + 1, end);
                    start = end;
                } else {
                    name = nameString.substring(start + 1);
                    start = nameString.length();
                }
                LimitReadLengthFeatureUnstable._limitReadColumnNameMap.put(name, null);
            }
            propertiesAlreadyLoaded = true;
        }
    }

    @Override
    public String getClassName() {
        return "java.lang.String";
    }

    @Override
    public String renderObject(Object value) {
        String text = DefaultColumnRenderer.renderObject(value);
        if (_makeNewlinesVisibleInCell) {
            text = text.replaceAll("\n", "\\\\n");
        }
        return text;
    }

    @Override
    public boolean isEditableInCell(Object originalValue) {
        return originalValue == null || !(originalValue instanceof String) || ((String)originalValue).indexOf(10) <= -1;
    }

    @Override
    public boolean needToReRead(Object originalValue) {
        if (!LimitReadLengthFeatureUnstable._limitRead) {
            return false;
        }
        if (originalValue == null) {
            return false;
        }
        if (((String)originalValue).endsWith("...") && ((String)originalValue).length() == LimitReadLengthFeatureUnstable._limitReadLength + 3) {
            return true;
        }
        if (((String)originalValue).length() < LimitReadLengthFeatureUnstable._limitReadLength) {
            return false;
        }
        if (((String)originalValue).length() > LimitReadLengthFeatureUnstable._limitReadLength) {
            return false;
        }
        if (!LimitReadLengthFeatureUnstable._limitReadOnSpecificColumns) {
            return true;
        }
        return LimitReadLengthFeatureUnstable._limitReadColumnNameMap.containsKey(this._colDef.getColumnName());
    }

    @Override
    public JTextField getJTextField(JTable table) {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeString.this._textComponent, evt, DataTypeString.this._table);
                    CellDataPopup.showDialog(DataTypeString.this._table, DataTypeString.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    @Override
    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        if (value.equals("<null>")) {
            return null;
        }
        return value;
    }

    @Override
    public boolean useBinaryEditingPanel() {
        return false;
    }

    @Override
    public boolean isEditableInPopup(Object originalValue) {
        return !this.needToReRead(originalValue);
    }

    @Override
    public JTextArea getJTextArea(Object value, ColumnDisplayDefinition colDef) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText(DefaultColumnRenderer.renderObject(value));
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    @Override
    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    @Override
    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        Object data = rs.getString(index);
        if (rs.wasNull()) {
            return null;
        }
        if (limitDataRead && LimitReadLengthFeatureUnstable._limitRead && ((String)data).length() >= LimitReadLengthFeatureUnstable._limitReadLength && (!LimitReadLengthFeatureUnstable._limitReadOnSpecificColumns || LimitReadLengthFeatureUnstable._limitReadOnSpecificColumns && LimitReadLengthFeatureUnstable._limitReadColumnNameMap.containsKey(this._colDef.getColumnName()))) {
            data = ((String)data).substring(0, LimitReadLengthFeatureUnstable._limitReadLength) + "...";
        }
        return data;
    }

    @Override
    public IWhereClausePart getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        if (this._colDef.getSqlType() == -1 && !_useLongInWhere) {
            return null;
        }
        if (value == null || value.toString() == null) {
            return new IsNullWhereClausePart(this._colDef);
        }
        if (!this.needToReRead(value)) {
            return new ParameterWhereClausePart(this._colDef, value, this);
        }
        return new EmptyWhereClausePart();
    }

    @Override
    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            Object stringValue = value instanceof String ? (String)value : (value instanceof byte[] ? new String((byte[])value) : (value instanceof Byte[] ? new String(Utilities.toPrimitiveByteArray(value)) : (value instanceof char[] ? new String((char[])value) : (value instanceof Character[] ? new String(Utilities.toPrimitiveCharArray(value)) : "" + value))));
            pstmt.setString(position, (String)stringValue);
        }
    }

    @Override
    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return "";
    }

    @Override
    public boolean canDoFileIO() {
        return true;
    }

    @Override
    public String importObject(FileInputStream inStream) throws IOException {
        InputStreamReader inReader = new InputStreamReader(inStream);
        int fileSize = inStream.available();
        char[] charBuf = new char[fileSize];
        int count = inReader.read(charBuf, 0, fileSize);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " chars from a total file size of " + fileSize + ". Import failed.");
        }
        String fileText = charBuf[count - 1] == '\n' ? new String(charBuf, 0, count - 1) : new String(charBuf);
        if (this._columnSize > 0 && fileText.length() > this._columnSize) {
            throw new IOException("File contains " + fileText.length() + " characters which exceeds this column's limit of " + this._columnSize + ".\nImport Aborted.");
        }
        return fileText;
    }

    @Override
    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream);
        outWriter.write(text);
        outWriter.flush();
        outWriter.close();
    }

    public static OkJPanel getControlPanel() {
        DataTypeString.loadProperties();
        return new DataTypeStringPanel();
    }

    @Override
    protected String quoteTextConditionValue(String value) {
        return StringUtilities.singleQuote(value);
    }

    private static class DataTypeStringPanel
    extends OkJPanel {
        private JCheckBox _makeNewlinesVisibleInCellChk = new JCheckBox(s_stringMgr.getString("dataTypeString.newlines"));
        private JCheckBox _useLongInWhereChk = new JCheckBox(s_stringMgr.getString("dataTypeString.allowLongVarchar"));
        private JCheckBox _limitReadChk = new JCheckBox(s_stringMgr.getString("dataTypeString.limitSize"));
        private IntegerField _limitReadLengthTextField = new IntegerField(5);
        private JCheckBox _limitReadOnSpecificColumnsChk = new JCheckBox(s_stringMgr.getString("dataTypeString.limitReadOnly"));
        private JTextArea _limitReadColumnNameTextArea = new JTextArea(5, 12);

        public DataTypeStringPanel() {
            this._makeNewlinesVisibleInCellChk.setSelected(_makeNewlinesVisibleInCell);
            this._useLongInWhereChk.setSelected(_useLongInWhere);
            this._limitReadChk.setSelected(LimitReadLengthFeatureUnstable._limitRead);
            this._limitReadChk.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    _limitReadLengthTextField.setEnabled(_limitReadChk.isSelected());
                    _limitReadOnSpecificColumnsChk.setEnabled(_limitReadChk.isSelected());
                    _limitReadColumnNameTextArea.setEnabled(_limitReadChk.isSelected() && _limitReadOnSpecificColumnsChk.isSelected());
                }
            });
            this._limitReadLengthTextField.setInt(LimitReadLengthFeatureUnstable._limitReadLength);
            this._limitReadOnSpecificColumnsChk.setSelected(LimitReadLengthFeatureUnstable._limitReadOnSpecificColumns);
            this._limitReadOnSpecificColumnsChk.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    _limitReadColumnNameTextArea.setEnabled(_limitReadOnSpecificColumnsChk.isSelected());
                }
            });
            Iterator<String> names = LimitReadLengthFeatureUnstable._limitReadColumnNameMap.keySet().iterator();
            StringBuffer namesText = new StringBuffer();
            while (names.hasNext()) {
                if (namesText.length() > 0) {
                    namesText.append("\n" + names.next());
                    continue;
                }
                namesText.append(names.next());
            }
            this._limitReadColumnNameTextArea.setText(namesText.toString());
            this._limitReadLengthTextField.setEnabled(this._limitReadChk.isSelected());
            this._limitReadOnSpecificColumnsChk.setEnabled(this._limitReadChk.isSelected());
            this._limitReadColumnNameTextArea.setEnabled(this._limitReadChk.isSelected() && this._limitReadOnSpecificColumnsChk.isSelected());
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("dataTypeString.typeChar")));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 0;
            this.add((Component)this._makeNewlinesVisibleInCellChk, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 0;
            this.add((Component)this._useLongInWhereChk, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 0;
            JPanel limitReadPanelWithUnstableWarning = this.createLimitReadPanelWithUnstableWarning();
            this.add((Component)limitReadPanelWithUnstableWarning, gbc);
        }

        private JPanel createLimitReadPanelWithUnstableWarning() {
            JPanel ret = new JPanel(new GridBagLayout());
            ret.setBorder(BorderFactory.createEtchedBorder());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0);
            gbc.gridwidth = 3;
            gbc.fill = 2;
            MultipleLineLabel lbl = new MultipleLineLabel(LimitReadLengthFeatureUnstable.getUnstableWarningForGUI());
            lbl.setForeground(Color.red);
            ret.add((Component)lbl, gbc);
            gbc.fill = 0;
            ++gbc.gridy;
            gbc.gridwidth = 1;
            ret.add((Component)this._limitReadChk, gbc);
            ++gbc.gridx;
            gbc.gridwidth = 1;
            ret.add((Component)this._limitReadLengthTextField, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 1;
            ret.add((Component)this._limitReadOnSpecificColumnsChk, gbc);
            ++gbc.gridx;
            gbc.gridwidth = 0;
            gbc.insets.bottom = 5;
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setHorizontalScrollBarPolicy(32);
            scrollPane.setVerticalScrollBarPolicy(22);
            scrollPane.setViewportView(this._limitReadColumnNameTextArea);
            ret.add((Component)scrollPane, gbc);
            return ret;
        }

        @Override
        public void ok() {
            _makeNewlinesVisibleInCell = this._makeNewlinesVisibleInCellChk.isSelected();
            DataTypeProps.putDataTypeProperty(DataTypeString.class.getName(), "makeNewlinesVisibleInCell", Boolean.valueOf(_makeNewlinesVisibleInCell).toString());
            _useLongInWhere = this._useLongInWhereChk.isSelected();
            DataTypeProps.putDataTypeProperty(DataTypeString.class.getName(), "useLongInWhere", Boolean.valueOf(_useLongInWhere).toString());
            LimitReadLengthFeatureUnstable._limitRead = this._limitReadChk.isSelected();
            DataTypeProps.putDataTypeProperty(DataTypeString.class.getName(), "limitRead", Boolean.valueOf(LimitReadLengthFeatureUnstable._limitRead).toString());
            LimitReadLengthFeatureUnstable._limitReadLength = this._limitReadLengthTextField.getInt();
            DataTypeProps.putDataTypeProperty(DataTypeString.class.getName(), "limitReadLength", Integer.toString(LimitReadLengthFeatureUnstable._limitReadLength));
            LimitReadLengthFeatureUnstable._limitReadOnSpecificColumns = this._limitReadOnSpecificColumnsChk.isSelected();
            DataTypeProps.putDataTypeProperty(DataTypeString.class.getName(), "limitReadOnSpecificColumns", Boolean.valueOf(LimitReadLengthFeatureUnstable._limitReadOnSpecificColumns).toString());
            LimitReadLengthFeatureUnstable._limitReadColumnNameMap.clear();
            String columnNameText = this._limitReadColumnNameTextArea.getText();
            int start = 0;
            Object propertyString = "";
            while (start < columnNameText.length()) {
                String name;
                int end = columnNameText.indexOf(10, start + 1);
                if (end > -1) {
                    name = columnNameText.substring(start, end);
                    start = end;
                } else {
                    name = columnNameText.substring(start);
                    start = columnNameText.length();
                }
                name = name.trim().toUpperCase();
                if (name.length() == 0) continue;
                LimitReadLengthFeatureUnstable._limitReadColumnNameMap.put(name.trim().toUpperCase(), null);
                propertyString = (String)propertyString + "," + name.trim().toUpperCase();
            }
            DataTypeProps.putDataTypeProperty(DataTypeString.class.getName(), "limitReadColumnNames", (String)propertyString);
        }
    }

    private class KeyTextHandler
    extends BaseKeyTextHandler {
        private KeyTextHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeString.this._textComponent);
            String text = _theComponent.getText();
            if (DataTypeString.this._columnSize > 0 && text.length() >= DataTypeString.this._columnSize && c != '\b' && c != '\u007f') {
                e.consume();
                DataTypeString.this._beepHelper.beep(_theComponent);
            }
            if (DataTypeString.this._isNullable) {
                if (text.equals("<null>")) {
                    if (c == '\b' || c == '\u007f') {
                        DataTypeString.this._textComponent.restoreText();
                        e.consume();
                    } else {
                        DataTypeString.this._textComponent.updateText("");
                    }
                } else if ((c == '\b' || c == '\u007f') && text.length() == 0) {
                    DataTypeString.this._textComponent.updateText("<null>");
                    e.consume();
                }
            } else {
                this.handleNotNullableField(text, c, e, DataTypeString.this._textComponent);
            }
        }
    }
}

