/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseKeyTextHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeProps;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.TemporalScriptGenerationCtrl;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.TemporalScriptGenerationFormat;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.TemporalScriptGenerationPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IsNullWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.NoParameterWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.gui.RightLabel;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.TemporalUtils;
import net.sourceforge.squirrel_sql.fw.util.ThreadSafeDateFormat;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DataTypeTime
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private static final String PROP_LENIENT = "lenient";
    private static final String PROP_LOCALE_FORMAT = "localeFormat";
    private static final String PROP_USE_JAVA_DEFAULT_FORMAT = "useJavaDefaultFormat";
    private static final String PROP_TIME_SCRIPT_FORMAT = "timeScriptFormat";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataTypeTime.class);
    private static ILogger s_log = LoggerController.createLogger(DataTypeTime.class);
    private boolean _isNullable;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private static final String thisClassName = "net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeTime";
    private static int DEFAULT_LOCALE_FORMAT = 3;
    private static boolean propertiesAlreadyLoaded = false;
    private static boolean useJavaDefaultFormat = true;
    private static int localeFormat = DEFAULT_LOCALE_FORMAT;
    private static boolean lenient = true;
    private static TemporalScriptGenerationFormat timeScriptFormat;
    private static ThreadSafeDateFormat dateFormat;
    private boolean _renderExceptionHasBeenLogged;

    public DataTypeTime(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        DataTypeTime.loadProperties();
    }

    private static void loadProperties() {
        if (!propertiesAlreadyLoaded) {
            useJavaDefaultFormat = true;
            String useJavaDefaultFormatString = DataTypeProps.getProperty(thisClassName, PROP_USE_JAVA_DEFAULT_FORMAT);
            if (useJavaDefaultFormatString != null && useJavaDefaultFormatString.equals("false")) {
                useJavaDefaultFormat = false;
            }
            localeFormat = 3;
            String localeFormatString = DataTypeProps.getProperty(thisClassName, PROP_LOCALE_FORMAT);
            if (localeFormatString != null) {
                localeFormat = Integer.parseInt(localeFormatString);
            }
            lenient = true;
            String lenientString = DataTypeProps.getProperty(thisClassName, PROP_LENIENT);
            if (lenientString != null && lenientString.equals("false")) {
                lenient = false;
            }
            timeScriptFormat = DataTypeTime.getTimeScriptFormat();
            DataTypeTime.initDateFormat(localeFormat, lenient);
        }
    }

    private static void initDateFormat(int format, boolean lenient) {
        dateFormat = new ThreadSafeDateFormat(format, true);
        dateFormat.setLenient(lenient);
    }

    public static TemporalScriptGenerationFormat getTimeScriptFormat() {
        TemporalScriptGenerationFormat ret = TemporalScriptGenerationFormat.STD_JDBC_FORMAT;
        String formatName = DataTypeProps.getProperty(thisClassName, PROP_TIME_SCRIPT_FORMAT);
        if (!StringUtilities.isEmpty(formatName, true)) {
            TemporalScriptGenerationFormat timestampScriptFormat;
            ret = timestampScriptFormat = TemporalScriptGenerationFormat.valueOf(formatName);
        }
        return ret;
    }

    @Override
    public String getClassName() {
        return "java.sql.Time";
    }

    @Override
    public String renderObject(Object value) {
        if (useJavaDefaultFormat || value == null) {
            return DefaultColumnRenderer.renderObject(value);
        }
        try {
            return DefaultColumnRenderer.renderObject(dateFormat.format(value));
        }
        catch (Exception e) {
            if (!this._renderExceptionHasBeenLogged) {
                this._renderExceptionHasBeenLogged = true;
                s_log.error("Could not format \"" + value + "\" as date type", e);
            }
            return DefaultColumnRenderer.renderObject(value);
        }
    }

    @Override
    public boolean isEditableInCell(Object originalValue) {
        return true;
    }

    @Override
    public boolean needToReRead(Object originalValue) {
        return false;
    }

    @Override
    public JTextField getJTextField(JTable table) {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeTime.this._textComponent, evt, DataTypeTime.this._table);
                    CellDataPopup.showDialog(DataTypeTime.this._table, DataTypeTime.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    @Override
    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        if (((String)value).equals("<null>") || ((String)value).equals("")) {
            return null;
        }
        try {
            if (useJavaDefaultFormat) {
                int firstColon = ((String)value).indexOf(":");
                if (firstColon == -1) {
                    value = (String)value + ":0:0";
                } else if (((String)value).indexOf(":", firstColon + 1) == -1) {
                    value = (String)value + ":0";
                }
                Time obj = Time.valueOf((String)value);
                return obj;
            }
            Date javaDate = dateFormat.parse((String)value);
            return new Time(javaDate.getTime());
        }
        catch (Exception e) {
            messageBuffer.append(e.toString() + "\n");
            return null;
        }
    }

    @Override
    public boolean useBinaryEditingPanel() {
        return false;
    }

    @Override
    public boolean isEditableInPopup(Object originalValue) {
        return true;
    }

    @Override
    public JTextArea getJTextArea(Object value, ColumnDisplayDefinition colDef) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText(this.renderObject(value));
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    @Override
    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    @Override
    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        Time data = rs.getTime(index);
        if (rs.wasNull()) {
            return null;
        }
        return data;
    }

    @Override
    public IWhereClausePart getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        if (value == null || value.toString() == null || value.toString().length() == 0) {
            return new IsNullWhereClausePart(this._colDef);
        }
        return new NoParameterWhereClausePart(this._colDef, this._colDef.getColumnName() + " = " + TemporalUtils.format((Date)value, 92, null));
    }

    @Override
    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            pstmt.setTime(position, (Time)value);
        }
    }

    @Override
    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return new Time(new Date().getTime());
    }

    @Override
    public boolean canDoFileIO() {
        return true;
    }

    @Override
    public String importObject(FileInputStream inStream) throws IOException {
        InputStreamReader inReader = new InputStreamReader(inStream);
        int fileSize = inStream.available();
        char[] charBuf = new char[fileSize];
        int count = inReader.read(charBuf, 0, fileSize);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " chars from a total file size of " + fileSize + ". Import failed.");
        }
        String fileText = charBuf[count - 1] == '\n' ? new String(charBuf, 0, count - 1) : new String(charBuf);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(fileText, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException("Text does not represent data of type " + this.getClassName() + ".  Text was:\n" + fileText);
        }
        return fileText;
    }

    @Override
    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(text, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException(new String(messageBuffer));
        }
        outWriter.write(text);
        outWriter.flush();
        outWriter.close();
    }

    public static OkJPanel getControlPanel() {
        DataTypeTime.loadProperties();
        return new TimeOkJPanel();
    }

    static {
        dateFormat = new ThreadSafeDateFormat(localeFormat, true);
    }

    private static class TimeOkJPanel
    extends OkJPanel {
        private JCheckBox useJavaDefaultFormatChk = new JCheckBox(s_stringMgr.getString("dataTypeTime.useDefaultFormat", new Time(new Date().getTime()).toString()));
        private RightLabel timeFormatTypeDropLabel = new RightLabel(s_stringMgr.getString("dataTypeTime.useDefaultFormat2"));
        private DateFormatTypeCombo timeFormatTypeDrop = new DateFormatTypeCombo();
        private JCheckBox lenientChk = new JCheckBox(s_stringMgr.getString("dataTypeTime.inexact"));
        private TemporalScriptGenerationCtrl _temporalScriptGenerationCtrl;

        public TimeOkJPanel() {
            this.useJavaDefaultFormatChk.setSelected(useJavaDefaultFormat);
            this.useJavaDefaultFormatChk.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    timeFormatTypeDrop.setEnabled(!useJavaDefaultFormatChk.isSelected());
                    timeFormatTypeDropLabel.setEnabled(!useJavaDefaultFormatChk.isSelected());
                    lenientChk.setEnabled(!useJavaDefaultFormatChk.isSelected());
                }
            });
            this.timeFormatTypeDrop = new DateFormatTypeCombo();
            this.timeFormatTypeDrop.setSelectedIndex(localeFormat);
            this.lenientChk.setSelected(lenient);
            this.timeFormatTypeDrop.setEnabled(!this.useJavaDefaultFormatChk.isSelected());
            this.timeFormatTypeDropLabel.setEnabled(!this.useJavaDefaultFormatChk.isSelected());
            this.lenientChk.setEnabled(!this.useJavaDefaultFormatChk.isSelected());
            Time currentSqlTime = new Time(new Date().getTime());
            this._temporalScriptGenerationCtrl = new TemporalScriptGenerationCtrl(TemporalUtils.getStdJDBCFormat(currentSqlTime), TemporalUtils.getStringFormat(currentSqlTime), timeScriptFormat);
            this.layoutPanel();
        }

        private void layoutPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
            JPanel formatPanel = this.createFormatPanel();
            this.add((Component)formatPanel, gbc);
            gbc = new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(3, 5, 5, 0), 0, 0);
            TemporalScriptGenerationPanel scriptPanel = this._temporalScriptGenerationCtrl.getPanel();
            this.add((Component)scriptPanel, gbc);
            GUIUtils.alignPreferredWidths(formatPanel, scriptPanel);
            this.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("dataTypeTime.typeTime")));
        }

        private JPanel createFormatPanel() {
            JPanel ret = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 3, 0, 3), 0, 0);
            ret.add((Component)this.useJavaDefaultFormatChk, gbc);
            gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0);
            ret.add((Component)this.timeFormatTypeDropLabel, gbc);
            gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 3, 0, 3), 0, 0);
            ret.add((Component)this.timeFormatTypeDrop, gbc);
            gbc = new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 20, 0, 3), 0, 0);
            ret.add((Component)this.lenientChk, gbc);
            ret.setBorder(BorderFactory.createEtchedBorder());
            return ret;
        }

        @Override
        public void ok() {
            useJavaDefaultFormat = this.useJavaDefaultFormatChk.isSelected();
            DataTypeProps.putDataTypeProperty(DataTypeTime.thisClassName, DataTypeTime.PROP_USE_JAVA_DEFAULT_FORMAT, Boolean.valueOf(useJavaDefaultFormat).toString());
            localeFormat = this.timeFormatTypeDrop.getValue();
            dateFormat = new ThreadSafeDateFormat(localeFormat, true);
            DataTypeProps.putDataTypeProperty(DataTypeTime.thisClassName, DataTypeTime.PROP_LOCALE_FORMAT, Integer.toString(localeFormat));
            lenient = this.lenientChk.isSelected();
            dateFormat.setLenient(lenient);
            DataTypeProps.putDataTypeProperty(DataTypeTime.thisClassName, DataTypeTime.PROP_LENIENT, Boolean.valueOf(lenient).toString());
            timeScriptFormat = this._temporalScriptGenerationCtrl.getFormat();
            DataTypeProps.putDataTypeProperty(DataTypeTime.thisClassName, DataTypeTime.PROP_TIME_SCRIPT_FORMAT, timeScriptFormat.name());
            DataTypeTime.initDateFormat(localeFormat, lenient);
        }
    }

    public static class DateFormatTypeCombo
    extends JComboBox {
        public DateFormatTypeCombo() {
            this.addItem(s_stringMgr.getString("dataTypeTime.full", DateFormat.getTimeInstance(0).format(new Date())));
            this.addItem(s_stringMgr.getString("dataTypeTime.long", DateFormat.getTimeInstance(1).format(new Date())));
            this.addItem(s_stringMgr.getString("dataTypeTime.medium", DateFormat.getTimeInstance(2).format(new Date())));
            this.addItem(s_stringMgr.getString("dataTypeTime.short", DateFormat.getTimeInstance(3).format(new Date())));
        }

        @Override
        public void setSelectedIndex(int option) {
            if (option == 3) {
                super.setSelectedIndex(3);
            } else if (option == 2) {
                super.setSelectedIndex(2);
            } else if (option == 1) {
                super.setSelectedIndex(1);
            } else {
                super.setSelectedIndex(0);
            }
        }

        public int getValue() {
            if (this.getSelectedIndex() == 3) {
                return 3;
            }
            if (this.getSelectedIndex() == 2) {
                return 2;
            }
            if (this.getSelectedIndex() == 1) {
                return 1;
            }
            return 0;
        }
    }

    private class KeyTextHandler
    extends BaseKeyTextHandler {
        private KeyTextHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeTime.this._textComponent);
            Object text = _theComponent.getText();
            if (c == '\t' || c == '\n') {
                int index = ((String)text).indexOf(c);
                text = index == ((String)text).length() - 1 ? ((String)text).substring(0, ((String)text).length() - 1) : ((String)text).substring(0, index) + ((String)text).substring(index + 1);
                ((IRestorableTextComponent)((Object)_theComponent)).updateText((String)text);
                DataTypeTime.this._beepHelper.beep(_theComponent);
                e.consume();
            }
            if (DataTypeTime.this._isNullable) {
                if (((String)text).equals("<null>")) {
                    if (c == '\b' || c == '\u007f') {
                        DataTypeTime.this._textComponent.restoreText();
                        e.consume();
                    } else {
                        DataTypeTime.this._textComponent.updateText("");
                    }
                } else if ((c == '\b' || c == '\u007f') && ((String)text).length() <= 1) {
                    DataTypeTime.this._textComponent.updateText("<null>");
                    e.consume();
                }
            } else {
                this.handleNotNullableField((String)text, c, e, DataTypeTime.this._textComponent);
            }
        }
    }
}

