/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseKeyTextHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeProps;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeTimestampStatics;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.TemporalScriptGenerationFormat;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.TimestampOkPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.EmptyWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IsNullWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.NoParameterWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.ParameterWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.TemporalUtils;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DataTypeTimestamp
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataTypeTimestamp.class);
    private static ILogger s_log = LoggerController.createLogger(DataTypeTimestamp.class);
    private boolean _isNullable;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    public static final String WHERE_CLAUSE_USAGE_KEY = "whereClauseUsage";
    private static DataTypeTimestampStatics _dataTypeTimestampStatics = new DataTypeTimestampStatics();
    private boolean _renderExceptionHasBeenLogged;

    public DataTypeTimestamp(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        DataTypeTimestamp.loadProperties();
    }

    private static void loadProperties() {
        _dataTypeTimestampStatics.setUseJavaDefaultFormat(true);
        String useJavaDefaultFormatString = DataTypeProps.getProperty(DataTypeTimestamp.class.getName(), "useJavaDefaultFormat");
        if (useJavaDefaultFormatString != null && useJavaDefaultFormatString.equals("false")) {
            _dataTypeTimestampStatics.setUseJavaDefaultFormat(false);
        }
        _dataTypeTimestampStatics.setUseThreeDigitMillis(false);
        String useThreeDigitMillisString = DataTypeProps.getProperty(DataTypeTimestamp.class.getName(), "useThreeDigitMillis");
        if (useThreeDigitMillisString != null && useThreeDigitMillisString.equals("true")) {
            _dataTypeTimestampStatics.setUseThreeDigitMillis(true);
        }
        _dataTypeTimestampStatics.setLocaleFormat(3);
        String localeFormatString = DataTypeProps.getProperty(DataTypeTimestamp.class.getName(), "localeFormat");
        if (localeFormatString != null) {
            _dataTypeTimestampStatics.setLocaleFormat(Integer.parseInt(localeFormatString));
        }
        _dataTypeTimestampStatics.setLenient(true);
        String lenientString = DataTypeProps.getProperty(DataTypeTimestamp.class.getName(), "lenient");
        if (lenientString != null && lenientString.equals("false")) {
            _dataTypeTimestampStatics.setLenient(false);
        }
        _dataTypeTimestampStatics.setInternalWhereClauseUsage(1);
        String whereClauseUsageString = DataTypeProps.getProperty(DataTypeTimestamp.class.getName(), WHERE_CLAUSE_USAGE_KEY);
        if (whereClauseUsageString != null) {
            _dataTypeTimestampStatics.setInternalWhereClauseUsage(Integer.parseInt(whereClauseUsageString));
        }
        _dataTypeTimestampStatics.setTimestampScriptFormat(DataTypeTimestamp.getTimeStampScriptFormat());
        _dataTypeTimestampStatics.initDateFormat();
    }

    public static TemporalScriptGenerationFormat getTimeStampScriptFormat() {
        TemporalScriptGenerationFormat ret = TemporalScriptGenerationFormat.STD_JDBC_FORMAT;
        String formatName = DataTypeProps.getProperty(DataTypeTimestamp.class.getName(), "timestampScriptFormat");
        if (!StringUtilities.isEmpty(formatName, true)) {
            TemporalScriptGenerationFormat timestampScriptFormat;
            ret = timestampScriptFormat = TemporalScriptGenerationFormat.valueOf(formatName);
        }
        return ret;
    }

    @Override
    public String getClassName() {
        return "java.sql.Timestamp";
    }

    @Override
    public String renderObject(Object value) {
        if (value == null || null == _dataTypeTimestampStatics.getDateFormat()) {
            return DefaultColumnRenderer.renderObject(value);
        }
        try {
            return DefaultColumnRenderer.renderObject(_dataTypeTimestampStatics.getDateFormat().format(value));
        }
        catch (Exception e) {
            if (!this._renderExceptionHasBeenLogged) {
                this._renderExceptionHasBeenLogged = true;
                s_log.error("Could not format \"" + value + "\" as date type", e);
            }
            return DefaultColumnRenderer.renderObject(value);
        }
    }

    @Override
    public boolean isEditableInCell(Object originalValue) {
        return true;
    }

    @Override
    public boolean needToReRead(Object originalValue) {
        return false;
    }

    @Override
    public JTextField getJTextField(JTable table) {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeTimestamp.this._textComponent, evt, DataTypeTimestamp.this._table);
                    CellDataPopup.showDialog(DataTypeTimestamp.this._table, DataTypeTimestamp.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    @Override
    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        if (value.equals("<null>") || value.equals("")) {
            return null;
        }
        try {
            if (_dataTypeTimestampStatics.isUseJavaDefaultFormat()) {
                Timestamp obj = Timestamp.valueOf(value);
                return obj;
            }
            Date javaDate = _dataTypeTimestampStatics.getDateFormat().parse(value);
            return new Timestamp(javaDate.getTime());
        }
        catch (Exception e) {
            messageBuffer.append(e.toString() + "\n");
            return null;
        }
    }

    @Override
    public boolean useBinaryEditingPanel() {
        return false;
    }

    @Override
    public boolean isEditableInPopup(Object originalValue) {
        return true;
    }

    @Override
    public JTextArea getJTextArea(Object value, ColumnDisplayDefinition colDef) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText(this.renderObject(value));
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    @Override
    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    @Override
    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        Timestamp data = rs.getTimestamp(index);
        if (rs.wasNull()) {
            return null;
        }
        return data;
    }

    @Override
    public IWhereClausePart getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        if (_dataTypeTimestampStatics.getInternalWhereClauseUsage() == 0) {
            return new EmptyWhereClausePart();
        }
        if (value == null || value.toString() == null || value.toString().length() == 0) {
            return new IsNullWhereClausePart(this._colDef);
        }
        if (_dataTypeTimestampStatics.getInternalWhereClauseUsage() == 1) {
            return new NoParameterWhereClausePart(this._colDef, this._colDef.getColumnName() + " = " + TemporalUtils.getStdJDBCFormat((Date)value, 93));
        }
        return new ParameterWhereClausePart(this._colDef, value, this);
    }

    @Override
    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            pstmt.setTimestamp(position, (Timestamp)value);
        }
    }

    @Override
    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return new Timestamp(new Date().getTime());
    }

    @Override
    public boolean canDoFileIO() {
        return true;
    }

    @Override
    public String importObject(FileInputStream inStream) throws IOException {
        InputStreamReader inReader = new InputStreamReader(inStream);
        int fileSize = inStream.available();
        char[] charBuf = new char[fileSize];
        int count = inReader.read(charBuf, 0, fileSize);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " chars from a total file size of " + fileSize + ". Import failed.");
        }
        String fileText = charBuf[count - 1] == '\n' ? new String(charBuf, 0, count - 1) : new String(charBuf);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(fileText, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException("Text does not represent data of type " + this.getClassName() + ".  Text was:\n" + fileText);
        }
        return fileText;
    }

    @Override
    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(text, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException(new String(messageBuffer));
        }
        outWriter.write(text);
        outWriter.flush();
        outWriter.close();
    }

    public static OkJPanel getControlPanel() {
        DataTypeTimestamp.loadProperties();
        return new TimestampOkPanel(_dataTypeTimestampStatics);
    }

    private class KeyTextHandler
    extends BaseKeyTextHandler {
        private KeyTextHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeTimestamp.this._textComponent);
            Object text = _theComponent.getText();
            if (c == '\t' || c == '\n') {
                int index = ((String)text).indexOf(c);
                if (index != -1) {
                    text = index == ((String)text).length() - 1 ? ((String)text).substring(0, ((String)text).length() - 1) : ((String)text).substring(0, index) + ((String)text).substring(index + 1);
                    ((IRestorableTextComponent)((Object)_theComponent)).updateText((String)text);
                    DataTypeTimestamp.this._beepHelper.beep(_theComponent);
                }
                e.consume();
            }
            if (DataTypeTimestamp.this._isNullable) {
                if (((String)text).equals("<null>")) {
                    if (c == '\b' || c == '\u007f') {
                        DataTypeTimestamp.this._textComponent.restoreText();
                        e.consume();
                    } else {
                        DataTypeTimestamp.this._textComponent.updateText("");
                    }
                } else if ((c == '\b' || c == '\u007f') && ((String)text).length() <= 1) {
                    DataTypeTimestamp.this._textComponent.updateText("<null>");
                    e.consume();
                }
            } else {
                this.handleNotNullableField((String)text, c, e, DataTypeTimestamp.this._textComponent);
            }
        }
    }
}

