/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.text.NumberFormat;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.FloatingPointBaseDTProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.FloatingPointPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.UserDefinedDecimalFormatFactory;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;

public abstract class FloatingPointBase
extends BaseDataTypeComponent {
    public static OkJPanel getControlPanel() {
        FloatingPointBaseDTProperties.loadProperties();
        return new FloatingPointPanel();
    }

    public FloatingPointBase() {
        FloatingPointBaseDTProperties.loadProperties();
    }

    protected NumberFormat createNumberFormat() {
        if (FloatingPointBaseDTProperties.isUseLocaleFormat()) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMinimumFractionDigits(FloatingPointBaseDTProperties.getMinimumFractionDigits());
            numberFormat.setMaximumFractionDigits(FloatingPointBaseDTProperties.getMaximumFractionDigits());
            return numberFormat;
        }
        if (FloatingPointBaseDTProperties.isUseUserDefinedFormat()) {
            String userDefinedDecimalSeparator = FloatingPointBaseDTProperties.getUserDefinedDecimalSeparator();
            String groupingSeparator = FloatingPointBaseDTProperties.getUserDefinedGroupingSeparator();
            int userDefinedMinimumFractionDigits = FloatingPointBaseDTProperties.getUserDefinedMinimumFractionDigits();
            int userDefinedMaximumFractionDigits = FloatingPointBaseDTProperties.getUserDefinedMaximumFractionDigits();
            NumberFormat numberFormat = UserDefinedDecimalFormatFactory.createUserDefinedFormat(userDefinedDecimalSeparator, groupingSeparator, userDefinedMinimumFractionDigits, userDefinedMaximumFractionDigits);
            return numberFormat;
        }
        if (FloatingPointBaseDTProperties.isUseJavaDefaultFormat()) {
            return NumberFormat.getInstance();
        }
        throw new IllegalStateException("Unknown Format");
    }
}

