/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBigDecimal;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeProps;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class FloatingPointBaseDTProperties {
    public static final String KEY_USE_LOCALE_FORMAT = "useLocaleFormat";
    public static final String KEY_USE_USER_DEFINED_FORMAT = "useUserDefinedFormat";
    public static final String KEY_USE_JAVA_DEFAULT_FORMAT = "useJavaDefaultFormat";
    public static final String KEY_MINIMUM_FRACTION_DIGITS = "minimumFractionDigits";
    public static final String KEY_MAXIMUM_FRACTION_DIGITS = "maximumFractionDigits";
    public static final String KEY_USER_DEFINDED_MAXIMUM_FRACTION_DIGITS = "userDefindedMaximumFractionDigits";
    public static final String KEY_USER_DEFINDED_MINIMUM_FRACTION_DIGITS = "userDefindedMinimumFractionDigits";
    public static final String KEY_USER_DEFINED_DECIMAL_SEPARATOR = "userDefinedDecimalSeparator";
    public static final String KEY_USER_DEFINED_GROUPING_SEPARATOR = "userDefinedGroupingSeparator";
    private static final int DEFAULT_MINIMUM_FRACTION_DIGITS = 0;
    private static final int DEFAULT_MAXIMUM_FRACTION_DIGITS = 5;
    private static int _minimumFractionDigits;
    private static int _maximumFractionDigits;
    private static boolean _useLocaleFormat;
    private static boolean _useUserDefinedFormat;
    private static boolean _useJavaDefaultFormat;
    private static int _userDefinedMinimumFractionDigits;
    private static int _userDefinedMaximumFractionDigits;
    private static String _userDefinedGroupingSeparator;
    private static String _userDefinedDecimalSeparator;
    private static boolean propertiesAlreadyLoaded;

    public static boolean isUseLocaleFormat() {
        return _useLocaleFormat;
    }

    public static boolean isUseJavaDefaultFormat() {
        return _useJavaDefaultFormat;
    }

    public static boolean isUseUserDefinedFormat() {
        return _useUserDefinedFormat;
    }

    public static int getMinimumFractionDigits() {
        return _minimumFractionDigits;
    }

    public static int getMaximumFractionDigits() {
        return _maximumFractionDigits;
    }

    public static int getUserDefinedMinimumFractionDigits() {
        return _userDefinedMinimumFractionDigits;
    }

    public static int getUserDefinedMaximumFractionDigits() {
        return _userDefinedMaximumFractionDigits;
    }

    public static String getUserDefinedGroupingSeparator() {
        return _userDefinedGroupingSeparator;
    }

    public static String getUserDefinedDecimalSeparator() {
        return _userDefinedDecimalSeparator;
    }

    private static Integer toInteger(String key, int defaultValue) {
        String value = DataTypeProps.getProperty(DataTypeBigDecimal.class.getName(), key);
        if (null == value) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    private static boolean toBoolean(String key, boolean defaultValue) {
        String value = DataTypeProps.getProperty(DataTypeBigDecimal.class.getName(), key);
        if (null == value) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    private static String _toString(String key, String defaultValue) {
        String value = DataTypeProps.getProperty(DataTypeBigDecimal.class.getName(), key);
        if (StringUtilities.isEmpty(value, true)) {
            return defaultValue;
        }
        return value;
    }

    public static void setUseJavaDefaultFormat(boolean useJavaDefaultFormat) {
        DataTypeProps.putDataTypeProperty(DataTypeBigDecimal.class.getName(), KEY_USE_JAVA_DEFAULT_FORMAT, Boolean.valueOf(useJavaDefaultFormat).toString());
        _useJavaDefaultFormat = useJavaDefaultFormat;
    }

    public static void setUseLocaleFormat(boolean useLocaleFormat) {
        DataTypeProps.putDataTypeProperty(DataTypeBigDecimal.class.getName(), KEY_USE_LOCALE_FORMAT, Boolean.valueOf(useLocaleFormat).toString());
        _useLocaleFormat = useLocaleFormat;
    }

    public static void setUseUserDefinedFormat(boolean useUserDefinedFormat) {
        DataTypeProps.putDataTypeProperty(DataTypeBigDecimal.class.getName(), KEY_USE_USER_DEFINED_FORMAT, Boolean.valueOf(useUserDefinedFormat).toString());
        _useUserDefinedFormat = useUserDefinedFormat;
    }

    public static void setMinimumFractionDigits(int minimumFractionDigits) {
        DataTypeProps.putDataTypeProperty(DataTypeBigDecimal.class.getName(), KEY_MINIMUM_FRACTION_DIGITS, Integer.valueOf(minimumFractionDigits).toString());
        _minimumFractionDigits = minimumFractionDigits;
    }

    public static void setMaximumFractionDigits(int maximumFractionDigits) {
        DataTypeProps.putDataTypeProperty(DataTypeBigDecimal.class.getName(), KEY_MAXIMUM_FRACTION_DIGITS, Integer.valueOf(maximumFractionDigits).toString());
        _maximumFractionDigits = maximumFractionDigits;
    }

    public static void setUserDefinedMinimumFractionDigits(int userDefinedminimumFractionDigits) {
        DataTypeProps.putDataTypeProperty(DataTypeBigDecimal.class.getName(), KEY_USER_DEFINDED_MINIMUM_FRACTION_DIGITS, Integer.valueOf(userDefinedminimumFractionDigits).toString());
        _userDefinedMinimumFractionDigits = userDefinedminimumFractionDigits;
    }

    public static void setUserDefinedMaximumFractionDigits(int userDefinedMaximumFractionDigits) {
        DataTypeProps.putDataTypeProperty(DataTypeBigDecimal.class.getName(), KEY_USER_DEFINDED_MAXIMUM_FRACTION_DIGITS, Integer.valueOf(userDefinedMaximumFractionDigits).toString());
        _userDefinedMaximumFractionDigits = userDefinedMaximumFractionDigits;
    }

    public static void setUserDefinedDecimalSeparator(String userDefinedDecimalSeparator) {
        DataTypeProps.putDataTypeProperty(DataTypeBigDecimal.class.getName(), KEY_USER_DEFINED_DECIMAL_SEPARATOR, userDefinedDecimalSeparator);
        _userDefinedDecimalSeparator = userDefinedDecimalSeparator;
    }

    public static void setUserDefinedGroupingSeparator(String userDefinedGroupingSeparator) {
        DataTypeProps.putDataTypeProperty(DataTypeBigDecimal.class.getName(), KEY_USER_DEFINED_GROUPING_SEPARATOR, userDefinedGroupingSeparator);
        _userDefinedGroupingSeparator = userDefinedGroupingSeparator;
    }

    static void loadProperties() {
        if (!propertiesAlreadyLoaded) {
            _useLocaleFormat = FloatingPointBaseDTProperties.toBoolean(KEY_USE_LOCALE_FORMAT, true);
            _useUserDefinedFormat = FloatingPointBaseDTProperties.toBoolean(KEY_USE_USER_DEFINED_FORMAT, true);
            _useJavaDefaultFormat = FloatingPointBaseDTProperties.toBoolean(KEY_USE_JAVA_DEFAULT_FORMAT, true);
            _minimumFractionDigits = FloatingPointBaseDTProperties.toInteger(KEY_MINIMUM_FRACTION_DIGITS, 0);
            _maximumFractionDigits = FloatingPointBaseDTProperties.toInteger(KEY_MAXIMUM_FRACTION_DIGITS, 5);
            _userDefinedMaximumFractionDigits = FloatingPointBaseDTProperties.toInteger(KEY_USER_DEFINDED_MAXIMUM_FRACTION_DIGITS, 5);
            _userDefinedMinimumFractionDigits = FloatingPointBaseDTProperties.toInteger(KEY_USER_DEFINDED_MINIMUM_FRACTION_DIGITS, 0);
            _userDefinedDecimalSeparator = FloatingPointBaseDTProperties._toString(KEY_USER_DEFINED_DECIMAL_SEPARATOR, ".");
            _userDefinedGroupingSeparator = FloatingPointBaseDTProperties._toString(KEY_USER_DEFINED_GROUPING_SEPARATOR, ",");
            propertiesAlreadyLoaded = true;
        }
    }

    static {
        _useLocaleFormat = false;
        _useUserDefinedFormat = false;
        _useJavaDefaultFormat = false;
        propertiesAlreadyLoaded = false;
    }
}

