/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeProps;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeTimestamp;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeTimestampStatics;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.TemporalScriptGenerationCtrl;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.TemporalScriptGenerationPanel;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.TemporalUtils;

class TimestampOkPanel
extends OkJPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataTypeTimestamp.class);
    private Timestamp _currentTimeStamp = new Timestamp(new Date().getTime());
    private JRadioButton _radUseJavaDefaultFormat = new JRadioButton(s_stringMgr.getString("dateTypeTimestamp.defaultFormat") + "(" + this._currentTimeStamp + ")");
    private JCheckBox _useThreeDigitMillisChk = new JCheckBox(s_stringMgr.getString("dateTypeTimestamp.useThreeDigitMillis") + "(" + this.createThreeDigitMillisExample() + ")");
    private JRadioButton _radUseLocaleDependentFormat = new JRadioButton(s_stringMgr.getString("dateTypeTimestamp.orLocaleDependent"));
    private final ButtonGroup _formatButtonGroup;
    private DateFormatTypeCombo _dateFormatTypeCbo = new DateFormatTypeCombo();
    private JCheckBox _lenientChk = new JCheckBox(s_stringMgr.getString("dateTypeTimestamp.allowInexact"));
    private JRadioButton _radInternalWhereDoNotUse = new JRadioButton(s_stringMgr.getString("dateTypeTimestamp.timestampInWhere"));
    private String _internalWhereEscapeMsg = s_stringMgr.getString("dateTypeTimestamp.jdbcEscape");
    private JRadioButton _radInternalWhereUseTimestampFormat = new JRadioButton(this._internalWhereEscapeMsg + "( \"" + TemporalUtils.getStdJDBCFormat(this._currentTimeStamp) + "\")");
    private String _stringVersionMsg = s_stringMgr.getString("dateTypeTimestamp.stringVersion");
    private JRadioButton _radInternalWhereUseStringFormat = new JRadioButton(this._stringVersionMsg + "(\"" + TemporalUtils.getStringFormat(this._currentTimeStamp) + "\")");
    private ButtonModel[] _radioButtonModels = new ButtonModel[]{this._radInternalWhereDoNotUse.getModel(), this._radInternalWhereUseTimestampFormat.getModel(), this._radInternalWhereUseStringFormat.getModel()};
    private ButtonGroup _btnGroupInternalWhereClauseUsage = new ButtonGroup();
    private TemporalScriptGenerationCtrl _temporalScriptGenerationCtrl;
    private DataTypeTimestampStatics _dataTypeTimestampStatics;

    public TimestampOkPanel(DataTypeTimestampStatics dataTypeTimestampStatics) {
        this._dataTypeTimestampStatics = dataTypeTimestampStatics;
        this._radUseJavaDefaultFormat.setSelected(this._dataTypeTimestampStatics.isUseJavaDefaultFormat());
        this._radUseLocaleDependentFormat.setSelected(false == this._dataTypeTimestampStatics.isUseJavaDefaultFormat());
        this._useThreeDigitMillisChk.setSelected(this._dataTypeTimestampStatics.isUseThreeDigitMillis());
        this._formatButtonGroup = new ButtonGroup();
        this._formatButtonGroup.add(this._radUseJavaDefaultFormat);
        this._formatButtonGroup.add(this._radUseLocaleDependentFormat);
        this._radUseJavaDefaultFormat.addActionListener(e -> this.onRadioButtonChanged());
        this._radUseLocaleDependentFormat.addActionListener(e -> this.onRadioButtonChanged());
        this.onRadioButtonChanged();
        this._dateFormatTypeCbo.setSelectedIndex(this._dataTypeTimestampStatics.getLocaleFormat());
        this._lenientChk.setSelected(this._dataTypeTimestampStatics.isLenient());
        this._btnGroupInternalWhereClauseUsage.add(this._radInternalWhereDoNotUse);
        this._btnGroupInternalWhereClauseUsage.add(this._radInternalWhereUseTimestampFormat);
        this._btnGroupInternalWhereClauseUsage.add(this._radInternalWhereUseStringFormat);
        this._btnGroupInternalWhereClauseUsage.setSelected(this._radioButtonModels[this._dataTypeTimestampStatics.getInternalWhereClauseUsage()], true);
        this._temporalScriptGenerationCtrl = new TemporalScriptGenerationCtrl(TemporalUtils.getStdJDBCFormat(this._currentTimeStamp), TemporalUtils.getStringFormat(this._currentTimeStamp), this._dataTypeTimestampStatics.getTimestampScriptFormat());
        this.layoutPanel();
    }

    private void onRadioButtonChanged() {
        this._dateFormatTypeCbo.setEnabled(this._radUseLocaleDependentFormat.isSelected());
        this._lenientChk.setEnabled(this._radUseLocaleDependentFormat.isSelected());
        this._useThreeDigitMillisChk.setEnabled(this._radUseJavaDefaultFormat.isSelected());
    }

    private void layoutPanel() {
        this.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("dateTypeTimestamp.typeTimestamp")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 1, 0, 1), 0, 0);
        JPanel useDefaultPanel = this.createFormatPanel();
        this.add((Component)useDefaultPanel, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 1, 1, 1), 0, 0);
        JPanel whereClausePanel = this.createInternalWhereClausePanel();
        this.add((Component)whereClausePanel, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 1, 1, 1), 0, 0);
        TemporalScriptGenerationPanel scriptGenerationPanel = this._temporalScriptGenerationCtrl.getPanel();
        this.add((Component)scriptGenerationPanel, gbc);
        GUIUtils.alignPreferredWidths(useDefaultPanel, whereClausePanel, scriptGenerationPanel);
    }

    private JPanel createInternalWhereClausePanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 3, 0, 0), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("dateTypeTimestamp.generateWhereClause")), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 8, 0, 0), 0, 0);
        ret.add((Component)this._radInternalWhereDoNotUse, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 8, 0, 0), 0, 0);
        ret.add((Component)this._radInternalWhereUseTimestampFormat, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 8, 0, 0), 0, 0);
        ret.add((Component)this._radInternalWhereUseStringFormat, gbc);
        gbc = new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        ret.setBorder(BorderFactory.createEtchedBorder());
        return ret;
    }

    private JPanel createFormatPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this._radUseJavaDefaultFormat, gbc);
        gbc = new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(3, 20, 0, 0), 0, 0);
        ret.add((Component)this._useThreeDigitMillisChk, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 0, 0, 0), 0, 0);
        ret.add((Component)this._radUseLocaleDependentFormat, gbc);
        gbc = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 5, 0, 3), 0, 0);
        GUIUtils.setPreferredWidth(this._dateFormatTypeCbo, 250);
        ret.add((Component)this._dateFormatTypeCbo, gbc);
        gbc = new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 18, 0, new Insets(3, 20, 0, 0), 0, 0);
        ret.add((Component)this._lenientChk, gbc);
        ret.setBorder(BorderFactory.createEtchedBorder());
        return ret;
    }

    private Timestamp millisTo0(Timestamp ts) {
        return new Timestamp(ts.getTime() - ts.getTime() % 1000L);
    }

    @Override
    public void ok() {
        int buttonIndex;
        this._dataTypeTimestampStatics.setUseJavaDefaultFormat(this._radUseJavaDefaultFormat.isSelected());
        DataTypeProps.putDataTypeProperty(DataTypeTimestamp.class.getName(), "useJavaDefaultFormat", Boolean.valueOf(this._dataTypeTimestampStatics.isUseJavaDefaultFormat()).toString());
        this._dataTypeTimestampStatics.setUseThreeDigitMillis(this._useThreeDigitMillisChk.isSelected());
        DataTypeProps.putDataTypeProperty(DataTypeTimestamp.class.getName(), "useThreeDigitMillis", Boolean.valueOf(this._dataTypeTimestampStatics.isUseThreeDigitMillis()).toString());
        this._dataTypeTimestampStatics.setLocaleFormat(this._dateFormatTypeCbo.getValue());
        String propertyValue1 = Integer.toString(this._dataTypeTimestampStatics.getLocaleFormat());
        DataTypeProps.putDataTypeProperty(DataTypeTimestamp.class.getName(), "localeFormat", propertyValue1);
        this._dataTypeTimestampStatics.setLenient(this._lenientChk.isSelected());
        DataTypeProps.putDataTypeProperty(DataTypeTimestamp.class.getName(), "lenient", Boolean.valueOf(this._dataTypeTimestampStatics.isLenient()).toString());
        for (buttonIndex = 0; buttonIndex < this._radioButtonModels.length && !this._btnGroupInternalWhereClauseUsage.isSelected(this._radioButtonModels[buttonIndex]); ++buttonIndex) {
        }
        if (buttonIndex > this._radioButtonModels.length) {
            buttonIndex = 1;
        }
        this._dataTypeTimestampStatics.setInternalWhereClauseUsage(buttonIndex);
        String propertyValue = Integer.toString(this._dataTypeTimestampStatics.getInternalWhereClauseUsage());
        DataTypeProps.putDataTypeProperty(DataTypeTimestamp.class.getName(), "whereClauseUsage", propertyValue);
        this._dataTypeTimestampStatics.setTimestampScriptFormat(this._temporalScriptGenerationCtrl.getFormat());
        DataTypeProps.putDataTypeProperty(DataTypeTimestamp.class.getName(), "timestampScriptFormat", this._dataTypeTimestampStatics.getTimestampScriptFormat().name());
        this._dataTypeTimestampStatics.initDateFormat();
    }

    private String createThreeDigitMillisExample() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(this.millisTo0(this._currentTimeStamp));
    }

    public static class DateFormatTypeCombo
    extends JComboBox {
        public DateFormatTypeCombo() {
            this.addItem(s_stringMgr.getString("dataTypeTimestamp.full", DateFormat.getDateTimeInstance(0, 0).format(new Date())));
            this.addItem(s_stringMgr.getString("dataTypeTimestamp.long", DateFormat.getDateTimeInstance(1, 1).format(new Date())));
            this.addItem(s_stringMgr.getString("dataTypeTimestamp.medium", DateFormat.getDateTimeInstance(2, 2).format(new Date())));
            this.addItem(s_stringMgr.getString("dataTypeTimestamp.short", DateFormat.getDateTimeInstance(3, 3).format(new Date())));
        }

        @Override
        public void setSelectedIndex(int option) {
            if (option == 3) {
                super.setSelectedIndex(3);
            } else if (option == 2) {
                super.setSelectedIndex(2);
            } else if (option == 1) {
                super.setSelectedIndex(1);
            } else {
                super.setSelectedIndex(0);
            }
        }

        public int getValue() {
            if (this.getSelectedIndex() == 3) {
                return 3;
            }
            if (this.getSelectedIndex() == 2) {
                return 2;
            }
            if (this.getSelectedIndex() == 1) {
                return 1;
            }
            return 0;
        }
    }
}

